/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.test.support;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.context.IHyracksJobletContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.dataset.IDatasetPartitionManager;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.job.profiling.counters.ICounterContext;
import org.apache.hyracks.api.resources.IDeallocatable;
import org.apache.hyracks.api.resources.IDeallocatableRegistry;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.hyracks.control.nc.io.WorkspaceFileFactory;
import org.apache.hyracks.test.support.CounterContext;
import org.apache.hyracks.test.support.TestJobletContext;

public class TestTaskContext
implements IHyracksTaskContext {
    private final TestJobletContext jobletContext;
    private final TaskAttemptId taskId;
    private WorkspaceFileFactory fileFactory;

    public TestTaskContext(TestJobletContext jobletContext, TaskAttemptId taskId) throws HyracksException {
        this.jobletContext = jobletContext;
        this.taskId = taskId;
        this.fileFactory = new WorkspaceFileFactory((IDeallocatableRegistry)this, (IOManager)this.getIOManager());
    }

    public ByteBuffer allocateFrame() throws HyracksDataException {
        return this.jobletContext.allocateFrame();
    }

    public ByteBuffer allocateFrame(int bytes) throws HyracksDataException {
        return this.jobletContext.allocateFrame(bytes);
    }

    public ByteBuffer reallocateFrame(ByteBuffer tobeDeallocate, int newSizeInBytes, boolean copyOldData) throws HyracksDataException {
        return this.jobletContext.reallocateFrame(tobeDeallocate, newSizeInBytes, copyOldData);
    }

    public void deallocateFrames(int bytes) {
        this.jobletContext.deallocateFrames(bytes);
    }

    public int getInitialFrameSize() {
        return this.jobletContext.getFrameSize();
    }

    public IIOManager getIOManager() {
        return this.jobletContext.getIOManager();
    }

    public FileReference createManagedWorkspaceFile(String prefix) throws HyracksDataException {
        return this.fileFactory.createManagedWorkspaceFile(prefix);
    }

    public FileReference createUnmanagedWorkspaceFile(String prefix) throws HyracksDataException {
        return this.fileFactory.createUnmanagedWorkspaceFile(prefix);
    }

    public IHyracksJobletContext getJobletContext() {
        return this.jobletContext;
    }

    public ICounterContext getCounterContext() {
        return new CounterContext(this.jobletContext.getJobId() + "." + this.taskId);
    }

    public void registerDeallocatable(final IDeallocatable deallocatable) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                deallocatable.deallocate();
            }
        });
    }

    public TaskAttemptId getTaskAttemptId() {
        return this.taskId;
    }

    public void setStateObject(IStateObject taskState) {
    }

    public IStateObject getStateObject(Object id) {
        return null;
    }

    public IDatasetPartitionManager getDatasetPartitionManager() {
        return null;
    }

    public void sendApplicationMessageToCC(byte[] message, DeploymentId deploymentId, String nodeId) throws Exception {
    }
}

