/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.test.support;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.hyracks.storage.am.common.api.IIndexLifecycleManager;
import org.apache.hyracks.storage.am.common.dataflow.IndexLifecycleManager;
import org.apache.hyracks.storage.common.buffercache.BufferCache;
import org.apache.hyracks.storage.common.buffercache.ClockPageReplacementStrategy;
import org.apache.hyracks.storage.common.buffercache.DelayPageCleanerPolicy;
import org.apache.hyracks.storage.common.buffercache.HeapBufferAllocator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICacheMemoryAllocator;
import org.apache.hyracks.storage.common.buffercache.IPageCleanerPolicy;
import org.apache.hyracks.storage.common.buffercache.IPageReplacementStrategy;
import org.apache.hyracks.storage.common.file.IFileMapManager;
import org.apache.hyracks.storage.common.file.IFileMapProvider;
import org.apache.hyracks.storage.common.file.ILocalResourceRepository;
import org.apache.hyracks.storage.common.file.ResourceIdFactory;
import org.apache.hyracks.storage.common.file.ResourceIdFactoryProvider;
import org.apache.hyracks.storage.common.file.TransientFileMapManager;
import org.apache.hyracks.storage.common.file.TransientLocalResourceRepositoryFactory;

public class TestStorageManagerComponentHolder {
    private static IBufferCache bufferCache;
    private static IFileMapProvider fileMapProvider;
    private static IOManager ioManager;
    private static ILocalResourceRepository localResourceRepository;
    private static IIndexLifecycleManager lcManager;
    private static ResourceIdFactory resourceIdFactory;
    private static int pageSize;
    private static int numPages;
    private static int maxOpenFiles;
    private static final ThreadFactory threadFactory;

    public static void init(int pageSize, int numPages, int maxOpenFiles) {
        TestStorageManagerComponentHolder.pageSize = pageSize;
        TestStorageManagerComponentHolder.numPages = numPages;
        TestStorageManagerComponentHolder.maxOpenFiles = maxOpenFiles;
        bufferCache = null;
        fileMapProvider = null;
        localResourceRepository = null;
        lcManager = null;
    }

    public static synchronized IIndexLifecycleManager getIndexLifecycleManager(IHyracksTaskContext ctx) {
        if (lcManager == null) {
            lcManager = new IndexLifecycleManager();
        }
        return lcManager;
    }

    public static synchronized IBufferCache getBufferCache(IHyracksTaskContext ctx) {
        if (bufferCache == null) {
            HeapBufferAllocator allocator = new HeapBufferAllocator();
            ClockPageReplacementStrategy prs = new ClockPageReplacementStrategy((ICacheMemoryAllocator)allocator, pageSize, numPages);
            IFileMapProvider fileMapProvider = TestStorageManagerComponentHolder.getFileMapProvider(ctx);
            bufferCache = new BufferCache(ctx.getIOManager(), (IPageReplacementStrategy)prs, (IPageCleanerPolicy)new DelayPageCleanerPolicy(1000L), (IFileMapManager)fileMapProvider, maxOpenFiles, threadFactory);
        }
        return bufferCache;
    }

    public static synchronized IFileMapProvider getFileMapProvider(IHyracksTaskContext ctx) {
        if (fileMapProvider == null) {
            fileMapProvider = new TransientFileMapManager();
        }
        return fileMapProvider;
    }

    public static synchronized IOManager getIOManager() throws HyracksException {
        if (ioManager == null) {
            ArrayList<IODeviceHandle> devices = new ArrayList<IODeviceHandle>();
            devices.add(new IODeviceHandle(new File(System.getProperty("java.io.tmpdir")), "iodev_test_wa"));
            ioManager = new IOManager(devices, (Executor)Executors.newCachedThreadPool());
        }
        return ioManager;
    }

    public static synchronized ILocalResourceRepository getLocalResourceRepository(IHyracksTaskContext ctx) {
        if (localResourceRepository == null) {
            try {
                TransientLocalResourceRepositoryFactory localResourceRepositoryFactory = new TransientLocalResourceRepositoryFactory();
                localResourceRepository = localResourceRepositoryFactory.createRepository();
            }
            catch (HyracksException e) {
                throw new IllegalArgumentException();
            }
        }
        return localResourceRepository;
    }

    public static synchronized ResourceIdFactory getResourceIdFactory(IHyracksTaskContext ctx) {
        if (resourceIdFactory == null) {
            try {
                ResourceIdFactoryProvider resourceIdFactoryFactory = new ResourceIdFactoryProvider(TestStorageManagerComponentHolder.getLocalResourceRepository(ctx));
                resourceIdFactory = resourceIdFactoryFactory.createResourceIdFactory();
            }
            catch (HyracksException e) {
                throw new IllegalArgumentException();
            }
        }
        return resourceIdFactory;
    }

    static {
        threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r);
            }
        };
    }
}

