/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.test.support;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.application.INCApplicationContext;
import org.apache.hyracks.api.context.IHyracksJobletContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.profiling.counters.ICounterContext;
import org.apache.hyracks.api.resources.IDeallocatable;
import org.apache.hyracks.api.resources.IDeallocatableRegistry;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.hyracks.control.nc.io.WorkspaceFileFactory;
import org.apache.hyracks.control.nc.resources.memory.FrameManager;
import org.apache.hyracks.test.support.CounterContext;

public class TestJobletContext
implements IHyracksJobletContext {
    private final int frameSize;
    private final INCApplicationContext appContext;
    private final FrameManager frameManger;
    private JobId jobId;
    private WorkspaceFileFactory fileFactory;

    public TestJobletContext(int frameSize, INCApplicationContext appContext, JobId jobId) throws HyracksException {
        this.frameSize = frameSize;
        this.appContext = appContext;
        this.jobId = jobId;
        this.fileFactory = new WorkspaceFileFactory((IDeallocatableRegistry)this, (IOManager)this.getIOManager());
        this.frameManger = new FrameManager(frameSize);
    }

    ByteBuffer allocateFrame() throws HyracksDataException {
        return this.frameManger.allocateFrame();
    }

    public ByteBuffer allocateFrame(int bytes) throws HyracksDataException {
        return this.frameManger.allocateFrame(bytes);
    }

    ByteBuffer reallocateFrame(ByteBuffer tobeDeallocate, int newFrameSizeInBytes, boolean copyOldData) throws HyracksDataException {
        return this.frameManger.reallocateFrame(tobeDeallocate, newFrameSizeInBytes, copyOldData);
    }

    void deallocateFrames(int bytes) {
        this.frameManger.deallocateFrames(bytes);
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public IIOManager getIOManager() {
        return this.appContext.getRootContext().getIOManager();
    }

    public FileReference createManagedWorkspaceFile(String prefix) throws HyracksDataException {
        return this.fileFactory.createManagedWorkspaceFile(prefix);
    }

    public FileReference createUnmanagedWorkspaceFile(String prefix) throws HyracksDataException {
        return this.fileFactory.createUnmanagedWorkspaceFile(prefix);
    }

    public ICounterContext getCounterContext() {
        return new CounterContext(this.jobId.toString());
    }

    public void registerDeallocatable(final IDeallocatable deallocatable) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                deallocatable.deallocate();
            }
        });
    }

    public INCApplicationContext getApplicationContext() {
        return this.appContext;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public Object getGlobalJobData() {
        return null;
    }

    public Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }
}

