/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree;

import org.apache.hyracks.storage.am.common.CheckTuple;

public class RTreeCheckTuple<T>
extends CheckTuple {
    public RTreeCheckTuple(int numFields, int numKeys) {
        super(numFields, numKeys);
    }

    @Override
    public boolean equals(Object o) {
        RTreeCheckTuple other = (RTreeCheckTuple)o;
        for (int i = 0; i < this.fields.length; ++i) {
            int cmp = this.fields[i].compareTo(other.getField(i));
            if (cmp == 0) continue;
            return false;
        }
        return true;
    }

    public boolean intersect(T o) {
        RTreeCheckTuple other = (RTreeCheckTuple)o;
        int maxFieldPos = this.numKeys / 2;
        for (int i = 0; i < maxFieldPos; ++i) {
            int j = maxFieldPos + i;
            int cmp = this.fields[i].compareTo(other.getField(j));
            if (cmp > 0) {
                return false;
            }
            cmp = this.fields[j].compareTo(other.getField(i));
            if (cmp >= 0) continue;
            return false;
        }
        return true;
    }
}

