/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common;

import org.apache.hyracks.storage.am.common.datagen.ProbabilityHelper;

public class TestOperationSelector {
    private final TestOperation[] ops;
    private final int[] cumulIntRanges;

    public TestOperationSelector(TestOperation[] ops, double[] opProbs) {
        this.sanityCheck(ops, opProbs);
        this.ops = ops;
        this.cumulIntRanges = ProbabilityHelper.getCumulIntRanges((double[])opProbs);
    }

    private void sanityCheck(TestOperation[] ops, double[] opProbs) {
        if (ops.length == 0) {
            throw new RuntimeException("Empty op array.");
        }
        if (opProbs.length == 0) {
            throw new RuntimeException("Empty op probabilities.");
        }
        if (ops.length != opProbs.length) {
            throw new RuntimeException("Ops and op probabilities have unequal length.");
        }
        float sum = 0.0f;
        for (int i = 0; i < opProbs.length; ++i) {
            sum = (float)((double)sum + opProbs[i]);
        }
        if (sum != 1.0f) {
            throw new RuntimeException("Op probabilities don't add up to 1.");
        }
    }

    public TestOperation getOp(int randomInt) {
        int ix = ProbabilityHelper.choose((int[])this.cumulIntRanges, (int)randomInt);
        return this.ops[ix];
    }

    public static enum TestOperation {
        INSERT,
        DELETE,
        UPDATE,
        UPSERT,
        POINT_SEARCH,
        RANGE_SEARCH,
        SCAN,
        DISKORDER_SCAN,
        MERGE;

    }
}

