/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree;

import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.UTF8StringSerializerDeserializer;
import org.apache.hyracks.storage.am.btree.OrderedIndexTestContext;
import org.apache.hyracks.storage.am.btree.OrderedIndexTestDriver;
import org.apache.hyracks.storage.am.btree.OrderedIndexTestUtils;
import org.apache.hyracks.storage.am.btree.frames.BTreeLeafFrameType;

public abstract class OrderedIndexInsertTest
extends OrderedIndexTestDriver {
    private final OrderedIndexTestUtils orderedIndexTestUtils = new OrderedIndexTestUtils();

    public OrderedIndexInsertTest(BTreeLeafFrameType[] leafFrameTypesToTest) {
        super(leafFrameTypesToTest);
    }

    @Override
    protected void runTest(ISerializerDeserializer[] fieldSerdes, int numKeys, BTreeLeafFrameType leafType, ITupleReference lowKey, ITupleReference highKey, ITupleReference prefixLowKey, ITupleReference prefixHighKey) throws Exception {
        OrderedIndexTestContext ctx = this.createTestContext(fieldSerdes, numKeys, leafType);
        ctx.getIndex().create();
        ctx.getIndex().activate();
        if (fieldSerdes[0] instanceof IntegerSerializerDeserializer) {
            this.orderedIndexTestUtils.insertIntTuples(ctx, 100, this.getRandom());
        } else if (fieldSerdes[0] instanceof UTF8StringSerializerDeserializer) {
            this.orderedIndexTestUtils.insertStringTuples(ctx, 100, this.getRandom());
        }
        this.orderedIndexTestUtils.checkPointSearches(ctx);
        this.orderedIndexTestUtils.checkScan(ctx);
        this.orderedIndexTestUtils.checkDiskOrderScan(ctx);
        this.orderedIndexTestUtils.checkRangeSearch(ctx, lowKey, highKey, true, true);
        if (prefixLowKey != null && prefixHighKey != null) {
            this.orderedIndexTestUtils.checkRangeSearch(ctx, prefixLowKey, prefixHighKey, true, true);
        }
        ctx.getIndex().validate();
        ctx.getIndex().deactivate();
        ctx.getIndex().destroy();
    }

    @Override
    protected String getTestOpName() {
        return "Insert";
    }
}

