/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree;

import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.data.std.accessors.PointableBinaryComparatorFactory;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.UTF8StringSerializerDeserializer;
import org.apache.hyracks.dataflow.common.util.TupleUtils;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.TestOperationCallback;
import org.apache.hyracks.storage.am.common.api.IIndexAccessor;
import org.apache.hyracks.storage.am.common.api.IIndexBulkLoader;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.api.TreeIndexException;
import org.apache.hyracks.storage.am.common.api.UnsortedInputException;
import org.apache.hyracks.storage.am.common.exceptions.TreeIndexDuplicateKeyException;
import org.apache.hyracks.storage.am.common.impls.TreeIndexDiskOrderScanCursor;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.junit.Assert;
import org.junit.Test;

public abstract class OrderedIndexExamplesTest {
    protected static final Logger LOGGER = Logger.getLogger(OrderedIndexExamplesTest.class.getName());
    protected final Random rnd = new Random(50L);

    protected abstract ITreeIndex createTreeIndex(ITypeTraits[] var1, IBinaryComparatorFactory[] var2, int[] var3, ITypeTraits[] var4, IBinaryComparatorFactory[] var5, int[] var6, int[] var7) throws TreeIndexException;

    @Test
    public void fixedLengthKeyValueExample() throws Exception {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Fixed-Length Key,Value Example.");
        }
        int fieldCount = 2;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = IntegerPointable.TYPE_TRAITS;
        typeTraits[1] = IntegerPointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE};
        int keyFieldCount = 1;
        IBinaryComparatorFactory[] cmpFactories = new IBinaryComparatorFactory[keyFieldCount];
        cmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        int[] bloomFilterKeyFields = new int[keyFieldCount];
        bloomFilterKeyFields[0] = 0;
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, cmpFactories, bloomFilterKeyFields, null, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        long start = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Inserting into tree...");
        }
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
        int numInserts = 10000;
        for (int i = 0; i < numInserts; ++i) {
            int f0 = this.rnd.nextInt() % numInserts;
            int f1 = 5;
            TupleUtils.createIntegerTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (int[])new int[]{f0, f1});
            if (LOGGER.isLoggable(Level.INFO) && i % 1000 == 0) {
                LOGGER.info("Inserting " + i + " : " + f0 + " " + f1);
            }
            try {
                indexAccessor.insert((ITupleReference)tuple);
                continue;
            }
            catch (TreeIndexException treeIndexException) {
                // empty catch block
            }
        }
        long end = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(numInserts + " inserts in " + (end - start) + "ms");
        }
        this.orderedScan(indexAccessor, fieldSerdes);
        this.diskOrderScan(indexAccessor, fieldSerdes);
        ArrayTupleBuilder lowKeyTb = new ArrayTupleBuilder(keyFieldCount);
        ArrayTupleReference lowKey = new ArrayTupleReference();
        TupleUtils.createIntegerTuple((ArrayTupleBuilder)lowKeyTb, (ArrayTupleReference)lowKey, (int[])new int[]{-1000});
        ArrayTupleBuilder highKeyTb = new ArrayTupleBuilder(keyFieldCount);
        ArrayTupleReference highKey = new ArrayTupleReference();
        TupleUtils.createIntegerTuple((ArrayTupleBuilder)highKeyTb, (ArrayTupleReference)highKey, (int[])new int[]{1000});
        this.rangeSearch(cmpFactories, indexAccessor, fieldSerdes, (ITupleReference)lowKey, (ITupleReference)highKey, null, null);
        treeIndex.validate();
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void pageSplitTestExample() throws Exception {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("BTree page split test.");
        }
        int fieldCount = 2;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = UTF8StringPointable.TYPE_TRAITS;
        typeTraits[1] = UTF8StringPointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{UTF8StringSerializerDeserializer.INSTANCE, UTF8StringSerializerDeserializer.INSTANCE};
        int keyFieldCount = 1;
        IBinaryComparatorFactory[] cmpFactories = new IBinaryComparatorFactory[keyFieldCount];
        cmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)UTF8StringPointable.FACTORY);
        int[] bloomFilterKeyFields = new int[keyFieldCount];
        bloomFilterKeyFields[0] = 0;
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, cmpFactories, bloomFilterKeyFields, null, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
        String key = "111";
        String data = "XXX";
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{key, data});
        indexAccessor.insert((ITupleReference)tuple);
        key = "222";
        data = "XXX";
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{key, data});
        indexAccessor.insert((ITupleReference)tuple);
        key = "333";
        data = "XXX";
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{key, data});
        indexAccessor.insert((ITupleReference)tuple);
        key = "444";
        data = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{key, data});
        indexAccessor.insert((ITupleReference)tuple);
        key = "555";
        data = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{key, data});
        indexAccessor.insert((ITupleReference)tuple);
        key = "666";
        data = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{key, data});
        indexAccessor.insert((ITupleReference)tuple);
        treeIndex.validate();
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void twoFixedLengthKeysOneFixedLengthValueExample() throws Exception {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Composite Key Test");
        }
        int fieldCount = 3;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = IntegerPointable.TYPE_TRAITS;
        typeTraits[1] = IntegerPointable.TYPE_TRAITS;
        typeTraits[2] = IntegerPointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE};
        int keyFieldCount = 2;
        IBinaryComparatorFactory[] cmpFactories = new IBinaryComparatorFactory[keyFieldCount];
        cmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        cmpFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        int[] bloomFilterKeyFields = new int[keyFieldCount];
        bloomFilterKeyFields[0] = 0;
        bloomFilterKeyFields[1] = 1;
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, cmpFactories, bloomFilterKeyFields, null, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        long start = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Inserting into tree...");
        }
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
        int numInserts = 10000;
        for (int i = 0; i < 10000; ++i) {
            int f0 = this.rnd.nextInt() % 2000;
            int f1 = this.rnd.nextInt() % 1000;
            int f2 = 5;
            TupleUtils.createIntegerTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (int[])new int[]{f0, f1, f2});
            if (LOGGER.isLoggable(Level.INFO) && i % 1000 == 0) {
                LOGGER.info("Inserting " + i + " : " + f0 + " " + f1 + " " + f2);
            }
            try {
                indexAccessor.insert((ITupleReference)tuple);
                continue;
            }
            catch (TreeIndexException treeIndexException) {
                // empty catch block
            }
        }
        long end = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(numInserts + " inserts in " + (end - start) + "ms");
        }
        this.orderedScan(indexAccessor, fieldSerdes);
        this.diskOrderScan(indexAccessor, fieldSerdes);
        ArrayTupleBuilder lowKeyTb = new ArrayTupleBuilder(1);
        ArrayTupleReference lowKey = new ArrayTupleReference();
        TupleUtils.createIntegerTuple((ArrayTupleBuilder)lowKeyTb, (ArrayTupleReference)lowKey, (int[])new int[]{-3});
        ArrayTupleBuilder highKeyTb = new ArrayTupleBuilder(1);
        ArrayTupleReference highKey = new ArrayTupleReference();
        TupleUtils.createIntegerTuple((ArrayTupleBuilder)highKeyTb, (ArrayTupleReference)highKey, (int[])new int[]{3});
        this.rangeSearch(cmpFactories, indexAccessor, fieldSerdes, (ITupleReference)lowKey, (ITupleReference)highKey, null, null);
        treeIndex.validate();
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void varLenKeyValueExample() throws Exception {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Variable-Length Key,Value Example");
        }
        int fieldCount = 2;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = UTF8StringPointable.TYPE_TRAITS;
        typeTraits[1] = UTF8StringPointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{UTF8StringSerializerDeserializer.INSTANCE, UTF8StringSerializerDeserializer.INSTANCE};
        int keyFieldCount = 1;
        IBinaryComparatorFactory[] cmpFactories = new IBinaryComparatorFactory[keyFieldCount];
        cmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)UTF8StringPointable.FACTORY);
        int[] bloomFilterKeyFields = new int[keyFieldCount];
        bloomFilterKeyFields[0] = 0;
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, cmpFactories, bloomFilterKeyFields, null, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        long start = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Inserting into tree...");
        }
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
        int maxLength = 10;
        int numInserts = 10000;
        for (int i = 0; i < 10000; ++i) {
            String f0 = OrderedIndexExamplesTest.randomString(Math.abs(this.rnd.nextInt()) % maxLength + 1, this.rnd);
            String f1 = OrderedIndexExamplesTest.randomString(Math.abs(this.rnd.nextInt()) % maxLength + 1, this.rnd);
            TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{f0, f1});
            if (LOGGER.isLoggable(Level.INFO) && i % 1000 == 0) {
                LOGGER.info("Inserting[" + i + "] " + f0 + " " + f1);
            }
            try {
                indexAccessor.insert((ITupleReference)tuple);
                continue;
            }
            catch (TreeIndexException treeIndexException) {
                // empty catch block
            }
        }
        long end = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(numInserts + " inserts in " + (end - start) + "ms");
        }
        this.orderedScan(indexAccessor, fieldSerdes);
        this.diskOrderScan(indexAccessor, fieldSerdes);
        ArrayTupleBuilder lowKeyTb = new ArrayTupleBuilder(1);
        ArrayTupleReference lowKey = new ArrayTupleReference();
        TupleUtils.createTuple((ArrayTupleBuilder)lowKeyTb, (ArrayTupleReference)lowKey, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{"cbf"});
        ArrayTupleBuilder highKeyTb = new ArrayTupleBuilder(1);
        ArrayTupleReference highKey = new ArrayTupleReference();
        TupleUtils.createTuple((ArrayTupleBuilder)highKeyTb, (ArrayTupleReference)highKey, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{"cc7"});
        this.rangeSearch(cmpFactories, indexAccessor, fieldSerdes, (ITupleReference)lowKey, (ITupleReference)highKey, null, null);
        treeIndex.validate();
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void deleteExample() throws Exception {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Deletion Example");
        }
        int fieldCount = 2;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = UTF8StringPointable.TYPE_TRAITS;
        typeTraits[1] = UTF8StringPointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{UTF8StringSerializerDeserializer.INSTANCE, UTF8StringSerializerDeserializer.INSTANCE};
        int keyFieldCount = 1;
        IBinaryComparatorFactory[] cmpFactories = new IBinaryComparatorFactory[keyFieldCount];
        cmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)UTF8StringPointable.FACTORY);
        int[] bloomFilterKeyFields = new int[keyFieldCount];
        bloomFilterKeyFields[0] = 0;
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, cmpFactories, bloomFilterKeyFields, null, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
        int runs = 3;
        for (int run = 0; run < runs; ++run) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Deletion example run: " + (run + 1) + "/" + runs);
                LOGGER.info("Inserting into tree...");
            }
            int maxLength = 10;
            int ins = 10000;
            String[] f0s = new String[ins];
            String[] f1s = new String[ins];
            int insDone = 0;
            int[] insDoneCmp = new int[ins];
            for (int i = 0; i < ins; ++i) {
                String f0 = OrderedIndexExamplesTest.randomString(Math.abs(this.rnd.nextInt()) % maxLength + 1, this.rnd);
                String f1 = OrderedIndexExamplesTest.randomString(Math.abs(this.rnd.nextInt()) % maxLength + 1, this.rnd);
                TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{f0, f1});
                f0s[i] = f0;
                f1s[i] = f1;
                if (LOGGER.isLoggable(Level.INFO) && i % 1000 == 0) {
                    LOGGER.info("Inserting " + i);
                }
                try {
                    indexAccessor.insert((ITupleReference)tuple);
                }
                catch (TreeIndexException treeIndexException) {
                    // empty catch block
                }
                insDoneCmp[i] = ++insDone;
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Deleting from tree...");
            }
            int delDone = 0;
            for (int i = 0; i < ins; ++i) {
                TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{f0s[i], f1s[i]});
                if (LOGGER.isLoggable(Level.INFO) && i % 1000 == 0) {
                    LOGGER.info("Deleting " + i);
                }
                try {
                    indexAccessor.delete((ITupleReference)tuple);
                    ++delDone;
                }
                catch (TreeIndexException treeIndexException) {
                    // empty catch block
                }
                if (insDoneCmp[i] == delDone) continue;
                if (!LOGGER.isLoggable(Level.INFO)) break;
                LOGGER.info("INCONSISTENT STATE, ERROR IN DELETION EXAMPLE.");
                LOGGER.info("INSDONECMP: " + insDoneCmp[i] + " " + delDone);
                break;
            }
            if (insDone == delDone) continue;
            if (!LOGGER.isLoggable(Level.INFO)) break;
            LOGGER.info("ERROR! INSDONE: " + insDone + " DELDONE: " + delDone);
            break;
        }
        treeIndex.validate();
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void updateExample() throws Exception {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Update example");
        }
        int fieldCount = 2;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = UTF8StringPointable.TYPE_TRAITS;
        typeTraits[1] = UTF8StringPointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{UTF8StringSerializerDeserializer.INSTANCE, UTF8StringSerializerDeserializer.INSTANCE};
        int keyFieldCount = 1;
        IBinaryComparatorFactory[] cmpFactories = new IBinaryComparatorFactory[keyFieldCount];
        cmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)UTF8StringPointable.FACTORY);
        int[] bloomFilterKeyFields = new int[keyFieldCount];
        bloomFilterKeyFields[0] = 0;
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, cmpFactories, bloomFilterKeyFields, null, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Inserting into tree...");
        }
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        int maxLength = 10;
        int ins = 10000;
        String[] keys = new String[10000];
        for (int i = 0; i < ins; ++i) {
            String f0 = OrderedIndexExamplesTest.randomString(Math.abs(this.rnd.nextInt()) % maxLength + 1, this.rnd);
            String f1 = OrderedIndexExamplesTest.randomString(Math.abs(this.rnd.nextInt()) % maxLength + 1, this.rnd);
            TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{f0, f1});
            keys[i] = f0;
            if (LOGGER.isLoggable(Level.INFO) && i % 1000 == 0) {
                LOGGER.info("Inserting " + i);
            }
            try {
                indexAccessor.insert((ITupleReference)tuple);
                continue;
            }
            catch (TreeIndexException treeIndexException) {
                // empty catch block
            }
        }
        this.orderedScan(indexAccessor, fieldSerdes);
        int runs = 3;
        for (int run = 0; run < runs; ++run) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Update test run: " + (run + 1) + "/" + runs);
                LOGGER.info("Updating BTree");
            }
            for (int i = 0; i < ins; ++i) {
                String f1 = OrderedIndexExamplesTest.randomString(Math.abs(this.rnd.nextInt()) % maxLength + 1, this.rnd);
                TupleUtils.createTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (ISerializerDeserializer[])fieldSerdes, (Object[])new Object[]{keys[i], f1});
                if (LOGGER.isLoggable(Level.INFO) && i % 1000 == 0) {
                    LOGGER.info("Updating " + i);
                }
                try {
                    indexAccessor.update((ITupleReference)tuple);
                    continue;
                }
                catch (TreeIndexException treeIndexException) {
                    continue;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            this.orderedScan(indexAccessor, fieldSerdes);
        }
        treeIndex.validate();
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void bulkLoadExample() throws Exception {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Bulk load example");
        }
        int fieldCount = 3;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = IntegerPointable.TYPE_TRAITS;
        typeTraits[1] = IntegerPointable.TYPE_TRAITS;
        typeTraits[2] = IntegerPointable.TYPE_TRAITS;
        ISerializerDeserializer[] fieldSerdes = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE, IntegerSerializerDeserializer.INSTANCE};
        int keyFieldCount = 2;
        IBinaryComparatorFactory[] cmpFactories = new IBinaryComparatorFactory[keyFieldCount];
        cmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        cmpFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        int[] bloomFilterKeyFields = new int[keyFieldCount];
        bloomFilterKeyFields[0] = 0;
        bloomFilterKeyFields[1] = 1;
        ITreeIndex treeIndex = this.createTreeIndex(typeTraits, cmpFactories, bloomFilterKeyFields, null, null, null, null);
        treeIndex.create();
        treeIndex.activate();
        int ins = 100000;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Bulk loading " + ins + " tuples");
        }
        long start = System.currentTimeMillis();
        IIndexBulkLoader bulkLoader = treeIndex.createBulkLoader(0.7f, false, (long)ins, true);
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        int i = 0;
        while (i < ins) {
            TupleUtils.createIntegerTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (int[])new int[]{i, i++, 5});
            bulkLoader.add((ITupleReference)tuple);
        }
        bulkLoader.end();
        long end = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(ins + " tuples loaded in " + (end - start) + "ms");
        }
        IIndexAccessor indexAccessor = treeIndex.createAccessor((IModificationOperationCallback)TestOperationCallback.INSTANCE, (ISearchOperationCallback)TestOperationCallback.INSTANCE);
        ArrayTupleBuilder lowKeyTb = new ArrayTupleBuilder(1);
        ArrayTupleReference lowKey = new ArrayTupleReference();
        TupleUtils.createIntegerTuple((ArrayTupleBuilder)lowKeyTb, (ArrayTupleReference)lowKey, (int[])new int[]{44444});
        ArrayTupleBuilder highKeyTb = new ArrayTupleBuilder(1);
        ArrayTupleReference highKey = new ArrayTupleReference();
        TupleUtils.createIntegerTuple((ArrayTupleBuilder)highKeyTb, (ArrayTupleReference)highKey, (int[])new int[]{44500});
        this.rangeSearch(cmpFactories, indexAccessor, fieldSerdes, (ITupleReference)lowKey, (ITupleReference)highKey, null, null);
        treeIndex.validate();
        treeIndex.deactivate();
        treeIndex.destroy();
    }

    @Test
    public void bulkOrderVerificationExample() throws Exception {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Bulk load order verification example");
        }
        int fieldCount = 2;
        ITypeTraits[] typeTraits = new ITypeTraits[fieldCount];
        typeTraits[0] = IntegerPointable.TYPE_TRAITS;
        typeTraits[1] = IntegerPointable.TYPE_TRAITS;
        int keyFieldCount = 1;
        IBinaryComparatorFactory[] cmpFactories = new IBinaryComparatorFactory[keyFieldCount];
        cmpFactories[0] = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY);
        Random rnd = new Random();
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        ArrayTupleReference tuple = new ArrayTupleReference();
        int[] bloomFilterKeyFields = new int[keyFieldCount];
        bloomFilterKeyFields[0] = 0;
        int ins = 1000;
        for (int i = 1; i < ins; ++i) {
            ITreeIndex treeIndex = this.createTreeIndex(typeTraits, cmpFactories, bloomFilterKeyFields, null, null, null, null);
            treeIndex.create();
            treeIndex.activate();
            IIndexBulkLoader bulkLoader = treeIndex.createBulkLoader(0.7f, true, (long)ins, true);
            for (int j = 0; j < ins; ++j) {
                int swapElementCase;
                if (j > i) {
                    Assert.fail((String)("Bulk load failure test unexpectedly succeeded past tuple: " + j));
                }
                int key = j;
                if (j == i && (swapElementCase = Math.abs(rnd.nextInt()) % 2) != 0) {
                    key = (int)((double)key - (Math.abs(Math.random() % (double)(ins - 1)) + 1.0));
                }
                TupleUtils.createIntegerTuple((ArrayTupleBuilder)tb, (ArrayTupleReference)tuple, (int[])new int[]{--key, 5});
                try {
                    bulkLoader.add((ITupleReference)tuple);
                    continue;
                }
                catch (UnsortedInputException e) {
                    if (j == i) break;
                    Assert.fail((String)("Unexpected exception: " + e.getMessage()));
                    break;
                }
                catch (TreeIndexDuplicateKeyException e2) {
                    if (j == i) break;
                    Assert.fail((String)("Unexpected exception: " + e2.getMessage()));
                    break;
                }
            }
            treeIndex.deactivate();
            treeIndex.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void orderedScan(IIndexAccessor indexAccessor, ISerializerDeserializer[] fieldSerdes) throws Exception {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Ordered Scan:");
        }
        IIndexCursor scanCursor = indexAccessor.createSearchCursor(false);
        RangePredicate nullPred = new RangePredicate(null, null, true, true, null, null);
        indexAccessor.search(scanCursor, (ISearchPredicate)nullPred);
        try {
            while (scanCursor.hasNext()) {
                scanCursor.next();
                ITupleReference frameTuple = scanCursor.getTuple();
                String rec = TupleUtils.printTuple((ITupleReference)frameTuple, (ISerializerDeserializer[])fieldSerdes);
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info(rec);
            }
        }
        finally {
            scanCursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void diskOrderScan(IIndexAccessor indexAccessor, ISerializerDeserializer[] fieldSerdes) throws Exception {
        block9: {
            try {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Disk-Order Scan:");
                }
                ITreeIndexAccessor treeIndexAccessor = (ITreeIndexAccessor)indexAccessor;
                treeIndexAccessor.diskOrderScan((ITreeIndexCursor)diskOrderCursor);
                try (TreeIndexDiskOrderScanCursor diskOrderCursor = (TreeIndexDiskOrderScanCursor)treeIndexAccessor.createDiskOrderScanCursor();){
                    while (diskOrderCursor.hasNext()) {
                        diskOrderCursor.next();
                        ITreeIndexTupleReference frameTuple = diskOrderCursor.getTuple();
                        String rec = TupleUtils.printTuple((ITupleReference)frameTuple, (ISerializerDeserializer[])fieldSerdes);
                        if (!LOGGER.isLoggable(Level.INFO)) continue;
                        LOGGER.info(rec);
                    }
                }
            }
            catch (UnsupportedOperationException e) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Ignoring disk-order scan since it's not supported.");
                }
            }
            catch (ClassCastException e) {
                if (!LOGGER.isLoggable(Level.INFO)) break block9;
                LOGGER.info("Ignoring disk-order scan since it's not supported.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rangeSearch(IBinaryComparatorFactory[] cmpFactories, IIndexAccessor indexAccessor, ISerializerDeserializer[] fieldSerdes, ITupleReference lowKey, ITupleReference highKey, ITupleReference minFilterTuple, ITupleReference maxFilterTuple) throws Exception {
        if (LOGGER.isLoggable(Level.INFO)) {
            String lowKeyString = TupleUtils.printTuple((ITupleReference)lowKey, (ISerializerDeserializer[])fieldSerdes);
            String highKeyString = TupleUtils.printTuple((ITupleReference)highKey, (ISerializerDeserializer[])fieldSerdes);
            LOGGER.info("Range-Search in: [ " + lowKeyString + ", " + highKeyString + "]");
        }
        ITreeIndexCursor rangeCursor = (ITreeIndexCursor)indexAccessor.createSearchCursor(false);
        MultiComparator lowKeySearchCmp = BTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])cmpFactories, (ITupleReference)lowKey);
        MultiComparator highKeySearchCmp = BTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])cmpFactories, (ITupleReference)highKey);
        RangePredicate rangePred = minFilterTuple != null && maxFilterTuple != null ? new RangePredicate(lowKey, highKey, true, true, lowKeySearchCmp, highKeySearchCmp, minFilterTuple, maxFilterTuple) : new RangePredicate(lowKey, highKey, true, true, lowKeySearchCmp, highKeySearchCmp);
        indexAccessor.search((IIndexCursor)rangeCursor, (ISearchPredicate)rangePred);
        try {
            while (rangeCursor.hasNext()) {
                rangeCursor.next();
                ITupleReference frameTuple = rangeCursor.getTuple();
                String rec = TupleUtils.printTuple((ITupleReference)frameTuple, (ISerializerDeserializer[])fieldSerdes);
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info(rec);
            }
        }
        finally {
            rangeCursor.close();
        }
    }

    public static String randomString(int length, Random random) {
        String s = Long.toHexString(Double.doubleToLongBits(random.nextDouble()));
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < s.length() && i < length; ++i) {
            strBuilder.append(s.charAt(Math.abs(random.nextInt()) % s.length()));
        }
        return strBuilder.toString();
    }
}

