/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.util.TupleUtils;
import org.apache.hyracks.storage.am.btree.AbstractOperationCallbackTest;
import org.apache.hyracks.storage.am.common.api.IIndexAccessor;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractModificationOperationCallbackTest
extends AbstractOperationCallbackTest {
    protected final ArrayTupleBuilder builder = new ArrayTupleBuilder(1);
    protected final ArrayTupleReference tuple = new ArrayTupleReference();
    protected final IModificationOperationCallback cb = new VeriyfingModificationCallback();
    protected boolean isFoundNull = true;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void modificationCallbackTest() throws Exception {
        IIndexAccessor accessor = this.index.createAccessor(this.cb, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        this.isFoundNull = true;
        int i = 0;
        while (i < 100) {
            TupleUtils.createIntegerTuple((ArrayTupleBuilder)this.builder, (ArrayTupleReference)this.tuple, (int[])new int[]{i++});
            accessor.insert((ITupleReference)this.tuple);
        }
        this.isFoundNull = false;
        i = 0;
        while (i < 100) {
            TupleUtils.createIntegerTuple((ArrayTupleBuilder)this.builder, (ArrayTupleReference)this.tuple, (int[])new int[]{i++});
            accessor.upsert((ITupleReference)this.tuple);
        }
        this.isFoundNull = false;
        i = 0;
        while (i < 100) {
            TupleUtils.createIntegerTuple((ArrayTupleBuilder)this.builder, (ArrayTupleReference)this.tuple, (int[])new int[]{i++});
            accessor.delete((ITupleReference)this.tuple);
        }
    }

    private class VeriyfingModificationCallback
    implements IModificationOperationCallback {
        private VeriyfingModificationCallback() {
        }

        public void before(ITupleReference tuple) throws HyracksDataException {
            Assert.assertEquals((long)0L, (long)AbstractModificationOperationCallbackTest.this.cmp.compare((ITupleReference)AbstractModificationOperationCallbackTest.this.tuple, tuple));
        }

        public void found(ITupleReference before, ITupleReference after) throws HyracksDataException {
            if (AbstractModificationOperationCallbackTest.this.isFoundNull) {
                Assert.assertEquals(null, (Object)before);
            } else {
                Assert.assertEquals((long)0L, (long)AbstractModificationOperationCallbackTest.this.cmp.compare((ITupleReference)AbstractModificationOperationCallbackTest.this.tuple, before));
            }
            Assert.assertEquals((long)0L, (long)AbstractModificationOperationCallbackTest.this.cmp.compare((ITupleReference)AbstractModificationOperationCallbackTest.this.tuple, after));
        }
    }
}

