/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.impls;

import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class DiskBTreeRangeSearchCursor
extends BTreeRangeSearchCursor {
    protected final List<Integer> searchPages = new ArrayList<Integer>(5);

    public DiskBTreeRangeSearchCursor(IBTreeLeafFrame frame, boolean exclusiveLatchNodes) {
        super(frame, exclusiveLatchNodes);
    }

    @Override
    public boolean doHasNext() throws HyracksDataException {
        if (this.tupleIndex >= this.frame.getTupleCount()) {
            int nextLeafPage = this.frame.getNextLeaf();
            if (nextLeafPage >= 0) {
                this.fetchNextLeafPage(nextLeafPage);
                this.tupleIndex = 0;
                this.searchPages.set(this.searchPages.size() - 1, nextLeafPage);
                this.stopTupleIndex = this.getHighKeyIndex();
                if (this.stopTupleIndex < 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.tupleIndex > this.stopTupleIndex) {
            return false;
        }
        this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this.frame, this.tupleIndex);
        return true;
    }

    @Override
    protected void resetBeforeOpen() throws HyracksDataException {
    }

    public int numSearchPages() {
        return this.searchPages.size();
    }

    public void addSearchPage(int page) {
        this.searchPages.add(page);
    }

    public int getLastSearchPage() {
        return this.searchPages.get(this.searchPages.size() - 1);
    }

    public int removeLastSearchPage() {
        return this.searchPages.remove(this.searchPages.size() - 1);
    }

    public ICachedPage getPage() {
        return this.page;
    }

    @Override
    protected void releasePage() throws HyracksDataException {
        this.bufferCache.unpin(this.page);
    }

    @Override
    protected ICachedPage acquirePage(int pageId) throws HyracksDataException {
        return this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
    }

    @Override
    public void doClose() throws HyracksDataException {
        super.doClose();
        this.searchPages.clear();
    }
}

