/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.examples.btree.helper;

import java.util.concurrent.ThreadFactory;
import org.apache.hyracks.api.application.INCApplicationContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.api.IIndexLifecycleManager;
import org.apache.hyracks.storage.am.common.dataflow.IndexLifecycleManager;
import org.apache.hyracks.storage.common.buffercache.BufferCache;
import org.apache.hyracks.storage.common.buffercache.ClockPageReplacementStrategy;
import org.apache.hyracks.storage.common.buffercache.DelayPageCleanerPolicy;
import org.apache.hyracks.storage.common.buffercache.HeapBufferAllocator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICacheMemoryAllocator;
import org.apache.hyracks.storage.common.buffercache.IPageCleanerPolicy;
import org.apache.hyracks.storage.common.buffercache.IPageReplacementStrategy;
import org.apache.hyracks.storage.common.file.IFileMapManager;
import org.apache.hyracks.storage.common.file.IFileMapProvider;
import org.apache.hyracks.storage.common.file.ILocalResourceRepository;
import org.apache.hyracks.storage.common.file.ResourceIdFactory;
import org.apache.hyracks.storage.common.file.ResourceIdFactoryProvider;
import org.apache.hyracks.storage.common.file.TransientFileMapManager;
import org.apache.hyracks.storage.common.file.TransientLocalResourceRepositoryFactory;

public class RuntimeContext {
    private IBufferCache bufferCache;
    private IFileMapManager fileMapManager;
    private ILocalResourceRepository localResourceRepository;
    private IIndexLifecycleManager lcManager;
    private ResourceIdFactory resourceIdFactory;
    private ThreadFactory threadFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r);
        }
    };

    public RuntimeContext(INCApplicationContext appCtx) throws HyracksDataException {
        this.fileMapManager = new TransientFileMapManager();
        HeapBufferAllocator allocator = new HeapBufferAllocator();
        ClockPageReplacementStrategy prs = new ClockPageReplacementStrategy((ICacheMemoryAllocator)allocator, 32768, 50);
        this.bufferCache = new BufferCache(appCtx.getRootContext().getIOManager(), (IPageReplacementStrategy)prs, (IPageCleanerPolicy)new DelayPageCleanerPolicy(1000L), this.fileMapManager, 100, this.threadFactory);
        this.lcManager = new IndexLifecycleManager();
        TransientLocalResourceRepositoryFactory localResourceRepositoryFactory = new TransientLocalResourceRepositoryFactory();
        this.localResourceRepository = localResourceRepositoryFactory.createRepository();
        this.resourceIdFactory = new ResourceIdFactoryProvider(this.localResourceRepository).createResourceIdFactory();
    }

    public void close() throws HyracksDataException {
        this.bufferCache.close();
    }

    public IBufferCache getBufferCache() {
        return this.bufferCache;
    }

    public IFileMapProvider getFileMapManager() {
        return this.fileMapManager;
    }

    public static RuntimeContext get(IHyracksTaskContext ctx) {
        return (RuntimeContext)ctx.getJobletContext().getApplicationContext().getApplicationObject();
    }

    public ILocalResourceRepository getLocalResourceRepository() {
        return this.localResourceRepository;
    }

    public ResourceIdFactory getResourceIdFactory() {
        return this.resourceIdFactory;
    }

    public IIndexLifecycleManager getIndexLifecycleManager() {
        return this.lcManager;
    }
}

