/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.examples.btree.helper;

import java.io.DataOutput;
import java.util.HashSet;
import java.util.Random;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.UTF8StringSerializerDeserializer;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;

public class DataGenOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final int numRecords;
    private final int intMinVal;
    private final int intMaxVal;
    private final int maxStrLen;
    private final int uniqueField;
    private final long randomSeed;

    public DataGenOperatorDescriptor(IOperatorDescriptorRegistry spec, RecordDescriptor outputRecord, int numRecords, int uniqueField, int intMinVal, int intMaxVal, int maxStrLen, long randomSeed) {
        super(spec, 0, 1);
        this.numRecords = numRecords;
        this.uniqueField = uniqueField;
        this.intMinVal = intMinVal;
        this.intMaxVal = intMaxVal;
        this.maxStrLen = maxStrLen;
        this.randomSeed = randomSeed;
        this.recordDescriptors[0] = outputRecord;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        final FrameTupleAppender appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)ctx));
        final RecordDescriptor recDesc = this.recordDescriptors[0];
        final ArrayTupleBuilder tb = new ArrayTupleBuilder(recDesc.getFields().length);
        final Random rnd = new Random(this.randomSeed);
        int maxUniqueAttempts = 20;
        return new AbstractUnaryOutputSourceOperatorNodePushable(){
            HashSet<String> stringHs = new HashSet();
            HashSet<Integer> intHs = new HashSet();

            public void initialize() throws HyracksDataException {
                this.writer.open();
                try {
                    for (int i = 0; i < DataGenOperatorDescriptor.this.numRecords; ++i) {
                        tb.reset();
                        for (int j = 0; j < recDesc.getFieldCount(); ++j) {
                            this.genField(tb, j);
                        }
                        if (appender.append(tb.getFieldEndOffsets(), tb.getByteArray(), 0, tb.getSize())) continue;
                        appender.flush(this.writer, true);
                        if (appender.append(tb.getFieldEndOffsets(), tb.getByteArray(), 0, tb.getSize())) continue;
                        throw new HyracksDataException("Record size (" + tb.getSize() + ") larger than frame size (" + appender.getBuffer().capacity() + ")");
                    }
                    appender.flush(this.writer, true);
                }
                catch (Exception e) {
                    this.writer.fail();
                    throw new HyracksDataException((Throwable)e);
                }
                finally {
                    this.writer.close();
                }
            }

            private void genField(ArrayTupleBuilder tb2, int fieldIndex) throws HyracksDataException {
                DataOutput dos = tb2.getDataOutput();
                if (recDesc.getFields()[fieldIndex] instanceof IntegerSerializerDeserializer) {
                    int val = -1;
                    if (fieldIndex == DataGenOperatorDescriptor.this.uniqueField) {
                        int attempt;
                        for (attempt = 0; attempt < 20; ++attempt) {
                            int tmp = Math.abs(rnd.nextInt()) % (DataGenOperatorDescriptor.this.intMaxVal - DataGenOperatorDescriptor.this.intMinVal) + DataGenOperatorDescriptor.this.intMinVal;
                            if (this.intHs.contains(tmp)) {
                                continue;
                            }
                            val = tmp;
                            this.intHs.add(val);
                            break;
                        }
                        if (attempt == 20) {
                            throw new HyracksDataException("MaxUnique attempts reached in datagen");
                        }
                    } else {
                        val = Math.abs(rnd.nextInt()) % (DataGenOperatorDescriptor.this.intMaxVal - DataGenOperatorDescriptor.this.intMinVal) + DataGenOperatorDescriptor.this.intMinVal;
                    }
                    recDesc.getFields()[fieldIndex].serialize((Object)val, dos);
                    tb2.addFieldEndOffset();
                } else if (recDesc.getFields()[fieldIndex] instanceof UTF8StringSerializerDeserializer) {
                    String val = null;
                    if (fieldIndex == DataGenOperatorDescriptor.this.uniqueField) {
                        int attempt;
                        for (attempt = 0; attempt < 20; ++attempt) {
                            String tmp = this.randomString(DataGenOperatorDescriptor.this.maxStrLen, rnd);
                            if (this.stringHs.contains(tmp)) {
                                continue;
                            }
                            val = tmp;
                            this.stringHs.add(val);
                            break;
                        }
                        if (attempt == 20) {
                            throw new HyracksDataException("MaxUnique attempts reached in datagen");
                        }
                    } else {
                        val = this.randomString(DataGenOperatorDescriptor.this.maxStrLen, rnd);
                    }
                    recDesc.getFields()[fieldIndex].serialize((Object)val, dos);
                    tb2.addFieldEndOffset();
                } else {
                    throw new HyracksDataException("Type unsupported in data generator. Only integers and strings allowed");
                }
            }

            private String randomString(int length, Random random) {
                String s = Long.toHexString(Double.doubleToLongBits(random.nextDouble()));
                StringBuilder strBuilder = new StringBuilder();
                for (int i = 0; i < s.length() && i < length; ++i) {
                    strBuilder.append(s.charAt(Math.abs(random.nextInt()) % s.length()));
                }
                return strBuilder.toString();
            }
        };
    }
}

