/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service.handlers;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.timeline.service.TimelineService;
import org.apache.hudi.timeline.service.handlers.Handler;

public class RemotePartitionerHandler
extends Handler {
    private final ConcurrentHashMap<String, Integer> cache;
    private final AtomicInteger nextIndex = new AtomicInteger(0);

    public RemotePartitionerHandler(StorageConfiguration<?> conf, TimelineService.Config timelineServiceConfig, FileSystemViewManager viewManager) {
        super(conf, timelineServiceConfig, viewManager);
        this.cache = new ConcurrentHashMap();
    }

    public int gePartitionIndex(String numBuckets, String partitionPath, String partitionNum) {
        int num = Integer.parseInt(numBuckets);
        int partNum = Integer.parseInt(partitionNum);
        return this.cache.computeIfAbsent(partitionPath, key -> {
            int res;
            int newNext;
            int current;
            do {
                res = current = this.nextIndex.get();
                newNext = current + num;
                if (newNext < partNum) continue;
                newNext %= partNum;
            } while (!this.nextIndex.compareAndSet(current, newNext));
            return res;
        });
    }
}

