/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.apache.hudi.testutils.SparkDatasetTestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public class HoodieBulkInsertInternalWriterTestBase
extends HoodieSparkClientTestHarness {
    protected static final Random RANDOM = new Random();

    @BeforeEach
    public void setUp() throws Exception {
        this.initSparkContexts();
        this.initPath();
        this.initHoodieStorage();
        this.initTestDataGenerator();
        this.initMetaClient();
        this.initTimelineService();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanupResources();
    }

    protected HoodieWriteConfig getWriteConfig(boolean populateMetaFields) {
        return this.getWriteConfig(populateMetaFields, (String)DataSourceWriteOptions.HIVE_STYLE_PARTITIONING().defaultValue());
    }

    protected HoodieWriteConfig getWriteConfig(boolean populateMetaFields, String hiveStylePartitioningValue) {
        Properties properties = new Properties();
        if (!populateMetaFields) {
            properties.setProperty(DataSourceWriteOptions.RECORDKEY_FIELD().key(), "record_key");
            properties.setProperty(DataSourceWriteOptions.PARTITIONPATH_FIELD().key(), "partition_path");
            properties.setProperty(HoodieTableConfig.POPULATE_META_FIELDS.key(), "false");
        }
        properties.setProperty(DataSourceWriteOptions.HIVE_STYLE_PARTITIONING().key(), hiveStylePartitioningValue);
        return SparkDatasetTestUtils.getConfigBuilder((String)this.basePath, (int)timelineServicePort).withProperties(properties).build();
    }

    protected void assertWriteStatuses(List<WriteStatus> writeStatuses, int batches, int size, Option<List<String>> fileAbsPaths, Option<List<String>> fileNames) {
        this.assertWriteStatuses(writeStatuses, batches, size, false, fileAbsPaths, fileNames, false);
    }

    protected void assertWriteStatuses(List<WriteStatus> writeStatuses, int batches, int size, boolean areRecordsSorted, Option<List<String>> fileAbsPaths, Option<List<String>> fileNames, boolean isHiveStylePartitioning) {
        if (areRecordsSorted) {
            Assertions.assertEquals((int)batches, (int)writeStatuses.size());
        } else {
            Assertions.assertEquals((int)Math.min(HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS.length, batches), (int)writeStatuses.size());
        }
        HashMap<String, Long> sizeMap = new HashMap<String, Long>();
        if (!areRecordsSorted) {
            for (int i = 0; i < batches; ++i) {
                String partitionPath = HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS[i % 3];
                if (!sizeMap.containsKey(partitionPath)) {
                    sizeMap.put(partitionPath, 0L);
                }
                sizeMap.put(partitionPath, (Long)sizeMap.get(partitionPath) + (long)size);
            }
        }
        int counter = 0;
        for (WriteStatus writeStatus : writeStatuses) {
            String actualPartitionPathFormat = isHiveStylePartitioning ? "partition_path=%s" : "%s";
            Assertions.assertEquals((Object)String.format(actualPartitionPathFormat, HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS[counter % 3]), (Object)writeStatus.getPartitionPath());
            if (areRecordsSorted) {
                Assertions.assertEquals((long)writeStatus.getTotalRecords(), (long)size);
            } else {
                Assertions.assertEquals((long)writeStatus.getTotalRecords(), (Long)((Long)sizeMap.get(HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS[counter % 3])));
            }
            Assertions.assertNull((Object)writeStatus.getGlobalError());
            Assertions.assertEquals((long)writeStatus.getTotalErrorRecords(), (long)0L);
            Assertions.assertEquals((long)writeStatus.getTotalErrorRecords(), (long)0L);
            Assertions.assertFalse((boolean)writeStatus.hasErrors());
            Assertions.assertNotNull((Object)writeStatus.getFileId());
            String fileId = writeStatus.getFileId();
            if (fileAbsPaths.isPresent()) {
                ((List)fileAbsPaths.get()).add(this.basePath + "/" + writeStatus.getStat().getPath());
            }
            if (fileNames.isPresent()) {
                ((List)fileNames.get()).add(writeStatus.getStat().getPath().substring(writeStatus.getStat().getPath().lastIndexOf(47) + 1));
            }
            HoodieWriteStat writeStat = writeStatus.getStat();
            if (areRecordsSorted) {
                Assertions.assertEquals((long)size, (long)writeStat.getNumInserts());
                Assertions.assertEquals((long)size, (long)writeStat.getNumWrites());
            } else {
                Assertions.assertEquals((Long)((Long)sizeMap.get(HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS[counter % 3])), (long)writeStat.getNumInserts());
                Assertions.assertEquals((Long)((Long)sizeMap.get(HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS[counter % 3])), (long)writeStat.getNumWrites());
            }
            Assertions.assertEquals((Object)fileId, (Object)writeStat.getFileId());
            Assertions.assertEquals((Object)String.format(actualPartitionPathFormat, HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS[counter++ % 3]), (Object)writeStat.getPartitionPath());
            Assertions.assertEquals((long)0L, (long)writeStat.getNumDeletes());
            Assertions.assertEquals((long)0L, (long)writeStat.getNumUpdateWrites());
            Assertions.assertEquals((long)0L, (long)writeStat.getTotalWriteErrors());
        }
    }

    protected void assertOutput(Dataset<Row> expectedRows, Dataset<Row> actualRows, String instantTime, Option<List<String>> fileNames, boolean populateMetaColumns) {
        if (populateMetaColumns) {
            actualRows.collectAsList().forEach(entry -> {
                Assertions.assertEquals((Object)entry.get(HoodieRecord.HoodieMetadataField.COMMIT_TIME_METADATA_FIELD.ordinal()).toString(), (Object)instantTime);
                Assertions.assertFalse((boolean)entry.isNullAt(HoodieRecord.HoodieMetadataField.FILENAME_METADATA_FIELD.ordinal()));
                if (fileNames.isPresent()) {
                    Assertions.assertTrue((boolean)((List)fileNames.get()).contains(entry.get(HoodieRecord.HoodieMetadataField.FILENAME_METADATA_FIELD.ordinal())));
                }
                Assertions.assertFalse((boolean)entry.isNullAt(HoodieRecord.HoodieMetadataField.COMMIT_SEQNO_METADATA_FIELD.ordinal()));
            });
            Dataset trimmedExpected = expectedRows.drop(new String[]{HoodieRecord.COMMIT_SEQNO_METADATA_FIELD, HoodieRecord.COMMIT_TIME_METADATA_FIELD, HoodieRecord.FILENAME_METADATA_FIELD});
            Dataset trimmedActual = actualRows.drop(new String[]{HoodieRecord.COMMIT_SEQNO_METADATA_FIELD, HoodieRecord.COMMIT_TIME_METADATA_FIELD, HoodieRecord.FILENAME_METADATA_FIELD});
            Assertions.assertEquals((long)0L, (long)trimmedActual.except(trimmedExpected).count());
        } else {
            Assertions.assertEquals((long)0L, (long)expectedRows.except(actualRows).count());
        }
    }
}

