/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import java.util.Collections;
import java.util.List;
import org.apache.hudi.hive.PartitionValueExtractor;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SlashEncodedDayPartitionValueExtractor
implements PartitionValueExtractor {
    private transient DateTimeFormatter dtfOut = DateTimeFormat.forPattern((String)"yyyy-MM-dd");

    private DateTimeFormatter getDtfOut() {
        if (this.dtfOut == null) {
            this.dtfOut = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        }
        return this.dtfOut;
    }

    @Override
    public List<String> extractPartitionValuesInPath(String partitionPath) {
        String[] splits = partitionPath.split("/");
        if (splits.length != 3) {
            throw new IllegalArgumentException("Partition path " + partitionPath + " is not in the form yyyy/mm/dd ");
        }
        int year = Integer.parseInt(splits[0].contains("=") ? splits[0].split("=")[1] : splits[0]);
        int mm = Integer.parseInt(splits[1].contains("=") ? splits[1].split("=")[1] : splits[1]);
        int dd = Integer.parseInt(splits[2].contains("=") ? splits[2].split("=")[1] : splits[2]);
        DateTime dateTime = new DateTime(year, mm, dd, 0, 0);
        return Collections.singletonList(this.getDtfOut().print((ReadableInstant)dateTime));
    }
}

