/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import com.beust.jcommander.JCommander;
import com.uber.hoodie.hadoop.HoodieInputFormat;
import com.uber.hoodie.hadoop.realtime.HoodieRealtimeInputFormat;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.InvalidTableException;
import org.apache.hudi.hadoop.HoodieParquetInputFormat;
import org.apache.hudi.hadoop.realtime.HoodieParquetRealtimeInputFormat;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HoodieHiveClient;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.hive.SchemaDifference;
import org.apache.hudi.hive.util.SchemaUtil;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.parquet.schema.MessageType;

public class HiveSyncTool {
    private static final Logger LOG = LogManager.getLogger(HiveSyncTool.class);
    public static final String SUFFIX_SNAPSHOT_TABLE = "_rt";
    public static final String SUFFIX_READ_OPTIMIZED_TABLE = "_ro";
    private final HiveSyncConfig cfg;
    private final HoodieHiveClient hoodieHiveClient;
    private final String snapshotTableName;
    private final Option<String> roTableTableName;

    public HiveSyncTool(HiveSyncConfig cfg, HiveConf configuration, FileSystem fs) {
        this.hoodieHiveClient = new HoodieHiveClient(cfg, configuration, fs);
        this.cfg = cfg;
        switch (this.hoodieHiveClient.getTableType()) {
            case COPY_ON_WRITE: {
                this.snapshotTableName = cfg.tableName;
                this.roTableTableName = Option.empty();
                break;
            }
            case MERGE_ON_READ: {
                this.snapshotTableName = cfg.tableName + SUFFIX_SNAPSHOT_TABLE;
                this.roTableTableName = cfg.skipROSuffix != false ? Option.of((Object)cfg.tableName) : Option.of((Object)(cfg.tableName + SUFFIX_READ_OPTIMIZED_TABLE));
                break;
            }
            default: {
                LOG.error((Object)("Unknown table type " + this.hoodieHiveClient.getTableType()));
                throw new InvalidTableException(this.hoodieHiveClient.getBasePath());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void syncHoodieTable() {
        try {
            switch (this.hoodieHiveClient.getTableType()) {
                case COPY_ON_WRITE: {
                    this.syncHoodieTable(this.snapshotTableName, false);
                    return;
                }
                case MERGE_ON_READ: {
                    this.syncHoodieTable((String)this.roTableTableName.get(), false);
                    this.syncHoodieTable(this.snapshotTableName, true);
                    return;
                }
                default: {
                    LOG.error((Object)("Unknown table type " + this.hoodieHiveClient.getTableType()));
                    throw new InvalidTableException(this.hoodieHiveClient.getBasePath());
                }
            }
        }
        catch (RuntimeException re) {
            LOG.error((Object)"Got runtime exception when hive syncing", (Throwable)re);
            return;
        }
        finally {
            this.hoodieHiveClient.close();
        }
    }

    private void syncHoodieTable(String tableName, boolean useRealtimeInputFormat) {
        LOG.info((Object)("Trying to sync hoodie table " + tableName + " with base path " + this.hoodieHiveClient.getBasePath() + " of type " + this.hoodieHiveClient.getTableType()));
        boolean tableExists = this.hoodieHiveClient.doesTableExist(tableName);
        MessageType schema = this.hoodieHiveClient.getDataSchema();
        this.syncSchema(tableName, tableExists, useRealtimeInputFormat, schema);
        LOG.info((Object)("Schema sync complete. Syncing partitions for " + tableName));
        Option<String> lastCommitTimeSynced = Option.empty();
        if (tableExists) {
            lastCommitTimeSynced = this.hoodieHiveClient.getLastCommitTimeSynced(tableName);
        }
        LOG.info((Object)("Last commit time synced was found to be " + (String)lastCommitTimeSynced.orElse((Object)"null")));
        List<String> writtenPartitionsSince = this.hoodieHiveClient.getPartitionsWrittenToSince(lastCommitTimeSynced);
        LOG.info((Object)("Storage partitions scan complete. Found " + writtenPartitionsSince.size()));
        this.syncPartitions(tableName, writtenPartitionsSince);
        this.hoodieHiveClient.updateLastCommitTimeSynced(tableName);
        LOG.info((Object)("Sync complete for " + tableName));
    }

    private void syncSchema(String tableName, boolean tableExists, boolean useRealTimeInputFormat, MessageType schema) {
        if (!tableExists) {
            LOG.info((Object)("Hive table " + tableName + " is not found. Creating it"));
            if (!useRealTimeInputFormat) {
                String inputFormatClassName = this.cfg.usePreApacheInputFormat != false ? HoodieInputFormat.class.getName() : HoodieParquetInputFormat.class.getName();
                this.hoodieHiveClient.createTable(tableName, schema, inputFormatClassName, MapredParquetOutputFormat.class.getName(), ParquetHiveSerDe.class.getName());
            } else {
                String inputFormatClassName = this.cfg.usePreApacheInputFormat != false ? HoodieRealtimeInputFormat.class.getName() : HoodieParquetRealtimeInputFormat.class.getName();
                this.hoodieHiveClient.createTable(tableName, schema, inputFormatClassName, MapredParquetOutputFormat.class.getName(), ParquetHiveSerDe.class.getName());
            }
        } else {
            Map<String, String> tableSchema = this.hoodieHiveClient.getTableSchema(tableName);
            SchemaDifference schemaDiff = SchemaUtil.getSchemaDifference(schema, tableSchema, this.cfg.partitionFields);
            if (!schemaDiff.isEmpty()) {
                LOG.info((Object)("Schema difference found for " + tableName));
                this.hoodieHiveClient.updateTableDefinition(tableName, schema);
            } else {
                LOG.info((Object)("No Schema difference for " + tableName));
            }
        }
    }

    private void syncPartitions(String tableName, List<String> writtenPartitionsSince) {
        try {
            List<Partition> hivePartitions = this.hoodieHiveClient.scanTablePartitions(tableName);
            List<HoodieHiveClient.PartitionEvent> partitionEvents = this.hoodieHiveClient.getPartitionEvents(hivePartitions, writtenPartitionsSince);
            List<String> newPartitions = this.filterPartitions(partitionEvents, HoodieHiveClient.PartitionEvent.PartitionEventType.ADD);
            LOG.info((Object)("New Partitions " + newPartitions));
            this.hoodieHiveClient.addPartitionsToTable(tableName, newPartitions);
            List<String> updatePartitions = this.filterPartitions(partitionEvents, HoodieHiveClient.PartitionEvent.PartitionEventType.UPDATE);
            LOG.info((Object)("Changed Partitions " + updatePartitions));
            this.hoodieHiveClient.updatePartitionsToTable(tableName, updatePartitions);
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to sync partitions for table " + tableName, e);
        }
    }

    private List<String> filterPartitions(List<HoodieHiveClient.PartitionEvent> events, HoodieHiveClient.PartitionEvent.PartitionEventType eventType) {
        return events.stream().filter(s -> s.eventType == eventType).map(s -> s.storagePartition).collect(Collectors.toList());
    }

    public static void main(String[] args) {
        HiveSyncConfig cfg = new HiveSyncConfig();
        JCommander cmd = new JCommander((Object)cfg, null, args);
        if (cfg.help.booleanValue() || args.length == 0) {
            cmd.usage();
            System.exit(1);
        }
        FileSystem fs = FSUtils.getFs((String)cfg.basePath, (Configuration)new Configuration());
        HiveConf hiveConf = new HiveConf();
        hiveConf.addResource(fs.getConf());
        new HiveSyncTool(cfg, hiveConf, fs).syncHoodieTable();
    }
}

