/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SchemaTestUtil;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.hive.HoodieHiveClient;
import org.apache.hudi.hive.MultiPartKeysValueExtractor;
import org.apache.hudi.hive.TestUtil;
import org.apache.hudi.hive.util.SchemaUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestHiveSyncTool {
    private boolean useJdbc;

    public TestHiveSyncTool(Boolean useJdbc) {
        this.useJdbc = useJdbc;
    }

    @Parameterized.Parameters(name="UseJdbc")
    public static Collection<Boolean[]> data() {
        return Arrays.asList({false}, {true});
    }

    @Before
    public void setUp() throws IOException, InterruptedException {
        TestUtil.setUp();
    }

    @After
    public void teardown() throws IOException {
        TestUtil.clear();
    }

    @Test
    public void testSchemaConvertArray() throws IOException {
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().optional(PrimitiveType.PrimitiveTypeName.INT32).named("element")).named("list")).named("int_list")).named("ArrayOfInts");
        String schemaString = SchemaUtil.generateSchemaString((MessageType)schema);
        Assert.assertEquals((Object)"`int_list` ARRAY< int>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().requiredGroup().as(OriginalType.LIST)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.INT32).named("element")).named("list")).named("element")).named("list")).named("int_list_list")).named("ArrayOfArrayOfInts");
        schemaString = SchemaUtil.generateSchemaString((MessageType)schema);
        Assert.assertEquals((Object)"`int_list_list` ARRAY< ARRAY< int>>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeated(PrimitiveType.PrimitiveTypeName.INT32).named("element")).named("int_list")).named("ArrayOfInts");
        schemaString = SchemaUtil.generateSchemaString((MessageType)schema);
        Assert.assertEquals((Object)"`int_list` ARRAY< int>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.BINARY).named("str")).required(PrimitiveType.PrimitiveTypeName.INT32).named("num")).named("element")).named("tuple_list")).named("ArrayOfTuples");
        schemaString = SchemaUtil.generateSchemaString((MessageType)schema);
        Assert.assertEquals((Object)"`tuple_list` ARRAY< STRUCT< `str` : binary, `num` : int>>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.BINARY).named("str")).named("array")).named("one_tuple_list")).named("ArrayOfOneTuples");
        schemaString = SchemaUtil.generateSchemaString((MessageType)schema);
        Assert.assertEquals((Object)"`one_tuple_list` ARRAY< STRUCT< `str` : binary>>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.BINARY).named("str")).named("one_tuple_list_tuple")).named("one_tuple_list")).named("ArrayOfOneTuples2");
        schemaString = SchemaUtil.generateSchemaString((MessageType)schema);
        Assert.assertEquals((Object)"`one_tuple_list` ARRAY< STRUCT< `str` : binary>>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.BINARY).named("str")).named("one_tuple_list")).named("one_tuple_list")).named("ArrayOfOneTuples3");
        schemaString = SchemaUtil.generateSchemaString((MessageType)schema);
        Assert.assertEquals((Object)"`one_tuple_list` ARRAY< binary>", (Object)schemaString);
        schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as(OriginalType.LIST)).repeatedGroup().as(OriginalType.MAP)).repeatedGroup().as(OriginalType.MAP_KEY_VALUE)).required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("string_key")).required(PrimitiveType.PrimitiveTypeName.INT32).named("int_value")).named("key_value")).named("array")).named("map_list")).named("ArrayOfMaps");
        schemaString = SchemaUtil.generateSchemaString((MessageType)schema);
        Assert.assertEquals((Object)"`map_list` ARRAY< MAP< string, int>>", (Object)schemaString);
    }

    @Test
    public void testBasicSync() throws Exception {
        TestUtil.hiveSyncConfig.useJdbc = this.useJdbc;
        String commitTime = "100";
        TestUtil.createCOWTable(commitTime, 5);
        HoodieHiveClient hiveClient = new HoodieHiveClient(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        Assert.assertFalse((String)("Table " + TestUtil.hiveSyncConfig.tableName + " should not exist initially"), (boolean)hiveClient.doesTableExist(TestUtil.hiveSyncConfig.tableName));
        HiveSyncTool tool = new HiveSyncTool(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        tool.syncHoodieTable();
        Assert.assertTrue((String)("Table " + TestUtil.hiveSyncConfig.tableName + " should exist after sync completes"), (boolean)hiveClient.doesTableExist(TestUtil.hiveSyncConfig.tableName));
        Assert.assertEquals((String)"Hive Schema should match the table schema + partition field", (long)hiveClient.getTableSchema(TestUtil.hiveSyncConfig.tableName).size(), (long)(hiveClient.getDataSchema().getColumns().size() + 1));
        Assert.assertEquals((String)"Table partitions should match the number of partitions we wrote", (long)5L, (long)hiveClient.scanTablePartitions(TestUtil.hiveSyncConfig.tableName).size());
        Assert.assertEquals((String)"The last commit that was sycned should be updated in the TBLPROPERTIES", (Object)commitTime, (Object)hiveClient.getLastCommitTimeSynced(TestUtil.hiveSyncConfig.tableName).get());
        List<String> newPartition = Arrays.asList("2050/01/01");
        hiveClient.addPartitionsToTable(TestUtil.hiveSyncConfig.tableName, Arrays.asList(new String[0]));
        Assert.assertEquals((String)"No new partition should be added", (long)5L, (long)hiveClient.scanTablePartitions(TestUtil.hiveSyncConfig.tableName).size());
        hiveClient.addPartitionsToTable(TestUtil.hiveSyncConfig.tableName, newPartition);
        Assert.assertEquals((String)"New partition should be added", (long)6L, (long)hiveClient.scanTablePartitions(TestUtil.hiveSyncConfig.tableName).size());
        hiveClient.updatePartitionsToTable(TestUtil.hiveSyncConfig.tableName, Arrays.asList(new String[0]));
        Assert.assertEquals((String)"Partition count should remain the same", (long)6L, (long)hiveClient.scanTablePartitions(TestUtil.hiveSyncConfig.tableName).size());
        hiveClient.updatePartitionsToTable(TestUtil.hiveSyncConfig.tableName, newPartition);
        Assert.assertEquals((String)"Partition count should remain the same", (long)6L, (long)hiveClient.scanTablePartitions(TestUtil.hiveSyncConfig.tableName).size());
        hiveClient.updateHiveSQL("ALTER TABLE `" + TestUtil.hiveSyncConfig.tableName + "` PARTITION (`datestr`='2050-01-01') SET LOCATION '/some/new/location'");
        hiveClient = new HoodieHiveClient(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        List hivePartitions = hiveClient.scanTablePartitions(TestUtil.hiveSyncConfig.tableName);
        List writtenPartitionsSince = hiveClient.getPartitionsWrittenToSince(Option.empty());
        writtenPartitionsSince.add(newPartition.get(0));
        List partitionEvents = hiveClient.getPartitionEvents(hivePartitions, writtenPartitionsSince);
        Assert.assertEquals((String)"There should be only one paritition event", (long)1L, (long)partitionEvents.size());
        Assert.assertEquals((String)"The one partition event must of type UPDATE", (Object)HoodieHiveClient.PartitionEvent.PartitionEventType.UPDATE, (Object)((HoodieHiveClient.PartitionEvent)partitionEvents.iterator().next()).eventType);
        tool = new HiveSyncTool(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        tool.syncHoodieTable();
        List tablePartitions = hiveClient.scanTablePartitions(TestUtil.hiveSyncConfig.tableName);
        Assert.assertEquals((String)"The one partition we wrote should be added to hive", (long)6L, (long)tablePartitions.size());
        Assert.assertEquals((String)"The last commit that was sycned should be 100", (Object)commitTime, (Object)hiveClient.getLastCommitTimeSynced(TestUtil.hiveSyncConfig.tableName).get());
    }

    @Test
    public void testSyncIncremental() throws Exception {
        TestUtil.hiveSyncConfig.useJdbc = this.useJdbc;
        String commitTime1 = "100";
        TestUtil.createCOWTable(commitTime1, 5);
        HoodieHiveClient hiveClient = new HoodieHiveClient(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        HiveSyncTool tool = new HiveSyncTool(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        tool.syncHoodieTable();
        Assert.assertEquals((String)"Table partitions should match the number of partitions we wrote", (long)5L, (long)hiveClient.scanTablePartitions(TestUtil.hiveSyncConfig.tableName).size());
        Assert.assertEquals((String)"The last commit that was sycned should be updated in the TBLPROPERTIES", (Object)commitTime1, (Object)hiveClient.getLastCommitTimeSynced(TestUtil.hiveSyncConfig.tableName).get());
        DateTime dateTime = DateTime.now().plusDays(6);
        String commitTime2 = "101";
        TestUtil.addCOWPartitions(1, true, dateTime, commitTime2);
        hiveClient = new HoodieHiveClient(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        List writtenPartitionsSince = hiveClient.getPartitionsWrittenToSince(Option.of((Object)commitTime1));
        Assert.assertEquals((String)"We should have one partition written after 100 commit", (long)1L, (long)writtenPartitionsSince.size());
        List hivePartitions = hiveClient.scanTablePartitions(TestUtil.hiveSyncConfig.tableName);
        List partitionEvents = hiveClient.getPartitionEvents(hivePartitions, writtenPartitionsSince);
        Assert.assertEquals((String)"There should be only one paritition event", (long)1L, (long)partitionEvents.size());
        Assert.assertEquals((String)"The one partition event must of type ADD", (Object)HoodieHiveClient.PartitionEvent.PartitionEventType.ADD, (Object)((HoodieHiveClient.PartitionEvent)partitionEvents.iterator().next()).eventType);
        tool = new HiveSyncTool(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        tool.syncHoodieTable();
        Assert.assertEquals((String)"The one partition we wrote should be added to hive", (long)6L, (long)hiveClient.scanTablePartitions(TestUtil.hiveSyncConfig.tableName).size());
        Assert.assertEquals((String)"The last commit that was sycned should be 101", (Object)commitTime2, (Object)hiveClient.getLastCommitTimeSynced(TestUtil.hiveSyncConfig.tableName).get());
    }

    @Test
    public void testSyncIncrementalWithSchemaEvolution() throws Exception {
        TestUtil.hiveSyncConfig.useJdbc = this.useJdbc;
        String commitTime1 = "100";
        TestUtil.createCOWTable(commitTime1, 5);
        HoodieHiveClient hiveClient = new HoodieHiveClient(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        HiveSyncTool tool = new HiveSyncTool(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        tool.syncHoodieTable();
        int fields = hiveClient.getTableSchema(TestUtil.hiveSyncConfig.tableName).size();
        DateTime dateTime = DateTime.now().plusDays(6);
        String commitTime2 = "101";
        TestUtil.addCOWPartitions(1, false, dateTime, commitTime2);
        tool = new HiveSyncTool(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        tool.syncHoodieTable();
        Assert.assertEquals((String)"Hive Schema has evolved and should not be 3 more field", (long)(fields + 3), (long)hiveClient.getTableSchema(TestUtil.hiveSyncConfig.tableName).size());
        Assert.assertEquals((String)"Hive Schema has evolved - Field favorite_number has evolved from int to long", (Object)"BIGINT", hiveClient.getTableSchema(TestUtil.hiveSyncConfig.tableName).get("favorite_number"));
        Assert.assertTrue((String)"Hive Schema has evolved - Field favorite_movie was added", (boolean)hiveClient.getTableSchema(TestUtil.hiveSyncConfig.tableName).containsKey("favorite_movie"));
        Assert.assertEquals((String)"The one partition we wrote should be added to hive", (long)6L, (long)hiveClient.scanTablePartitions(TestUtil.hiveSyncConfig.tableName).size());
        Assert.assertEquals((String)"The last commit that was sycned should be 101", (Object)commitTime2, (Object)hiveClient.getLastCommitTimeSynced(TestUtil.hiveSyncConfig.tableName).get());
    }

    @Test
    public void testSyncMergeOnRead() throws Exception {
        TestUtil.hiveSyncConfig.useJdbc = this.useJdbc;
        String commitTime = "100";
        String deltaCommitTime = "101";
        TestUtil.createMORTable(commitTime, deltaCommitTime, 5, true);
        String roTableName = TestUtil.hiveSyncConfig.tableName + "_ro";
        HoodieHiveClient hiveClient = new HoodieHiveClient(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        Assert.assertFalse((String)("Table " + TestUtil.hiveSyncConfig.tableName + " should not exist initially"), (boolean)hiveClient.doesTableExist(roTableName));
        HiveSyncTool tool = new HiveSyncTool(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        tool.syncHoodieTable();
        Assert.assertTrue((String)("Table " + roTableName + " should exist after sync completes"), (boolean)hiveClient.doesTableExist(roTableName));
        Assert.assertEquals((String)"Hive Schema should match the table schema + partition field", (long)hiveClient.getTableSchema(roTableName).size(), (long)(SchemaTestUtil.getSimpleSchema().getFields().size() + 1));
        Assert.assertEquals((String)"Table partitions should match the number of partitions we wrote", (long)5L, (long)hiveClient.scanTablePartitions(roTableName).size());
        Assert.assertEquals((String)"The last commit that was sycned should be updated in the TBLPROPERTIES", (Object)deltaCommitTime, (Object)hiveClient.getLastCommitTimeSynced(roTableName).get());
        DateTime dateTime = DateTime.now().plusDays(6);
        String commitTime2 = "102";
        String deltaCommitTime2 = "103";
        TestUtil.addCOWPartitions(1, true, dateTime, commitTime2);
        TestUtil.addMORPartitions(1, true, false, dateTime, commitTime2, deltaCommitTime2);
        tool = new HiveSyncTool(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        tool.syncHoodieTable();
        hiveClient = new HoodieHiveClient(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        Assert.assertEquals((String)"Hive Schema should match the evolved table schema + partition field", (long)hiveClient.getTableSchema(roTableName).size(), (long)(SchemaTestUtil.getEvolvedSchema().getFields().size() + 1));
        Assert.assertEquals((String)"The 2 partitions we wrote should be added to hive", (long)6L, (long)hiveClient.scanTablePartitions(roTableName).size());
        Assert.assertEquals((String)"The last commit that was synced should be 103", (Object)deltaCommitTime2, (Object)hiveClient.getLastCommitTimeSynced(roTableName).get());
    }

    @Test
    public void testSyncMergeOnReadRT() throws Exception {
        TestUtil.hiveSyncConfig.useJdbc = this.useJdbc;
        String commitTime = "100";
        String deltaCommitTime = "101";
        String snapshotTableName = TestUtil.hiveSyncConfig.tableName + "_rt";
        TestUtil.createMORTable(commitTime, deltaCommitTime, 5, true);
        HoodieHiveClient hiveClientRT = new HoodieHiveClient(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        Assert.assertFalse((String)("Table " + TestUtil.hiveSyncConfig.tableName + "_rt" + " should not exist initially"), (boolean)hiveClientRT.doesTableExist(snapshotTableName));
        HiveSyncTool tool = new HiveSyncTool(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        tool.syncHoodieTable();
        Assert.assertTrue((String)("Table " + TestUtil.hiveSyncConfig.tableName + "_rt" + " should exist after sync completes"), (boolean)hiveClientRT.doesTableExist(snapshotTableName));
        Assert.assertEquals((String)"Hive Schema should match the table schema + partition field", (long)hiveClientRT.getTableSchema(snapshotTableName).size(), (long)(SchemaTestUtil.getSimpleSchema().getFields().size() + 1));
        Assert.assertEquals((String)"Table partitions should match the number of partitions we wrote", (long)5L, (long)hiveClientRT.scanTablePartitions(snapshotTableName).size());
        Assert.assertEquals((String)"The last commit that was synced should be updated in the TBLPROPERTIES", (Object)deltaCommitTime, (Object)hiveClientRT.getLastCommitTimeSynced(snapshotTableName).get());
        DateTime dateTime = DateTime.now().plusDays(6);
        String commitTime2 = "102";
        String deltaCommitTime2 = "103";
        TestUtil.addCOWPartitions(1, true, dateTime, commitTime2);
        TestUtil.addMORPartitions(1, true, false, dateTime, commitTime2, deltaCommitTime2);
        tool = new HiveSyncTool(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        tool.syncHoodieTable();
        hiveClientRT = new HoodieHiveClient(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        Assert.assertEquals((String)"Hive Schema should match the evolved table schema + partition field", (long)hiveClientRT.getTableSchema(snapshotTableName).size(), (long)(SchemaTestUtil.getEvolvedSchema().getFields().size() + 1));
        Assert.assertEquals((String)"The 2 partitions we wrote should be added to hive", (long)6L, (long)hiveClientRT.scanTablePartitions(snapshotTableName).size());
        Assert.assertEquals((String)"The last commit that was sycned should be 103", (Object)deltaCommitTime2, (Object)hiveClientRT.getLastCommitTimeSynced(snapshotTableName).get());
    }

    @Test
    public void testMultiPartitionKeySync() throws Exception {
        TestUtil.hiveSyncConfig.useJdbc = this.useJdbc;
        String commitTime = "100";
        TestUtil.createCOWTable(commitTime, 5);
        HiveSyncConfig hiveSyncConfig = HiveSyncConfig.copy((HiveSyncConfig)TestUtil.hiveSyncConfig);
        hiveSyncConfig.partitionValueExtractorClass = MultiPartKeysValueExtractor.class.getCanonicalName();
        hiveSyncConfig.tableName = "multi_part_key";
        hiveSyncConfig.partitionFields = Arrays.asList("year", "month", "day");
        TestUtil.getCreatedTablesSet().add(hiveSyncConfig.databaseName + "." + hiveSyncConfig.tableName);
        HoodieHiveClient hiveClient = new HoodieHiveClient(hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        Assert.assertFalse((String)("Table " + hiveSyncConfig.tableName + " should not exist initially"), (boolean)hiveClient.doesTableExist(hiveSyncConfig.tableName));
        HiveSyncTool tool = new HiveSyncTool(hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        tool.syncHoodieTable();
        Assert.assertTrue((String)("Table " + hiveSyncConfig.tableName + " should exist after sync completes"), (boolean)hiveClient.doesTableExist(hiveSyncConfig.tableName));
        Assert.assertEquals((String)"Hive Schema should match the table schema + partition fields", (long)hiveClient.getTableSchema(hiveSyncConfig.tableName).size(), (long)(hiveClient.getDataSchema().getColumns().size() + 3));
        Assert.assertEquals((String)"Table partitions should match the number of partitions we wrote", (long)5L, (long)hiveClient.scanTablePartitions(hiveSyncConfig.tableName).size());
        Assert.assertEquals((String)"The last commit that was sycned should be updated in the TBLPROPERTIES", (Object)commitTime, (Object)hiveClient.getLastCommitTimeSynced(hiveSyncConfig.tableName).get());
    }

    @Test
    public void testReadSchemaForMOR() throws Exception {
        TestUtil.hiveSyncConfig.useJdbc = this.useJdbc;
        String commitTime = "100";
        String snapshotTableName = TestUtil.hiveSyncConfig.tableName + "_rt";
        TestUtil.createMORTable(commitTime, "", 5, false);
        HoodieHiveClient hiveClientRT = new HoodieHiveClient(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        Assert.assertFalse((String)("Table " + TestUtil.hiveSyncConfig.tableName + "_rt" + " should not exist initially"), (boolean)hiveClientRT.doesTableExist(snapshotTableName));
        HiveSyncTool tool = new HiveSyncTool(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        tool.syncHoodieTable();
        Assert.assertTrue((String)("Table " + TestUtil.hiveSyncConfig.tableName + "_rt" + " should exist after sync completes"), (boolean)hiveClientRT.doesTableExist(snapshotTableName));
        Assert.assertEquals((String)"Hive Schema should match the table schema + partition field", (long)hiveClientRT.getTableSchema(snapshotTableName).size(), (long)(SchemaTestUtil.getSimpleSchema().getFields().size() + 1));
        Assert.assertEquals((String)"Table partitions should match the number of partitions we wrote", (long)5L, (long)hiveClientRT.scanTablePartitions(snapshotTableName).size());
        DateTime dateTime = DateTime.now().plusDays(6);
        String commitTime2 = "102";
        String deltaCommitTime2 = "103";
        TestUtil.addMORPartitions(1, true, false, dateTime, commitTime2, deltaCommitTime2);
        tool = new HiveSyncTool(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        tool.syncHoodieTable();
        hiveClientRT = new HoodieHiveClient(TestUtil.hiveSyncConfig, TestUtil.getHiveConf(), TestUtil.fileSystem);
        Assert.assertEquals((String)"Hive Schema should match the evolved table schema + partition field", (long)hiveClientRT.getTableSchema(snapshotTableName).size(), (long)(SchemaTestUtil.getEvolvedSchema().getFields().size() + 1));
        Assert.assertEquals((String)"The 1 partition we wrote should be added to hive", (long)6L, (long)hiveClientRT.scanTablePartitions(snapshotTableName).size());
        Assert.assertEquals((String)"The last commit that was sycned should be 103", (Object)deltaCommitTime2, (Object)hiveClientRT.getLastCommitTimeSynced(snapshotTableName).get());
    }
}

