/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.avro.Schema;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.io.hadoop.TestHoodieHFileReaderWriterBase;
import org.apache.hudi.io.hadoop.TestHoodieReaderWriterBase;
import org.apache.hudi.io.storage.HoodieAvroFileReader;
import org.apache.hudi.io.storage.HoodieAvroHFileReaderImplBase;
import org.apache.hudi.io.storage.HoodieNativeAvroHFileReader;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieHFileReaderWriter
extends TestHoodieHFileReaderWriterBase {
    @Override
    protected HoodieAvroFileReader createReader(HoodieStorage storage) throws Exception {
        return new HoodieNativeAvroHFileReader(storage, this.getFilePath(), Option.empty());
    }

    @Override
    protected HoodieAvroHFileReaderImplBase createHFileReader(HoodieStorage storage, byte[] content) throws IOException {
        return new HoodieNativeAvroHFileReader(storage, content, Option.empty());
    }

    @Override
    protected void verifyHFileReader(byte[] content, String hfileName, boolean mayUseDefaultComparator, Class<?> expectedComparatorClazz, int count) throws IOException {
        try (HoodieAvroHFileReaderImplBase hfileReader = this.createHFileReader(HoodieTestUtils.getStorage((String)hfileName), content);){
            Assertions.assertEquals((long)count, (long)hfileReader.getTotalRecords());
        }
    }

    @Test
    public void testReaderGetRecordIteratorByKeysWithBackwardSeek() throws Exception {
        this.writeFileWithSimpleSchema();
        try (HoodieAvroHFileReaderImplBase hfileReader = (HoodieAvroHFileReaderImplBase)this.createReader(HoodieTestUtils.getStorage((StoragePath)this.getFilePath()));){
            Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchema.avsc");
            ClosableIterator iterator = hfileReader.getIndexedRecordsByKeysIterator(Arrays.asList("key00001", "key05", "key24", "key16", "key31", "key61"), avroSchema);
            Assertions.assertThrows(IllegalStateException.class, () -> TestHoodieHFileReaderWriter.lambda$testReaderGetRecordIteratorByKeysWithBackwardSeek$0((Iterator)iterator));
        }
    }

    private static /* synthetic */ void lambda$testReaderGetRecordIteratorByKeysWithBackwardSeek$0(Iterator iterator) throws Throwable {
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).collect(Collectors.toList());
    }
}

