/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.serialization.CustomSerializer;
import org.apache.hudi.common.serialization.DefaultSerializer;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.testutils.SpillableMapTestUtils;
import org.apache.hudi.common.util.collection.RocksDbDiskMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRocksDbBasedMap
extends HoodieCommonTestHarness {
    @BeforeEach
    public void setUp() {
        this.initPath();
    }

    @Test
    public void testSimple() throws IOException, URISyntaxException {
        try (RocksDbDiskMap records = new RocksDbDiskMap(this.basePath, (CustomSerializer)new DefaultSerializer());){
            SchemaTestUtil testUtil = new SchemaTestUtil();
            List iRecords = testUtil.generateHoodieTestRecords(0, 100);
            ((GenericRecord)iRecords.get(0)).get(HoodieRecord.COMMIT_TIME_METADATA_FIELD).toString();
            List recordKeys = SpillableMapTestUtils.upsertRecords((List)iRecords, (Map)records);
            Iterator itr = records.iterator();
            ArrayList<HoodieRecord> oRecords = new ArrayList<HoodieRecord>();
            while (itr.hasNext()) {
                HoodieRecord rec = (HoodieRecord)itr.next();
                oRecords.add(rec);
                assert (recordKeys.contains(rec.getRecordKey()));
            }
            Assertions.assertEquals((int)recordKeys.size(), (int)oRecords.size());
        }
    }
}

