/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils.minicluster;

import java.io.IOException;
import java.net.BindException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hudi.common.testutils.NetworkTestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsTestService {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsTestService.class);
    private final Configuration hadoopConf;
    private final Path dfsBaseDirPath;
    private MiniDFSCluster miniDfsCluster;

    public HdfsTestService() throws IOException {
        this(new Configuration());
    }

    public HdfsTestService(Configuration hadoopConf) throws IOException {
        this.hadoopConf = hadoopConf;
        this.dfsBaseDirPath = Files.createTempDirectory("hdfs-test-service" + System.currentTimeMillis(), new FileAttribute[0]);
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    public MiniDFSCluster start(boolean format) throws IOException {
        Objects.requireNonNull(this.dfsBaseDirPath, "dfs base dir must be set before starting cluster.");
        if (format) {
            LOG.info("Cleaning HDFS cluster data at: " + this.dfsBaseDirPath + " and starting fresh.");
            Files.deleteIfExists(this.dfsBaseDirPath);
        }
        int loop = 0;
        while (true) {
            try {
                int namenodeRpcPort = NetworkTestUtils.nextFreePort();
                int datanodePort = NetworkTestUtils.nextFreePort();
                int datanodeIpcPort = NetworkTestUtils.nextFreePort();
                int datanodeHttpPort = NetworkTestUtils.nextFreePort();
                String bindIP = "127.0.0.1";
                HdfsTestService.configureDFSCluster(this.hadoopConf, this.dfsBaseDirPath.toString(), bindIP, namenodeRpcPort, datanodePort, datanodeIpcPort, datanodeHttpPort);
                this.miniDfsCluster = new MiniDFSCluster.Builder(this.hadoopConf).numDataNodes(1).format(format).checkDataNodeAddrConfig(true).checkDataNodeHostConfig(true).build();
                LOG.info("HDFS Minicluster service started.");
                return this.miniDfsCluster;
            }
            catch (BindException ex) {
                if (++loop < 5) {
                    this.stop();
                    continue;
                }
                throw ex;
            }
            break;
        }
    }

    public void stop() {
        LOG.info("HDFS Minicluster service being shut down.");
        if (this.miniDfsCluster != null) {
            this.miniDfsCluster.shutdown(true, true);
        }
        this.miniDfsCluster = null;
    }

    private static Configuration configureDFSCluster(Configuration config, String dfsBaseDir, String bindIP, int namenodeRpcPort, int datanodePort, int datanodeIpcPort, int datanodeHttpPort) {
        LOG.info("HDFS force binding to ip: " + bindIP);
        config.set("fs.defaultFS", "hdfs://" + bindIP + ":" + namenodeRpcPort);
        config.set("dfs.datanode.address", bindIP + ":" + datanodePort);
        config.set("dfs.datanode.ipc.address", bindIP + ":" + datanodeIpcPort);
        config.set("dfs.datanode.http.address", bindIP + ":" + datanodeHttpPort);
        config.setBoolean("dfs.namenode.datanode.registration.ip-hostname-check", false);
        config.set("hdfs.minidfs.basedir", dfsBaseDir);
        String user = System.getProperty("user.name");
        config.set("hadoop.proxyuser." + user + ".groups", "*");
        config.set("hadoop.proxyuser." + user + ".hosts", "*");
        config.setBoolean("dfs.permissions", false);
        config.set("dfs.blocksize", "16777216");
        return config;
    }
}

