/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs.inline;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.testutils.FileSystemTestUtils;
import org.apache.hudi.hadoop.fs.inline.InMemoryFileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestInMemoryFileSystem {
    private Configuration conf = new Configuration();

    public TestInMemoryFileSystem() {
        this.conf.set("fs.inmemfs.impl", InMemoryFileSystem.class.getName());
    }

    @Test
    public void testCreateWriteGetFileAsBytes() throws IOException {
        Path outerInMemFSPath = FileSystemTestUtils.getRandomOuterInMemPath();
        FSDataOutputStream out = outerInMemFSPath.getFileSystem(this.conf).create(outerInMemFSPath, true);
        byte[] randomBytes = new byte[FileSystemTestUtils.RANDOM.nextInt(1000)];
        FileSystemTestUtils.RANDOM.nextBytes(randomBytes);
        out.write(randomBytes);
        out.close();
        InMemoryFileSystem inMemoryFileSystem = (InMemoryFileSystem)outerInMemFSPath.getFileSystem(this.conf);
        byte[] bytesRead = inMemoryFileSystem.getFileAsBytes();
        Assertions.assertArrayEquals((byte[])randomBytes, (byte[])bytesRead);
        Assertions.assertEquals((Object)"inmemfs", (Object)inMemoryFileSystem.getScheme());
        Assertions.assertEquals((Object)URI.create(outerInMemFSPath.toString()), (Object)inMemoryFileSystem.getUri());
    }

    @Test
    public void testOpen() throws IOException {
        Path outerInMemFSPath = FileSystemTestUtils.getRandomOuterInMemPath();
        Assertions.assertNull((Object)outerInMemFSPath.getFileSystem(this.conf).open(outerInMemFSPath));
    }

    @Test
    public void testAppend() throws IOException {
        Path outerInMemFSPath = FileSystemTestUtils.getRandomOuterInMemPath();
        Assertions.assertNull((Object)outerInMemFSPath.getFileSystem(this.conf).append(outerInMemFSPath));
    }

    @Test
    public void testRename() throws IOException {
        Path outerInMemFSPath = FileSystemTestUtils.getRandomOuterInMemPath();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> outerInMemFSPath.getFileSystem(this.conf).rename(outerInMemFSPath, outerInMemFSPath), (String)"Should have thrown exception");
    }

    @Test
    public void testDelete() throws IOException {
        Path outerInMemFSPath = FileSystemTestUtils.getRandomOuterInMemPath();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> outerInMemFSPath.getFileSystem(this.conf).delete(outerInMemFSPath, true), (String)"Should have thrown exception");
    }

    @Test
    public void testgetWorkingDir() throws IOException {
        Path outerInMemFSPath = FileSystemTestUtils.getRandomOuterInMemPath();
        Assertions.assertNull((Object)outerInMemFSPath.getFileSystem(this.conf).getWorkingDirectory());
    }

    @Test
    public void testsetWorkingDirectory() throws IOException {
        Path outerInMemFSPath = FileSystemTestUtils.getRandomOuterInMemPath();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> outerInMemFSPath.getFileSystem(this.conf).setWorkingDirectory(outerInMemFSPath), (String)"Should have thrown exception");
    }

    @Test
    public void testExists() throws IOException {
        Path outerInMemFSPath = FileSystemTestUtils.getRandomOuterInMemPath();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> outerInMemFSPath.getFileSystem(this.conf).exists(outerInMemFSPath), (String)"Should have thrown exception");
    }

    @Test
    public void testFileStatus() throws IOException {
        Path outerInMemFSPath = FileSystemTestUtils.getRandomOuterInMemPath();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> outerInMemFSPath.getFileSystem(this.conf).getFileStatus(outerInMemFSPath), (String)"Should have thrown exception");
    }

    @Test
    public void testListStatus() throws IOException {
        Path outerInMemFSPath = FileSystemTestUtils.getRandomOuterInMemPath();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> outerInMemFSPath.getFileSystem(this.conf).listStatus(outerInMemFSPath), (String)"Should have thrown exception");
    }
}

