/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs.inline;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hudi.common.fs.inline.TestInLineFileSystemHFileInLiningBase;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.hadoop.fs.inline.InLineFileSystem;
import org.apache.hudi.io.hadoop.HoodieHFileUtils;
import org.apache.hudi.io.util.IOUtils;
import org.junit.jupiter.api.Assertions;

public class TestInLineFileSystemWithHBaseHFileReader
extends TestInLineFileSystemHFileInLiningBase {
    @Override
    protected void validateHFileReading(InLineFileSystem inlineFileSystem, Configuration conf, Configuration inlineConf, Path inlinePath, int maxRows) throws IOException {
        try (HFile.Reader reader = HoodieHFileUtils.createHFileReader((FileSystem)inlineFileSystem, (Path)inlinePath, (CacheConfig)new CacheConfig(conf), (Configuration)inlineConf);){
            int[] invalidRowIds;
            HFileScanner scanner = reader.getScanner(true, false);
            scanner.seekTo();
            this.readAllRecords(scanner, maxRows);
            Set<Integer> rowIdsToSearch = this.getRandomValidRowIds(10);
            for (int rowId : rowIdsToSearch) {
                KeyValue.KeyOnlyKeyValue keyValue = new KeyValue.KeyOnlyKeyValue(this.getSomeKey(rowId));
                Assertions.assertEquals((int)0, (int)scanner.seekTo((Cell)keyValue), (String)"location lookup failed");
                Cell cell = scanner.getCell();
                byte[] key = Arrays.copyOfRange(cell.getRowArray(), cell.getRowOffset(), cell.getRowOffset() + cell.getRowLength());
                byte[] expectedKey = Arrays.copyOfRange(keyValue.getRowArray(), keyValue.getRowOffset(), keyValue.getRowOffset() + keyValue.getRowLength());
                Assertions.assertArrayEquals((byte[])expectedKey, (byte[])key, (String)"seeked key does not match");
                scanner.seekTo((Cell)keyValue);
                ByteBuffer val1 = scanner.getValue();
                scanner.seekTo((Cell)keyValue);
                ByteBuffer val2 = scanner.getValue();
                Assertions.assertArrayEquals((byte[])IOUtils.toBytes((ByteBuffer)val1), (byte[])IOUtils.toBytes((ByteBuffer)val2));
            }
            for (int rowId : invalidRowIds = new int[]{-4, maxRows, maxRows + 1, maxRows + 120, maxRows + 160, maxRows + 1000}) {
                Assertions.assertNotEquals((int)0, (int)scanner.seekTo((Cell)new KeyValue.KeyOnlyKeyValue(this.getSomeKey(rowId))), (String)"location lookup should have failed");
            }
        }
    }

    private byte[] getSomeKey(int rowId) {
        KeyValue kv = new KeyValue(StringUtils.getUTF8Bytes((String)String.format("%010d", rowId)), StringUtils.getUTF8Bytes((String)"family"), StringUtils.getUTF8Bytes((String)"qual"), Long.MAX_VALUE, KeyValue.Type.Put);
        return kv.getKey();
    }

    private void readAllRecords(HFileScanner scanner, int maxRows) throws IOException {
        this.readAndCheckbytes(scanner, 0, maxRows);
    }

    private void readAndCheckbytes(HFileScanner scanner, int start, int n) throws IOException {
        int i;
        for (i = start; i < start + n; ++i) {
            Cell cell = scanner.getCell();
            byte[] key = Arrays.copyOfRange(cell.getRowArray(), cell.getRowOffset(), cell.getRowOffset() + cell.getRowLength());
            byte[] val = Arrays.copyOfRange(cell.getValueArray(), cell.getValueOffset(), cell.getValueOffset() + cell.getValueLength());
            String keyStr = String.format("%010d", i);
            String valStr = "value" + keyStr;
            KeyValue kv = new KeyValue(StringUtils.getUTF8Bytes((String)keyStr), StringUtils.getUTF8Bytes((String)"family"), StringUtils.getUTF8Bytes((String)"qual"), StringUtils.getUTF8Bytes((String)valStr));
            byte[] keyBytes = new KeyValue.KeyOnlyKeyValue(key, 0, key.length).getKey();
            byte[] expectedKeyBytes = Arrays.copyOfRange(kv.getRowArray(), kv.getRowOffset(), kv.getRowOffset() + kv.getRowLength());
            Assertions.assertArrayEquals((byte[])expectedKeyBytes, (byte[])keyBytes, (String)("bytes for keys do not match " + keyStr + " " + StringUtils.fromUTF8Bytes((byte[])key)));
            Assertions.assertArrayEquals((byte[])StringUtils.getUTF8Bytes((String)valStr), (byte[])val, (String)("bytes for vals do not match " + valStr + " " + StringUtils.fromUTF8Bytes((byte[])val)));
            if (!scanner.next()) break;
        }
        Assertions.assertEquals((int)i, (int)(start + n - 1));
    }
}

