/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hudi.common.fs.ConsistencyGuard;
import org.apache.hudi.common.fs.NoOpConsistencyGuard;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.minicluster.HdfsTestService;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.fs.HoodieWrapperFileSystem;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class TestHoodieWrapperFileSystem {
    private static String basePath;
    private static FileSystem fs;
    private static HdfsTestService hdfsTestService;
    private static MiniDFSCluster dfsCluster;

    TestHoodieWrapperFileSystem() {
    }

    @BeforeAll
    public static void setUp() throws IOException {
        if (HoodieTestUtils.shouldUseExternalHdfs()) {
            fs = HoodieTestUtils.useExternalHdfs();
        } else {
            hdfsTestService = new HdfsTestService((Configuration)HoodieTestUtils.getDefaultStorageConf().unwrap());
            dfsCluster = hdfsTestService.start(true);
            fs = dfsCluster.getFileSystem();
        }
        basePath = fs.getWorkingDirectory() + "/TestHoodieWrapperFileSystem/";
        fs.mkdirs(new Path(basePath));
    }

    @AfterAll
    public static void cleanUp() {
        if (hdfsTestService != null) {
            hdfsTestService.stop();
        }
    }

    @Test
    public void testCreateImmutableFileInPath() throws IOException {
        HoodieWrapperFileSystem fs = new HoodieWrapperFileSystem(HadoopFSUtils.getFs((String)basePath, (Configuration)new Configuration()), (ConsistencyGuard)new NoOpConsistencyGuard());
        String testContent = "test content";
        StoragePath testFile = new StoragePath(basePath + "/" + "clean.00000001");
        HoodieHadoopStorage storage = new HoodieHadoopStorage((FileSystem)fs);
        storage.createImmutableFileInPath(testFile, Option.of(outputStream -> outputStream.write(testContent.getBytes())));
        storage.createImmutableFileInPath(testFile, Option.of(outputStream -> outputStream.write(testContent.getBytes())));
        List pathInfoList = storage.listDirectEntries(new StoragePath(basePath));
        Assertions.assertEquals((int)1, (int)pathInfoList.size(), (String)("create same file twice should only have one file exists, files: " + pathInfoList));
    }
}

