/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bootstrap.index;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.BaseHoodieTableFileIndex;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.HoodieTableQueryType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class TestBaseHoodieTableFileIndex
extends HoodieCommonTestHarness {
    TestBaseHoodieTableFileIndex() {
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void testGetFileSlicesCount(boolean useSpillableMap) throws IOException {
        TestLocalIndex baseHoodieTableFileIndex;
        this.initMetaClient();
        TypedProperties properties = new TypedProperties();
        if (useSpillableMap) {
            properties.put((Object)HoodieCommonConfig.HOODIE_FILE_INDEX_USE_SPILLABLE_MAP.key(), (Object)true);
        }
        Assertions.assertTrue(((baseHoodieTableFileIndex = new TestLocalIndex((HoodieEngineContext)new HoodieLocalEngineContext(HadoopFSUtils.getStorageConf()), this.metaClient, properties, HoodieTableQueryType.READ_OPTIMIZED, Collections.emptyList(), (Option<String>)Option.empty(), false, true, null, true, (Option<String>)Option.empty(), (Option<String>)Option.empty())).getFileSlicesCount() == 0 ? 1 : 0) != 0);
    }

    private static class TestLocalIndex
    extends BaseHoodieTableFileIndex {
        public TestLocalIndex(HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, TypedProperties configProperties, HoodieTableQueryType queryType, List<StoragePath> queryPaths, Option<String> specifiedQueryInstant, boolean shouldIncludePendingCommits, boolean shouldValidateInstant, BaseHoodieTableFileIndex.FileStatusCache fileStatusCache, boolean shouldListLazily, Option<String> startCompletionTime, Option<String> endCompletionTime) {
            super(engineContext, metaClient, configProperties, queryType, queryPaths, specifiedQueryInstant, shouldIncludePendingCommits, shouldValidateInstant, fileStatusCache, shouldListLazily, startCompletionTime, endCompletionTime);
        }

        protected Object[] parsePartitionColumnValues(String[] partitionColumns, String partitionPath) {
            return new Object[0];
        }
    }
}

