/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.FileCreateUtils;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieTableMetadataUtil
extends HoodieCommonTestHarness {
    private static HoodieTestTable hoodieTestTable;
    private static final List<String> DATE_PARTITIONS;

    @BeforeEach
    public void setUp() throws IOException {
        this.initMetaClient();
        this.initTestDataGenerator(DATE_PARTITIONS.toArray(new String[0]));
        hoodieTestTable = HoodieTestTable.of(this.metaClient);
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.metaClient.getStorage().deleteDirectory(this.metaClient.getBasePath());
        this.cleanupTestDataGenerator();
        this.cleanMetaClient();
    }

    @Test
    public void testReadRecordKeysFromBaseFilesWithEmptyPartitionBaseFilePairs() {
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(this.metaClient.getStorageConf());
        List partitionFileSlicePairs = Collections.emptyList();
        HoodieData result = HoodieTableMetadataUtil.readRecordKeysFromFileSlices((HoodieEngineContext)engineContext, partitionFileSlicePairs, (boolean)false, (int)1, (String)"activeModule", (HoodieTableMetaClient)this.metaClient, (EngineType)EngineType.SPARK);
        Assertions.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testConvertFilesToPartitionStatsRecords() throws Exception {
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(this.metaClient.getStorageConf());
        String instant1 = "20230918120000000";
        hoodieTestTable = hoodieTestTable.addCommit(instant1);
        String instant2 = "20230918121110000";
        hoodieTestTable = hoodieTestTable.addCommit(instant2);
        ArrayList partitionInfoList = new ArrayList();
        DATE_PARTITIONS.forEach(p -> {
            try {
                URI partitionMetaFile = FileCreateUtils.createPartitionMetaFile((String)this.basePath, (String)p);
                StoragePath partitionMetadataPath = new StoragePath(partitionMetaFile);
                String fileId1 = UUID.randomUUID().toString();
                FileSlice fileSlice1 = new FileSlice(p, instant1, fileId1);
                StoragePath storagePath1 = new StoragePath(hoodieTestTable.getBaseFilePath((String)p, fileId1).toUri());
                TestHoodieTableMetadataUtil.writeParquetFile(instant1, storagePath1, this.dataGen.generateInsertsForPartition(instant1, Integer.valueOf(10), p), this.metaClient, engineContext);
                HoodieBaseFile baseFile1 = new HoodieBaseFile(hoodieTestTable.getBaseFilePath((String)p, fileId1).toString());
                fileSlice1.setBaseFile(baseFile1);
                String fileId2 = UUID.randomUUID().toString();
                FileSlice fileSlice2 = new FileSlice(p, instant2, fileId2);
                StoragePath storagePath2 = new StoragePath(hoodieTestTable.getBaseFilePath((String)p, fileId2).toUri());
                TestHoodieTableMetadataUtil.writeParquetFile(instant2, storagePath2, this.dataGen.generateInsertsForPartition(instant2, Integer.valueOf(10), p), this.metaClient, engineContext);
                HoodieBaseFile baseFile2 = new HoodieBaseFile(hoodieTestTable.getBaseFilePath((String)p, fileId2).toString());
                fileSlice2.setBaseFile(baseFile2);
                partitionInfoList.add(new HoodieTableMetadataUtil.DirectoryInfo(p, this.metaClient.getStorage().listDirectEntries(Arrays.asList(partitionMetadataPath, storagePath1, storagePath2)), instant2, Collections.emptySet()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        List<String> columnsToIndex = Arrays.asList("rider", "driver");
        HoodieData result = HoodieTableMetadataUtil.convertFilesToPartitionStatsRecords((HoodieEngineContext)engineContext, partitionInfoList, (HoodieMetadataConfig)HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).withMetadataIndexPartitionStats(true).withColumnStatsIndexForColumns("rider,driver").withPartitionStatsIndexParallelism(1).build(), (HoodieTableMetaClient)this.metaClient);
        List records = result.collectAsList();
        Assertions.assertEquals((int)6, (int)records.size());
        Assertions.assertEquals((Object)MetadataPartitionType.PARTITION_STATS.getPartitionPath(), (Object)((HoodieRecord)records.get(0)).getPartitionPath());
        ((HoodieMetadataColumnStats)((HoodieMetadataPayload)((HoodieRecord)result.collectAsList().get(0)).getData()).getColumnStatMetadata().get()).getColumnName();
        records.forEach(r -> {
            HoodieMetadataPayload payload = (HoodieMetadataPayload)r.getData();
            Assertions.assertTrue((boolean)payload.getColumnStatMetadata().isPresent());
            if (((HoodieMetadataColumnStats)payload.getColumnStatMetadata().get()).getColumnName().equals("rider")) {
                Assertions.assertEquals((Object)String.format("{\"value\": \"rider-%s\"}", instant1), (Object)String.valueOf(((HoodieMetadataColumnStats)payload.getColumnStatMetadata().get()).getMinValue()));
                Assertions.assertEquals((Object)String.format("{\"value\": \"rider-%s\"}", instant2), (Object)String.valueOf(((HoodieMetadataColumnStats)payload.getColumnStatMetadata().get()).getMaxValue()));
            } else if (((HoodieMetadataColumnStats)payload.getColumnStatMetadata().get()).getColumnName().equals("driver")) {
                Assertions.assertEquals((Object)String.format("{\"value\": \"driver-%s\"}", instant1), (Object)String.valueOf(((HoodieMetadataColumnStats)payload.getColumnStatMetadata().get()).getMinValue()));
                Assertions.assertEquals((Object)String.format("{\"value\": \"driver-%s\"}", instant2), (Object)String.valueOf(((HoodieMetadataColumnStats)payload.getColumnStatMetadata().get()).getMaxValue()));
            }
        });
    }

    @Test
    public void testReadRecordKeysFromBaseFilesWithValidRecords() throws Exception {
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(this.metaClient.getStorageConf());
        String instant = "20230918120000000";
        hoodieTestTable = hoodieTestTable.addCommit(instant);
        HashSet recordKeys = new HashSet();
        ArrayList partitionFileSlicePairs = new ArrayList();
        DATE_PARTITIONS.forEach(p -> {
            try {
                List hoodieRecords = this.dataGen.generateInsertsForPartition(instant, Integer.valueOf(10), p);
                String fileId = UUID.randomUUID().toString();
                FileSlice fileSlice = new FileSlice(p, instant, fileId);
                TestHoodieTableMetadataUtil.writeParquetFile(instant, new StoragePath(hoodieTestTable.getBaseFilePath((String)p, fileId).toUri()), hoodieRecords, this.metaClient, engineContext);
                HoodieBaseFile baseFile = new HoodieBaseFile(hoodieTestTable.getBaseFilePath((String)p, fileId).toString(), fileId, instant, null);
                fileSlice.setBaseFile(baseFile);
                partitionFileSlicePairs.add(Pair.of((Object)p, (Object)fileSlice));
                recordKeys.addAll(hoodieRecords.stream().map(HoodieRecord::getRecordKey).collect(Collectors.toSet()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        HoodieData result = HoodieTableMetadataUtil.readRecordKeysFromFileSlices((HoodieEngineContext)engineContext, partitionFileSlicePairs, (boolean)false, (int)1, (String)"activeModule", (HoodieTableMetaClient)this.metaClient, (EngineType)EngineType.SPARK);
        List records = result.collectAsList();
        Assertions.assertEquals((int)30, (int)records.size());
        Assertions.assertEquals((Object)MetadataPartitionType.RECORD_INDEX.getPartitionPath(), (Object)((HoodieRecord)records.get(0)).getPartitionPath());
        for (HoodieRecord record : records) {
            Assertions.assertTrue((boolean)recordKeys.contains(record.getRecordKey()));
        }
    }

    private static void writeParquetFile(String instant, StoragePath path, List<HoodieRecord> records, HoodieTableMetaClient metaClient, HoodieLocalEngineContext engineContext) throws IOException {
        HoodieFileWriter writer = HoodieFileWriterFactory.getFileWriter((String)instant, (StoragePath)path, (HoodieStorage)metaClient.getStorage(), (HoodieConfig)metaClient.getTableConfig(), (Schema)HoodieTestDataGenerator.AVRO_SCHEMA_WITH_METADATA_FIELDS, (TaskContextSupplier)engineContext.getTaskContextSupplier(), (HoodieRecord.HoodieRecordType)HoodieRecord.HoodieRecordType.AVRO);
        for (HoodieRecord record : records) {
            writer.writeWithMetadata(record.getKey(), record, HoodieTestDataGenerator.AVRO_SCHEMA_WITH_METADATA_FIELDS);
        }
        writer.close();
    }

    static {
        DATE_PARTITIONS = Arrays.asList("2019/01/01", "2020/01/02", "2021/03/01");
    }
}

