/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.File;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.AvroOrcUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.io.hadoop.OrcReaderIterator;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestOrcReaderIterator {
    private final Path filePath = new Path(System.getProperty("java.io.tmpdir") + "/f1_1-0-1_000.orc");

    @BeforeEach
    @AfterEach
    public void clearTempFile() {
        File file = new File(this.filePath.toString());
        if (file.exists()) {
            file.delete();
        }
    }

    @Test
    public void testOrcIteratorReadData() throws Exception {
        Configuration conf = new Configuration();
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestOrcReaderIterator.class, (String)"/simple-test.avsc");
        TypeDescription orcSchema = AvroOrcUtils.createOrcSchema((Schema)avroSchema);
        OrcFile.WriterOptions options = OrcFile.writerOptions((Configuration)conf).setSchema(orcSchema).compress(CompressionKind.ZLIB);
        Writer writer = OrcFile.createWriter((Path)this.filePath, (OrcFile.WriterOptions)options);
        VectorizedRowBatch batch = orcSchema.createRowBatch();
        BytesColumnVector nameColumns = (BytesColumnVector)batch.cols[0];
        LongColumnVector numberColumns = (LongColumnVector)batch.cols[1];
        BytesColumnVector colorColumns = (BytesColumnVector)batch.cols[2];
        for (int r = 0; r < 5; ++r) {
            int row;
            ++batch.size;
            byte[] name = StringUtils.getUTF8Bytes((String)("name" + r));
            nameColumns.setVal(row, name);
            byte[] color = StringUtils.getUTF8Bytes((String)("color" + r));
            colorColumns.setVal(row, color);
            numberColumns.vector[row] = r;
        }
        writer.addRowBatch(batch);
        writer.close();
        Reader reader = OrcFile.createReader((Path)this.filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
        RecordReader recordReader = reader.rows(new Reader.Options(conf).schema(orcSchema));
        OrcReaderIterator iterator = new OrcReaderIterator(recordReader, avroSchema, orcSchema);
        int recordCount = 0;
        while (iterator.hasNext()) {
            GenericRecord record = (GenericRecord)iterator.next();
            Assertions.assertEquals((Object)("name" + recordCount), (Object)record.get("name").toString());
            Assertions.assertEquals((Object)("color" + recordCount), (Object)record.get("favorite_color").toString());
            Assertions.assertEquals((Object)recordCount, (Object)record.get("favorite_number"));
            ++recordCount;
        }
        Assertions.assertEquals((int)5, (int)recordCount);
    }
}

