/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieCompactionStrategy;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestCommitUtils {
    private static final String SINK_CHECKPOINT_KEY = "_hudi_streaming_sink_checkpoint";
    private static final String ID1 = "id1";
    private static final String ID2 = "id2";
    private static final String ID3 = "id3";
    @TempDir
    public Path tempDir;
    private HoodieTableMetaClient metaClient;

    private void init() throws IOException {
        Path basePath = this.tempDir.resolve("dataset");
        Files.createDirectories(basePath, new FileAttribute[0]);
        String basePathStr = basePath.toAbsolutePath().toString();
        this.metaClient = HoodieTestUtils.init((String)basePathStr, (HoodieTableType)HoodieTableType.MERGE_ON_READ);
    }

    @Test
    public void testCommitMetadataCreation() {
        ArrayList<HoodieWriteStat> writeStats = new ArrayList<HoodieWriteStat>();
        writeStats.add(this.createWriteStat("p1", "f1"));
        writeStats.add(this.createWriteStat("p2", "f2"));
        HashMap partitionToReplaceFileIds = new HashMap();
        ArrayList<String> replacedFileIds = new ArrayList<String>();
        replacedFileIds.add("f0");
        partitionToReplaceFileIds.put("p1", replacedFileIds);
        HoodieCommitMetadata commitMetadata = CommitUtils.buildMetadata(writeStats, partitionToReplaceFileIds, (Option)Option.empty(), (WriteOperationType)WriteOperationType.INSERT, (String)"{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}", (String)"deltacommit");
        Assertions.assertFalse((boolean)(commitMetadata instanceof HoodieReplaceCommitMetadata));
        Assertions.assertEquals((int)2, (int)commitMetadata.getPartitionToWriteStats().size());
        Assertions.assertEquals((Object)"f1", (Object)((HoodieWriteStat)((List)commitMetadata.getPartitionToWriteStats().get("p1")).get(0)).getFileId());
        Assertions.assertEquals((Object)"f2", (Object)((HoodieWriteStat)((List)commitMetadata.getPartitionToWriteStats().get("p2")).get(0)).getFileId());
        Assertions.assertEquals((Object)WriteOperationType.INSERT, (Object)commitMetadata.getOperationType());
        Assertions.assertEquals((Object)"{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}", (Object)commitMetadata.getMetadata("schema"));
    }

    @Test
    public void testReplaceMetadataCreation() {
        ArrayList<HoodieWriteStat> writeStats = new ArrayList<HoodieWriteStat>();
        writeStats.add(this.createWriteStat("p1", "f1"));
        writeStats.add(this.createWriteStat("p2", "f2"));
        HashMap partitionToReplaceFileIds = new HashMap();
        ArrayList<String> replacedFileIds = new ArrayList<String>();
        replacedFileIds.add("f0");
        partitionToReplaceFileIds.put("p1", replacedFileIds);
        HoodieCommitMetadata commitMetadata = CommitUtils.buildMetadata(writeStats, partitionToReplaceFileIds, (Option)Option.empty(), (WriteOperationType)WriteOperationType.INSERT, (String)"{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}", (String)"replacecommit");
        Assertions.assertTrue((boolean)(commitMetadata instanceof HoodieReplaceCommitMetadata));
        HoodieReplaceCommitMetadata replaceCommitMetadata = (HoodieReplaceCommitMetadata)commitMetadata;
        Assertions.assertEquals((int)1, (int)replaceCommitMetadata.getPartitionToReplaceFileIds().size());
        Assertions.assertEquals((Object)"f0", ((List)replaceCommitMetadata.getPartitionToReplaceFileIds().get("p1")).get(0));
        Assertions.assertEquals((int)2, (int)commitMetadata.getPartitionToWriteStats().size());
        Assertions.assertEquals((Object)"f1", (Object)((HoodieWriteStat)((List)commitMetadata.getPartitionToWriteStats().get("p1")).get(0)).getFileId());
        Assertions.assertEquals((Object)"f2", (Object)((HoodieWriteStat)((List)commitMetadata.getPartitionToWriteStats().get("p2")).get(0)).getFileId());
        Assertions.assertEquals((Object)WriteOperationType.INSERT, (Object)commitMetadata.getOperationType());
        Assertions.assertEquals((Object)"{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}", (Object)commitMetadata.getMetadata("schema"));
    }

    @Test
    public void testGetValidCheckpointForCurrentWriter() throws IOException {
        this.init();
        HoodieActiveTimeline timeline = new HoodieActiveTimeline(this.metaClient);
        this.addDeltaCommit(timeline, "20230913001000000", ID1, "3", true);
        this.addDeltaCommit(timeline, "20230913002000000", ID2, "4", true);
        this.addDeltaCommit(timeline, "20230913003000000", ID1, "5", true);
        this.addRequestedCompaction(timeline, "20230913003800000");
        this.addDeltaCommit(timeline, "20230913004000000", ID2, "6", true);
        this.addRequestedReplaceCommit(timeline, "20230913004800000");
        this.addDeltaCommit(timeline, "20230913005000000", ID2, "7", false);
        this.addCommit(timeline, "20230913006000000");
        timeline = timeline.reload();
        Assertions.assertEquals((Object)Option.of((Object)"5"), (Object)CommitUtils.getValidCheckpointForCurrentWriter((HoodieTimeline)timeline, (String)SINK_CHECKPOINT_KEY, (String)ID1));
        Assertions.assertEquals((Object)Option.of((Object)"6"), (Object)CommitUtils.getValidCheckpointForCurrentWriter((HoodieTimeline)timeline, (String)SINK_CHECKPOINT_KEY, (String)ID2));
        Assertions.assertEquals((Object)Option.empty(), (Object)CommitUtils.getValidCheckpointForCurrentWriter((HoodieTimeline)timeline, (String)SINK_CHECKPOINT_KEY, (String)ID3));
    }

    private HoodieWriteStat createWriteStat(String partition, String fileId) {
        HoodieWriteStat writeStat1 = new HoodieWriteStat();
        writeStat1.setPartitionPath(partition);
        writeStat1.setFileId(fileId);
        return writeStat1;
    }

    private void addDeltaCommit(HoodieActiveTimeline timeline, String ts, String id, String batchId, boolean isCompleted) throws IOException {
        HoodieInstant instant = new HoodieInstant(HoodieInstant.State.REQUESTED, "deltacommit", ts);
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        commitMetadata.setOperationType(WriteOperationType.UPSERT);
        commitMetadata.addMetadata(SINK_CHECKPOINT_KEY, CommitUtils.getCheckpointValueAsString((String)id, (String)batchId));
        timeline.createNewInstant(instant);
        timeline.transitionRequestedToInflight(instant, TimelineMetadataUtils.serializeCommitMetadata((HoodieCommitMetadata)commitMetadata));
        if (isCompleted) {
            timeline.saveAsComplete(new HoodieInstant(true, instant.getAction(), instant.getTimestamp()), TimelineMetadataUtils.serializeCommitMetadata((HoodieCommitMetadata)commitMetadata));
        }
    }

    private void addCommit(HoodieActiveTimeline timeline, String ts) throws IOException {
        HoodieInstant instant = new HoodieInstant(HoodieInstant.State.REQUESTED, "commit", ts);
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        commitMetadata.setOperationType(WriteOperationType.COMPACT);
        timeline.createNewInstant(instant);
        timeline.transitionRequestedToInflight(instant, TimelineMetadataUtils.serializeCommitMetadata((HoodieCommitMetadata)commitMetadata));
        timeline.saveAsComplete(new HoodieInstant(true, instant.getAction(), instant.getTimestamp()), TimelineMetadataUtils.serializeCommitMetadata((HoodieCommitMetadata)commitMetadata));
    }

    private void addRequestedCompaction(HoodieActiveTimeline timeline, String ts) throws IOException {
        HoodieCompactionPlan compactionPlan = HoodieCompactionPlan.newBuilder().setOperations(Collections.emptyList()).setVersion(CompactionUtils.LATEST_COMPACTION_METADATA_VERSION).setStrategy(HoodieCompactionStrategy.newBuilder().build()).setPreserveHoodieMetadata(Boolean.valueOf(true)).build();
        timeline.saveToCompactionRequested(new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", ts), TimelineMetadataUtils.serializeCompactionPlan((HoodieCompactionPlan)compactionPlan));
    }

    private void addRequestedReplaceCommit(HoodieActiveTimeline timeline, String ts) throws IOException {
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = HoodieRequestedReplaceMetadata.newBuilder().setOperationType(WriteOperationType.CLUSTER.name()).setExtraMetadata(Collections.emptyMap()).setClusteringPlan(new HoodieClusteringPlan()).build();
        timeline.saveToPendingReplaceCommit(new HoodieInstant(HoodieInstant.State.REQUESTED, "replacecommit", ts), TimelineMetadataUtils.serializeRequestedReplaceMetadata((HoodieRequestedReplaceMetadata)requestedReplaceMetadata));
    }
}

