/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.fs.ConsistencyGuard;
import org.apache.hudi.common.fs.NoOpConsistencyGuard;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.testutils.Assertions;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.MockHoodieTimeline;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HoodieWrapperFileSystem;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieActiveTimeline
extends HoodieCommonTestHarness {
    private HoodieActiveTimeline timeline;

    @BeforeEach
    public void setUp() throws Exception {
        this.initMetaClient();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanMetaClient();
    }

    @Test
    public void testLoadingInstantsFromFiles() throws IOException {
        HoodieInstant instant1 = new HoodieInstant(HoodieInstant.State.REQUESTED, "commit", "1");
        HoodieInstant instant2 = new HoodieInstant(HoodieInstant.State.REQUESTED, "commit", "3");
        HoodieInstant instant3 = new HoodieInstant(HoodieInstant.State.REQUESTED, "commit", "5");
        HoodieInstant instant4 = new HoodieInstant(HoodieInstant.State.REQUESTED, "commit", "8");
        HoodieInstant instant1Complete = new HoodieInstant(false, "commit", "1");
        HoodieInstant instant2Complete = new HoodieInstant(false, "commit", "3");
        HoodieInstant instant3Complete = new HoodieInstant(false, "commit", "5");
        HoodieInstant instant4Complete = new HoodieInstant(false, "commit", "8");
        HoodieInstant instant5 = new HoodieInstant(true, "commit", "9");
        this.timeline = new HoodieActiveTimeline(this.metaClient);
        this.timeline.createNewInstant(instant1);
        this.timeline.transitionRequestedToInflight(instant1, Option.empty());
        this.timeline.saveAsComplete(new HoodieInstant(true, instant1.getAction(), instant1.getTimestamp()), Option.empty());
        this.timeline.createNewInstant(instant2);
        this.timeline.transitionRequestedToInflight(instant2, Option.empty());
        this.timeline.saveAsComplete(new HoodieInstant(true, instant2.getAction(), instant2.getTimestamp()), Option.empty());
        this.timeline.createNewInstant(instant3);
        this.timeline.transitionRequestedToInflight(instant3, Option.empty());
        this.timeline.saveAsComplete(new HoodieInstant(true, instant3.getAction(), instant3.getTimestamp()), Option.empty());
        this.timeline.createNewInstant(instant4);
        this.timeline.transitionRequestedToInflight(instant4, Option.empty());
        this.timeline.saveAsComplete(new HoodieInstant(true, instant4.getAction(), instant4.getTimestamp()), Option.empty());
        this.timeline.createNewInstant(instant5);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)this.timeline.countInstants(), (String)"Total instants should be 5");
        Assertions.assertStreamEquals(Stream.of(instant1Complete, instant2Complete, instant3Complete, instant4Complete, instant5), (Stream)this.timeline.getInstantsAsStream(), (String)"Check the instants stream");
        Assertions.assertStreamEquals(Stream.of(instant1Complete, instant2Complete, instant3Complete, instant4Complete, instant5), (Stream)this.timeline.getCommitTimeline().getInstantsAsStream(), (String)"Check the instants stream");
        Assertions.assertStreamEquals(Stream.of(instant1Complete, instant2Complete, instant3Complete, instant4Complete, instant5), (Stream)this.timeline.getCommitAndReplaceTimeline().getInstantsAsStream(), (String)"Check the instants stream");
        Assertions.assertStreamEquals(Stream.of(instant1Complete, instant2Complete, instant3Complete, instant4Complete), (Stream)this.timeline.getCommitAndReplaceTimeline().filterCompletedInstants().getInstantsAsStream(), (String)"Check the instants stream");
        Assertions.assertStreamEquals(Stream.of(instant5), (Stream)this.timeline.getCommitAndReplaceTimeline().filterPendingExcludingMajorAndMinorCompaction().getInstantsAsStream(), (String)"Check the instants stream");
        this.metaClient = HoodieTableMetaClient.withPropertyBuilder().fromMetaClient(this.metaClient).setTimelineLayoutVersion(TimelineLayoutVersion.VERSION_0).initTable(this.metaClient.getStorageConf().newInstance(), this.metaClient.getBasePath());
        HoodieInstant instant6 = new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", "9");
        byte[] dummy = new byte[5];
        HoodieActiveTimeline oldTimeline = new HoodieActiveTimeline(HoodieTableMetaClient.builder().setConf(this.metaClient.getStorageConf().newInstance()).setBasePath(this.metaClient.getBasePath()).setLoadActiveTimelineOnLoad(true).setConsistencyGuardConfig(this.metaClient.getConsistencyGuardConfig()).setFileSystemRetryConfig(this.metaClient.getFileSystemRetryConfig()).setLayoutVersion(Option.of((Object)new TimelineLayoutVersion(TimelineLayoutVersion.VERSION_0))).build());
        oldTimeline.saveToCompactionRequested(instant6, Option.of((Object)dummy));
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.metaClient.getStorage().exists(new StoragePath(this.metaClient.getMetaPath(), instant6.getFileName())));
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)((byte[])this.timeline.readCompactionPlanAsBytes(instant6).get()).length);
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)((byte[])this.timeline.readCompactionPlanAsBytes(instant6).get()).length);
    }

    @Test
    public void testTimelineOperationsBasic() {
        this.timeline = new HoodieActiveTimeline(this.metaClient);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.empty());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Option.empty(), (Object)this.timeline.firstInstant());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Option.empty(), (Object)this.timeline.nthInstant(5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Option.empty(), (Object)this.timeline.nthInstant(-1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Option.empty(), (Object)this.timeline.lastInstant());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(new HoodieInstant(false, "commit", "01")));
    }

    @Test
    public void testTimelineOperations() {
        this.timeline = new MockHoodieTimeline(Stream.of("01", "03", "05", "07", "09", "11", "13", "15", "17", "19"), Stream.of("21", "23"));
        Assertions.assertStreamEquals(Stream.of("05", "07", "09", "11"), this.timeline.getCommitAndReplaceTimeline().filterCompletedInstants().findInstantsInRange("04", "11").getInstantsAsStream().map(HoodieInstant::getTimestamp), (String)"findInstantsInRange should return 4 instants");
        Assertions.assertStreamEquals(Stream.of("03", "05", "07", "09", "11"), this.timeline.getCommitAndReplaceTimeline().filterCompletedInstants().findInstantsInClosedRange("03", "11").getInstantsAsStream().map(HoodieInstant::getTimestamp), (String)"findInstantsInClosedRange should return 5 instants");
        Assertions.assertStreamEquals(Stream.of("09", "11"), this.timeline.getCommitAndReplaceTimeline().filterCompletedInstants().findInstantsAfter("07", 2).getInstantsAsStream().map(HoodieInstant::getTimestamp), (String)"findInstantsAfter 07 should return 2 instants");
        Assertions.assertStreamEquals(Stream.of("01", "03", "05"), this.timeline.getCommitAndReplaceTimeline().filterCompletedInstants().findInstantsBefore("07").getInstantsAsStream().map(HoodieInstant::getTimestamp), (String)"findInstantsBefore 07 should return 3 instants");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.empty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.getCommitAndReplaceTimeline().filterPendingExcludingMajorAndMinorCompaction().empty());
        org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)this.timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"01", (Object)((HoodieInstant)this.timeline.firstInstant("commit", HoodieInstant.State.COMPLETED).get()).getTimestamp());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"21", (Object)((HoodieInstant)this.timeline.firstInstant("commit", HoodieInstant.State.INFLIGHT).get()).getTimestamp());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.firstInstant("commit", HoodieInstant.State.REQUESTED).isPresent());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.firstInstant("replacecommit", HoodieInstant.State.COMPLETED).isPresent());
        HoodieTimeline activeCommitTimeline = this.timeline.getCommitAndReplaceTimeline().filterCompletedInstants();
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)activeCommitTimeline.countInstants());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"01", (Object)((HoodieInstant)activeCommitTimeline.firstInstant().get()).getTimestamp());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"11", (Object)((HoodieInstant)activeCommitTimeline.nthInstant(5).get()).getTimestamp());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"19", (Object)((HoodieInstant)activeCommitTimeline.lastInstant().get()).getTimestamp());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"09", (Object)((HoodieInstant)activeCommitTimeline.nthFromLastInstant(5).get()).getTimestamp());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)activeCommitTimeline.containsInstant(new HoodieInstant(false, "commit", "09")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)activeCommitTimeline.isBeforeTimelineStarts("02"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)activeCommitTimeline.isBeforeTimelineStarts("00"));
    }

    @Test
    public void testAllowTempCommit() {
        this.shouldAllowTempCommit(true, hoodieMetaClient -> {
            this.timeline = new HoodieActiveTimeline(hoodieMetaClient);
            HoodieInstant instant1 = new HoodieInstant(true, "commit", "1");
            this.timeline.createNewInstant(instant1);
            byte[] data = StringUtils.getUTF8Bytes((String)"commit");
            this.timeline.saveAsComplete(new HoodieInstant(true, instant1.getAction(), instant1.getTimestamp()), Option.of((Object)data));
            this.timeline = this.timeline.reload();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.getContiguousCompletedWriteTimeline().lastInstant().isPresent());
            org.junit.jupiter.api.Assertions.assertEquals((Object)instant1.getTimestamp(), (Object)((HoodieInstant)this.timeline.getContiguousCompletedWriteTimeline().lastInstant().get()).getTimestamp());
        });
    }

    @Test
    public void testGetContiguousCompletedWriteTimeline() {
        this.timeline = new MockHoodieTimeline(Stream.of("01", "03", "05", "07", "13", "15", "17"), Stream.of("09", "11", "19"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.getContiguousCompletedWriteTimeline().lastInstant().isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"07", (Object)((HoodieInstant)this.timeline.getContiguousCompletedWriteTimeline().lastInstant().get()).getTimestamp());
        HoodieInstant instant1 = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "1");
        HoodieInstant instant2 = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "2");
        HoodieInstant instant3 = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "3");
        HoodieInstant instant4 = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "4");
        HoodieInstant instant5 = new HoodieInstant(true, "commit", "5");
        HoodieInstant instant6 = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "6");
        HoodieInstant instant7 = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "7");
        HoodieInstant instant8 = new HoodieInstant(true, "restore", "8");
        this.timeline = new HoodieActiveTimeline(this.metaClient);
        this.timeline.createCompleteInstant(instant1);
        this.timeline.createCompleteInstant(instant2);
        this.timeline.createCompleteInstant(instant3);
        this.timeline.createCompleteInstant(instant4);
        this.timeline.createNewInstant(instant5);
        this.timeline.createCompleteInstant(instant6);
        this.timeline.createCompleteInstant(instant7);
        this.timeline.createNewInstant(instant8);
        this.timeline.setInstants(Stream.of(instant1, instant2, instant3, instant4, instant5, instant6, instant7, instant8).collect(Collectors.toList()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.getContiguousCompletedWriteTimeline().lastInstant().isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)instant4.getTimestamp(), (Object)((HoodieInstant)this.timeline.getContiguousCompletedWriteTimeline().lastInstant().get()).getTimestamp());
        this.timeline.saveAsComplete(new HoodieInstant(true, instant5.getAction(), instant5.getTimestamp()), Option.empty());
        this.timeline.saveAsComplete(new HoodieInstant(true, instant8.getAction(), instant8.getTimestamp()), Option.empty());
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.getContiguousCompletedWriteTimeline().lastInstant().isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)instant7.getTimestamp(), (Object)((HoodieInstant)this.timeline.getContiguousCompletedWriteTimeline().lastInstant().get()).getTimestamp());
    }

    @Test
    public void testTimelineWithSavepointAndHoles() {
        this.timeline = new MockHoodieTimeline(Stream.of(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "01"), new HoodieInstant(HoodieInstant.State.COMPLETED, "savepoint", "01"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "03"), new HoodieInstant(HoodieInstant.State.COMPLETED, "savepoint", "03"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "05")).collect(Collectors.toList()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("00"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("01"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("02"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("03"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("04"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.isBeforeTimelineStarts("05"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.isBeforeTimelineStarts("06"));
        this.timeline = new MockHoodieTimeline(Stream.of(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "01"), new HoodieInstant(HoodieInstant.State.INFLIGHT, "savepoint", "01"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "03"), new HoodieInstant(HoodieInstant.State.COMPLETED, "savepoint", "03"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "05")).collect(Collectors.toList()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("00"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("01"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("02"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("03"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("04"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.isBeforeTimelineStarts("05"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.isBeforeTimelineStarts("06"));
        this.timeline = new MockHoodieTimeline(Stream.of(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "01"), new HoodieInstant(HoodieInstant.State.COMPLETED, "savepoint", "01"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "03"), new HoodieInstant(HoodieInstant.State.COMPLETED, "savepoint", "03"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "05"), new HoodieInstant(HoodieInstant.State.INFLIGHT, "replacecommit", "06")).collect(Collectors.toList()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("00"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("01"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("02"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("03"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.isBeforeTimelineStarts("04"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.isBeforeTimelineStarts("05"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.isBeforeTimelineStarts("06"));
    }

    @Test
    public void testTimelineGetOperations() {
        List<HoodieInstant> allInstants = this.getAllInstants();
        Supplier<Stream> sup = allInstants::stream;
        this.timeline = new HoodieActiveTimeline(this.metaClient, true);
        this.timeline.setInstants(allInstants);
        BiConsumer<HoodieTimeline, Set> checkTimeline = (timeline, actions) -> {
            ((Stream)sup.get()).filter(i -> actions.contains(i.getAction())).forEach(i -> org.junit.jupiter.api.Assertions.assertTrue((boolean)timeline.containsInstant(i)));
            ((Stream)sup.get()).filter(i -> !actions.contains(i.getAction())).forEach(i -> org.junit.jupiter.api.Assertions.assertFalse((boolean)timeline.containsInstant(i)));
        };
        checkTimeline.accept(this.timeline.getCommitsTimeline(), CollectionUtils.createSet((Object[])new String[]{"commit", "deltacommit", "replacecommit"}));
        checkTimeline.accept((HoodieTimeline)this.timeline.getWriteTimeline(), CollectionUtils.createSet((Object[])new String[]{"commit", "deltacommit", "compaction", "replacecommit"}));
        checkTimeline.accept(this.timeline.getCommitAndReplaceTimeline(), CollectionUtils.createSet((Object[])new String[]{"commit", "replacecommit"}));
        checkTimeline.accept(this.timeline.getDeltaCommitTimeline(), Collections.singleton("deltacommit"));
        checkTimeline.accept(this.timeline.getCleanerTimeline(), Collections.singleton("clean"));
        checkTimeline.accept(this.timeline.getRollbackTimeline(), Collections.singleton("rollback"));
        checkTimeline.accept(this.timeline.getRestoreTimeline(), Collections.singleton("restore"));
        checkTimeline.accept(this.timeline.getSavePointTimeline(), Collections.singleton("savepoint"));
        checkTimeline.accept(this.timeline.getAllCommitsTimeline(), CollectionUtils.createSet((Object[])new String[]{"commit", "deltacommit", "clean", "compaction", "replacecommit", "savepoint", "rollback", "indexing"}));
        Random rand = new Random();
        Set randomInstants = sup.get().filter(i -> rand.nextBoolean()).map(HoodieInstant::getAction).collect(Collectors.toSet());
        checkTimeline.accept(this.timeline.getTimelineOfActions(randomInstants), randomInstants);
    }

    @Test
    public void testTimelineInstantOperations() {
        this.timeline = new HoodieActiveTimeline(this.metaClient, true);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.timeline.countInstants(), (String)"No instant present");
        HoodieInstant commit = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "1");
        this.timeline.createCompleteInstant(commit);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.timeline.countInstants());
        commit = (HoodieInstant)this.timeline.getInstantsAsStream().findFirst().get();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(commit));
        HoodieInstant inflight = this.timeline.revertToInflight(commit);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(inflight));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(commit));
        this.timeline.deleteInflight(inflight);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(inflight));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(commit));
        this.timeline.createCompleteInstant(commit);
        this.timeline.createNewInstant(inflight);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.timeline.countInstants());
        this.timeline.deletePending(inflight);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(inflight));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(commit));
        HoodieInstant compaction = new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", "2");
        this.timeline.createNewInstant(compaction);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.timeline.countInstants());
        this.timeline.deleteCompactionRequested(compaction);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(inflight));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(compaction));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(commit));
        compaction = new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", "3");
        this.timeline.createNewInstant(compaction);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(compaction));
        inflight = this.timeline.transitionCompactionRequestedToInflight(compaction);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(compaction));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(inflight));
        compaction = this.timeline.revertInstantFromInflightToRequested(inflight);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(compaction));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(inflight));
        inflight = this.timeline.transitionCompactionRequestedToInflight(compaction);
        compaction = this.timeline.transitionCompactionInflightToComplete(true, inflight, Option.empty());
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(compaction));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(inflight));
        HoodieInstant clean = new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", "4");
        this.timeline.saveToCleanRequested(clean, Option.empty());
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(clean));
        inflight = this.timeline.transitionCleanRequestedToInflight(clean, Option.empty());
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(clean));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(inflight));
        clean = this.timeline.transitionCleanInflightToComplete(true, inflight, Option.empty());
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(clean));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(inflight));
        HoodieInstant srcInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "restore", "5");
        HoodieInstant otherInstant = HoodieTimeline.getRequestedInstant((HoodieInstant)srcInstant);
        org.junit.jupiter.api.Assertions.assertEquals((Object)otherInstant, (Object)new HoodieInstant(HoodieInstant.State.REQUESTED, "restore", "5"));
        otherInstant = HoodieTimeline.getCleanRequestedInstant((String)"5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)otherInstant, (Object)new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", "5"));
        otherInstant = HoodieTimeline.getCleanInflightInstant((String)"5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)otherInstant, (Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "clean", "5"));
        otherInstant = HoodieTimeline.getCompactionRequestedInstant((String)"5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)otherInstant, (Object)new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", "5"));
        otherInstant = HoodieTimeline.getCompactionInflightInstant((String)"5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)otherInstant, (Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "compaction", "5"));
        List<HoodieInstant> allInstants = this.getAllInstants();
        this.timeline = new HoodieActiveTimeline(this.metaClient, true);
        this.timeline.setInstants(allInstants);
        this.timeline.setInstants(allInstants);
        this.timeline.createNewInstant(new HoodieInstant(HoodieInstant.State.REQUESTED, "commit", "2"));
        allInstants.stream().map(HoodieInstant::getTimestamp).forEach(s -> org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsOrBeforeTimelineStarts(s)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsOrBeforeTimelineStarts("0"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsOrBeforeTimelineStarts(String.valueOf(System.currentTimeMillis() + 1000L)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.getTimelineHash().isEmpty());
    }

    @Test
    public void testCreateInstants() {
        List<HoodieInstant> allInstants = this.getAllInstants();
        for (HoodieInstant instant : allInstants) {
            if (instant.isCompleted()) {
                this.timeline.createCompleteInstant(instant);
                continue;
            }
            this.timeline.createNewInstant(instant);
        }
        this.timeline = this.timeline.reload();
        for (HoodieInstant instant : allInstants) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(instant));
        }
    }

    @Test
    public void testInstantFilenameOperations() {
        HoodieInstant instantRequested = new HoodieInstant(HoodieInstant.State.REQUESTED, "restore", "5");
        HoodieInstant instantInflight = new HoodieInstant(HoodieInstant.State.INFLIGHT, "restore", "5");
        HoodieInstant instantComplete = new HoodieInstant(HoodieInstant.State.COMPLETED, "restore", "5", "6");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTimeline.getCommitFromCommitFile((String)instantRequested.getFileName()), (Object)"5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTimeline.getCommitFromCommitFile((String)instantInflight.getFileName()), (Object)"5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTimeline.getCommitFromCommitFile((String)instantComplete.getFileName()), (Object)"5_6");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTimeline.makeInflightRestoreFileName((String)HoodieInstant.extractTimestamp((String)instantComplete.getFileName())), (Object)instantInflight.getFileName());
    }

    @Test
    public void testFiltering() {
        List<HoodieInstant> allInstants = this.getAllInstants();
        Supplier<Stream> sup = allInstants::stream;
        this.timeline = new HoodieActiveTimeline(this.metaClient);
        this.timeline.setInstants(allInstants);
        Stream instants = this.timeline.getReverseOrderedInstants();
        List v1 = instants.collect(Collectors.toList());
        List v2 = sup.get().collect(Collectors.toList());
        Collections.reverse(v2);
        org.junit.jupiter.api.Assertions.assertEquals(v1, v2);
        BiConsumer<HoodieTimeline, Set> checkFilter = (timeline, states) -> {
            ((Stream)sup.get()).filter(i -> states.contains(i.getState())).forEach(i -> org.junit.jupiter.api.Assertions.assertTrue((boolean)timeline.containsInstant(i)));
            ((Stream)sup.get()).filter(i -> !states.contains(i.getState())).forEach(i -> org.junit.jupiter.api.Assertions.assertFalse((boolean)timeline.containsInstant(i)));
        };
        checkFilter.accept(this.timeline.filter(i -> false), new HashSet());
        checkFilter.accept(this.timeline.filterInflights(), Collections.singleton(HoodieInstant.State.INFLIGHT));
        checkFilter.accept(this.timeline.filterInflightsAndRequested(), CollectionUtils.createSet((Object[])new HoodieInstant.State[]{HoodieInstant.State.INFLIGHT, HoodieInstant.State.REQUESTED}));
        HoodieTimeline t1 = this.timeline.filterCompletedAndCompactionInstants();
        Set states2 = CollectionUtils.createSet((Object[])new HoodieInstant.State[]{HoodieInstant.State.COMPLETED});
        Set<String> actions = Collections.singleton("compaction");
        sup.get().filter(i -> states2.contains(i.getState()) || actions.contains(i.getAction())).forEach(i -> org.junit.jupiter.api.Assertions.assertTrue((boolean)t1.containsInstant(i)));
        sup.get().filter(i -> !states2.contains(i.getState()) && !actions.contains(i.getAction())).forEach(i -> org.junit.jupiter.api.Assertions.assertFalse((boolean)t1.containsInstant(i)));
        HoodieTimeline t2 = this.timeline.filterPendingCompactionTimeline();
        sup.get().filter(i -> i.getAction().equals("compaction")).forEach(i -> org.junit.jupiter.api.Assertions.assertTrue((boolean)t2.containsInstant(i)));
        sup.get().filter(i -> !i.getAction().equals("compaction")).forEach(i -> org.junit.jupiter.api.Assertions.assertFalse((boolean)t2.containsInstant(i)));
    }

    @Test
    public void testReplaceActionsTimeline() {
        int instantTime = 1;
        ArrayList<HoodieInstant> allInstants = new ArrayList<HoodieInstant>();
        HoodieInstant instant1 = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", String.format("%03d", instantTime++));
        allInstants.add(instant1);
        HoodieInstant instant2 = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", String.format("%03d", instantTime++));
        allInstants.add(instant2);
        HoodieInstant instant3 = new HoodieInstant(HoodieInstant.State.COMPLETED, "replacecommit", String.format("%03d", instantTime++));
        allInstants.add(instant3);
        this.timeline = new HoodieActiveTimeline(this.metaClient);
        this.timeline.setInstants(allInstants);
        List validReplaceInstants = this.timeline.getCompletedReplaceTimeline().getInstants();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)validReplaceInstants.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)instant3.getTimestamp(), (Object)((HoodieInstant)validReplaceInstants.get(0)).getTimestamp());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"replacecommit", (Object)((HoodieInstant)validReplaceInstants.get(0)).getAction());
        Assertions.assertStreamEquals(Stream.of(instant1, instant2, instant3), (Stream)this.timeline.getCommitAndReplaceTimeline().getInstantsAsStream(), (String)"Check the instants stream");
        Assertions.assertStreamEquals(Stream.of(instant1, instant2), (Stream)this.timeline.getCommitTimeline().getInstantsAsStream(), (String)"Check the instants stream");
    }

    @Test
    public void testCreateNewInstantTime() throws Exception {
        String lastInstantTime = this.metaClient.createNewInstantTime(false);
        for (int i = 0; i < 3; ++i) {
            String newInstantTime = this.metaClient.createNewInstantTime(false);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTimeline.compareTimestamps((String)lastInstantTime, (BiPredicate)HoodieTimeline.LESSER_THAN, (String)newInstantTime));
            lastInstantTime = newInstantTime;
        }
        int numChecks = 100000;
        int numThreads = 100;
        long milliSecondsInYear = 1471228928L;
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        ArrayList futures = new ArrayList(100);
        for (int idx = 0; idx < 100; ++idx) {
            futures.add(executorService.submit(() -> {
                Date date = new Date(System.currentTimeMillis() + (long)((int)(Math.random() * 100.0)) * 1471228928L);
                String expectedFormat = HoodieActiveTimeline.formatDate((Date)date);
                for (int tidx = 0; tidx < 100000; ++tidx) {
                    String curFormat = HoodieActiveTimeline.formatDate((Date)date);
                    if (curFormat.equals(expectedFormat)) continue;
                    throw new HoodieException("Format error: expected=" + expectedFormat + ", curFormat=" + curFormat);
                }
            }));
        }
        executorService.shutdown();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)executorService.awaitTermination(60L, TimeUnit.SECONDS));
        for (Future future : futures) {
            future.get();
        }
    }

    @Test
    public void testParseDateFromInstantTime() throws ParseException {
        String secondGranularityInstant = "20210101120101123";
        Date defaultSecsGranularityDate = HoodieActiveTimeline.parseDateFromInstantTime((String)secondGranularityInstant);
        System.out.println(defaultSecsGranularityDate.getTime());
    }

    @Test
    public void testMetadataCompactionInstantDateParsing() throws ParseException {
        String secondGranularityInstant = "20210101120101123";
        Date defaultSecsGranularityDate = HoodieActiveTimeline.parseDateFromInstantTime((String)secondGranularityInstant);
        String compactionInstant = secondGranularityInstant + "001";
        Date defaultMsGranularityDate = HoodieActiveTimeline.parseDateFromInstantTime((String)compactionInstant);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)(defaultMsGranularityDate.getTime() - defaultSecsGranularityDate.getTime()), (String)"Expected the ms part to be 0");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTimeline.compareTimestamps((String)secondGranularityInstant, (BiPredicate)HoodieTimeline.LESSER_THAN, (String)compactionInstant));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTimeline.compareTimestamps((String)compactionInstant, (BiPredicate)HoodieTimeline.GREATER_THAN, (String)secondGranularityInstant));
    }

    @Test
    public void testMillisGranularityInstantDateParsing() throws ParseException {
        String secondGranularityInstant = "20210101120101";
        Date defaultMsGranularityDate = HoodieActiveTimeline.parseDateFromInstantTime((String)secondGranularityInstant);
        String specificMsGranularityInstant = secondGranularityInstant + "009";
        Date msGranularityDate = HoodieActiveTimeline.parseDateFromInstantTime((String)specificMsGranularityInstant);
        org.junit.jupiter.api.Assertions.assertEquals((long)999L, (long)(defaultMsGranularityDate.getTime() % 1000L), (String)"Expected the ms part to be 999");
        org.junit.jupiter.api.Assertions.assertEquals((long)9L, (long)(msGranularityDate.getTime() % 1000L), (String)"Expected the ms part to be 9");
        String laterDateInstant = "20210101120111";
        org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)(HoodieActiveTimeline.parseDateFromInstantTime((String)laterDateInstant).getTime() / 1000L - HoodieActiveTimeline.parseDateFromInstantTime((String)secondGranularityInstant).getTime() / 1000L), (String)"Expected the difference between later instant and previous instant to be 10 seconds");
    }

    @Test
    public void testInvalidInstantDateParsing() throws ParseException {
        org.junit.jupiter.api.Assertions.assertEquals((long)Long.parseLong("00000000000000"), (long)((Date)HoodieActiveTimeline.parseDateFromInstantTimeSafely((String)"00000000000000").get()).getTime());
        org.junit.jupiter.api.Assertions.assertEquals((long)Long.parseLong("00000000000001"), (long)((Date)HoodieActiveTimeline.parseDateFromInstantTimeSafely((String)"00000000000001").get()).getTime());
        org.junit.jupiter.api.Assertions.assertEquals((long)Long.parseLong("00000000000002"), (long)((Date)HoodieActiveTimeline.parseDateFromInstantTimeSafely((String)"00000000000002").get()).getTime());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Option.empty(), (Object)HoodieActiveTimeline.parseDateFromInstantTimeSafely((String)"00000000000000001"));
        String testInstant = "20210101120101";
        org.junit.jupiter.api.Assertions.assertEquals((long)HoodieActiveTimeline.parseDateFromInstantTime((String)testInstant).getTime(), (long)((Date)HoodieActiveTimeline.parseDateFromInstantTimeSafely((String)testInstant).get()).getTime());
    }

    @Test
    public void testInstantCompletionTimeBackwardCompatibility() {
        HoodieInstant requestedInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "commit", "1");
        HoodieInstant inflightInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", "2");
        HoodieInstant completeInstant = new HoodieInstant(false, "commit", "3");
        this.timeline = new HoodieActiveTimeline(this.metaClient);
        this.timeline.createNewInstant(requestedInstant);
        this.timeline.createNewInstant(inflightInstant);
        String legacyCompletedFileName = HoodieTimeline.makeCommitFileName((String)completeInstant.getTimestamp());
        this.metaClient.getStorage().createImmutableFileInPath(new StoragePath(this.metaClient.getMetaPath().toString(), legacyCompletedFileName), Option.empty());
        this.timeline = this.timeline.reload();
        MatcherAssert.assertThat((String)"Some instants might be missing", (Object)this.timeline.countInstants(), (Matcher)CoreMatchers.is((Object)3));
        List instants = this.timeline.getInstants();
        org.junit.jupiter.api.Assertions.assertNull((Object)((HoodieInstant)instants.get(0)).getCompletionTime(), (String)"Requested instant does not have completion time");
        org.junit.jupiter.api.Assertions.assertNull((Object)((HoodieInstant)instants.get(1)).getCompletionTime(), (String)"Inflight instant does not have completion time");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)((HoodieInstant)instants.get(2)).getCompletionTime(), (String)"Completed instant has modification time as completion time for 0.x release");
    }

    private List<HoodieInstant> getAllInstants() {
        this.timeline = new HoodieActiveTimeline(this.metaClient);
        ArrayList<HoodieInstant> allInstants = new ArrayList<HoodieInstant>();
        long instantTime = 1L;
        for (HoodieInstant.State state : HoodieInstant.State.values()) {
            if (state == HoodieInstant.State.NIL) continue;
            for (String action : HoodieTimeline.VALID_ACTIONS_IN_TIMELINE) {
                if (state == HoodieInstant.State.REQUESTED && (action.equals("savepoint") || action.equals("restore") || action.equals("rollback")) || state == HoodieInstant.State.INFLIGHT && action.equals("rollback") || state == HoodieInstant.State.COMPLETED && action.equals("rollback")) continue;
                if (state == HoodieInstant.State.COMPLETED && action.equals("compaction")) {
                    action = "commit";
                }
                allInstants.add(new HoodieInstant(state, action, String.format("%03d", instantTime++)));
            }
        }
        return allInstants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shouldAllowTempCommit(boolean allowTempCommit, Consumer<HoodieTableMetaClient> fun) {
        if (allowTempCommit) {
            HoodieStorage storage = this.metaClient.getStorage();
            FileSystem fs = (FileSystem)storage.getFileSystem();
            HoodieWrapperFileSystem newFs = new HoodieWrapperFileSystem(fs, (ConsistencyGuard)new NoOpConsistencyGuard());
            this.metaClient.setHoodieStorage((HoodieStorage)new HoodieHadoopStorage((FileSystem)newFs));
            try {
                fun.accept(this.metaClient);
            }
            finally {
                this.metaClient.setHoodieStorage(storage);
            }
            return;
        }
        fun.accept(this.metaClient);
    }
}

