/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.reader.DataGenerationPlan;
import org.apache.hudi.common.testutils.reader.HoodieAvroRecordTestMerger;
import org.apache.hudi.common.testutils.reader.HoodieFileGroupReaderTestHarness;
import org.apache.hudi.common.testutils.reader.HoodieFileSliceTestUtils;
import org.apache.hudi.common.testutils.reader.HoodieRecordTestPayload;
import org.apache.hudi.common.testutils.reader.HoodieTestReaderContext;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestEventTimeMerging
extends HoodieFileGroupReaderTestHarness {
    @BeforeAll
    public static void setUp() throws IOException {
        HoodieAvroRecordTestMerger merger = new HoodieAvroRecordTestMerger();
        readerContext = new HoodieTestReaderContext(Option.of((Object)merger), Option.of((Object)HoodieRecordTestPayload.class.getName()));
        properties.setProperty(HoodieCommonConfig.RECORD_MERGE_MODE.key(), RecordMergeMode.EVENT_TIME_ORDERING.name());
        keyRanges = Arrays.asList(new HoodieFileSliceTestUtils.KeyRange(1, 10), new HoodieFileSliceTestUtils.KeyRange(1, 5), new HoodieFileSliceTestUtils.KeyRange(1, 3), new HoodieFileSliceTestUtils.KeyRange(6, 8), new HoodieFileSliceTestUtils.KeyRange(1, 2));
        timestamps = Arrays.asList(2L, 3L, 1L, 1L, 4L);
        operationTypes = Arrays.asList(DataGenerationPlan.OperationType.INSERT, DataGenerationPlan.OperationType.DELETE, DataGenerationPlan.OperationType.UPDATE, DataGenerationPlan.OperationType.DELETE, DataGenerationPlan.OperationType.UPDATE);
        instantTimes = Arrays.asList("001", "002", "003", "004", "005");
        shouldWritePositions = Arrays.asList(false, false, false, false, false);
    }

    @BeforeEach
    public void initialize() throws Exception {
        this.setTableName(TestEventTimeMerging.class.getName());
        this.initPath(this.tableName);
        this.initMetaClient();
        this.initTestDataGenerator(new String[]{"any-partition-path"});
        testTable = HoodieTestTable.of(this.metaClient);
        this.setUpMockCommits();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testWithOneLogFile(boolean useRecordPositions) throws IOException, InterruptedException {
        shouldWritePositions = Arrays.asList(useRecordPositions, useRecordPositions);
        ClosableIterator<IndexedRecord> iterator = this.getFileGroupIterator(2, useRecordPositions);
        List<String> leftKeysExpected = Arrays.asList("6", "7", "8", "9", "10");
        List<Long> leftTimestampsExpected = Arrays.asList(2L, 2L, 2L, 2L, 2L);
        ArrayList<String> leftKeysActual = new ArrayList<String>();
        ArrayList<Long> leftTimestampsActual = new ArrayList<Long>();
        while (iterator.hasNext()) {
            IndexedRecord record = (IndexedRecord)iterator.next();
            leftKeysActual.add(record.get(HoodieTestDataGenerator.AVRO_SCHEMA.getField("_row_key").pos()).toString());
            leftTimestampsActual.add((Long)record.get(HoodieTestDataGenerator.AVRO_SCHEMA.getField("timestamp").pos()));
        }
        Assertions.assertEquals(leftKeysExpected, leftKeysActual);
        Assertions.assertEquals(leftTimestampsExpected, leftTimestampsActual);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testWithTwoLogFiles(boolean useRecordPositions) throws IOException, InterruptedException {
        shouldWritePositions = Arrays.asList(useRecordPositions, useRecordPositions, useRecordPositions);
        ClosableIterator<IndexedRecord> iterator = this.getFileGroupIterator(3, useRecordPositions);
        List<String> leftKeysExpected = Arrays.asList("6", "7", "8", "9", "10");
        List<Long> leftTimestampsExpected = Arrays.asList(2L, 2L, 2L, 2L, 2L);
        ArrayList<String> leftKeysActual = new ArrayList<String>();
        ArrayList<Long> leftTimestampsActual = new ArrayList<Long>();
        while (iterator.hasNext()) {
            IndexedRecord record = (IndexedRecord)iterator.next();
            leftKeysActual.add(record.get(HoodieTestDataGenerator.AVRO_SCHEMA.getField("_row_key").pos()).toString());
            leftTimestampsActual.add((Long)record.get(HoodieTestDataGenerator.AVRO_SCHEMA.getField("timestamp").pos()));
        }
        Assertions.assertEquals(leftKeysExpected, leftKeysActual);
        Assertions.assertEquals(leftTimestampsExpected, leftTimestampsActual);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testWithThreeLogFiles(boolean useRecordPositions) throws IOException, InterruptedException {
        shouldWritePositions = Arrays.asList(useRecordPositions, useRecordPositions, useRecordPositions, useRecordPositions);
        ClosableIterator<IndexedRecord> iterator = this.getFileGroupIterator(4, useRecordPositions);
        List<String> leftKeysExpected = Arrays.asList("6", "7", "8", "9", "10");
        List<Long> leftTimestampsExpected = Arrays.asList(2L, 2L, 2L, 2L, 2L);
        ArrayList<String> leftKeysActual = new ArrayList<String>();
        ArrayList<Long> leftTimestampsActual = new ArrayList<Long>();
        while (iterator.hasNext()) {
            IndexedRecord record = (IndexedRecord)iterator.next();
            leftKeysActual.add(record.get(HoodieTestDataGenerator.AVRO_SCHEMA.getField("_row_key").pos()).toString());
            leftTimestampsActual.add((Long)record.get(HoodieTestDataGenerator.AVRO_SCHEMA.getField("timestamp").pos()));
        }
        Assertions.assertEquals(leftKeysExpected, leftKeysActual);
        Assertions.assertEquals(leftTimestampsExpected, leftTimestampsActual);
    }

    @Test
    public void testWithFourLogFiles() throws IOException, InterruptedException {
        ClosableIterator<IndexedRecord> iterator = this.getFileGroupIterator(5);
        List<String> leftKeysExpected = Arrays.asList("1", "2", "6", "7", "8", "9", "10");
        List<Long> leftTimestampsExpected = Arrays.asList(4L, 4L, 2L, 2L, 2L, 2L, 2L);
        ArrayList<String> leftKeysActual = new ArrayList<String>();
        ArrayList<Long> leftTimestampsActual = new ArrayList<Long>();
        while (iterator.hasNext()) {
            IndexedRecord record = (IndexedRecord)iterator.next();
            leftKeysActual.add(record.get(HoodieTestDataGenerator.AVRO_SCHEMA.getField("_row_key").pos()).toString());
            leftTimestampsActual.add((Long)record.get(HoodieTestDataGenerator.AVRO_SCHEMA.getField("timestamp").pos()));
        }
        Assertions.assertEquals(leftKeysExpected, leftKeysActual);
        Assertions.assertEquals(leftTimestampsExpected, leftTimestampsActual);
    }

    @ParameterizedTest
    @MethodSource(value={"testArgs"})
    public void testPositionMergeFallback(boolean log1haspositions, boolean log2haspositions, boolean log3haspositions, boolean log4haspositions) throws IOException, InterruptedException {
        shouldWritePositions = Arrays.asList(true, log1haspositions, log2haspositions, log3haspositions, log4haspositions);
        ClosableIterator<IndexedRecord> iterator = this.getFileGroupIterator(5, true);
        List<String> leftKeysExpected = Arrays.asList("1", "2", "6", "7", "8", "9", "10");
        List<Long> leftTimestampsExpected = Arrays.asList(4L, 4L, 2L, 2L, 2L, 2L, 2L);
        ArrayList<String> leftKeysActual = new ArrayList<String>();
        ArrayList<Long> leftTimestampsActual = new ArrayList<Long>();
        while (iterator.hasNext()) {
            IndexedRecord record = (IndexedRecord)iterator.next();
            leftKeysActual.add(record.get(HoodieTestDataGenerator.AVRO_SCHEMA.getField("_row_key").pos()).toString());
            leftTimestampsActual.add((Long)record.get(HoodieTestDataGenerator.AVRO_SCHEMA.getField("timestamp").pos()));
        }
        Assertions.assertEquals(leftKeysExpected, leftKeysActual);
        Assertions.assertEquals(leftTimestampsExpected, leftTimestampsActual);
    }

    private static Stream<Arguments> testArgs() {
        Stream.Builder<Arguments> b = Stream.builder();
        for (int i = 0; i < 16; ++i) {
            b.add(Arguments.of((Object[])new Object[]{i % 2 == 0, i / 2 % 2 == 0, i / 4 % 2 == 0, i / 8 % 2 == 0}));
        }
        return b.build();
    }
}

