/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.model.RecordPayloadType;
import org.apache.hudi.common.model.debezium.PostgresDebeziumAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestHoodieTableMetaClient
extends HoodieCommonTestHarness {
    @BeforeEach
    public void init() throws IOException {
        this.initMetaClient();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanMetaClient();
    }

    @Test
    public void checkMetadata() {
        Assertions.assertEquals((Object)"raw_trips", (Object)this.metaClient.getTableConfig().getTableName(), (String)"Table name should be raw_trips");
        Assertions.assertEquals((Object)this.basePath, (Object)this.metaClient.getBasePath().toString(), (String)"Basepath should be the one assigned");
        Assertions.assertEquals((Object)(this.basePath + "/.hoodie"), (Object)this.metaClient.getMetaPath().toString(), (String)"Metapath should be ${basepath}/.hoodie");
        Assertions.assertTrue((boolean)this.metaClient.getTableConfig().getProps().containsKey((Object)HoodieTableConfig.TABLE_CHECKSUM.key()));
        Assertions.assertTrue((boolean)HoodieTableConfig.validateChecksum((Properties)this.metaClient.getTableConfig().getProps()));
        Assertions.assertEquals((Object)HoodieTableVersion.current(), (Object)this.metaClient.getTableConfig().getTableInitialVersion());
    }

    @Test
    public void checkSerDe() {
        HoodieTableMetaClient deserializedMetaClient = (HoodieTableMetaClient)HoodieTestUtils.serializeDeserialize((Serializable)this.metaClient, HoodieTableMetaClient.class);
        Assertions.assertNotNull((Object)deserializedMetaClient);
        HoodieActiveTimeline commitTimeline = deserializedMetaClient.getActiveTimeline();
        HoodieInstant instant = new HoodieInstant(true, "commit", "1");
        commitTimeline.createNewInstant(instant);
        commitTimeline.saveAsComplete(instant, Option.of((Object)StringUtils.getUTF8Bytes((String)"test-detail")));
        commitTimeline = commitTimeline.reload();
        HoodieInstant completedInstant = (HoodieInstant)commitTimeline.getInstantsAsStream().findFirst().get();
        Assertions.assertTrue((boolean)completedInstant.isCompleted());
        Assertions.assertEquals((Object)completedInstant.getTimestamp(), (Object)instant.getTimestamp());
        Assertions.assertArrayEquals((byte[])StringUtils.getUTF8Bytes((String)"test-detail"), (byte[])((byte[])commitTimeline.getInstantDetails(completedInstant).get()), (String)"Commit value should be \"test-detail\"");
    }

    @Test
    public void checkCommitTimeline() {
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        HoodieTimeline activeCommitTimeline = activeTimeline.getCommitAndReplaceTimeline();
        Assertions.assertTrue((boolean)activeCommitTimeline.empty(), (String)"Should be empty commit timeline");
        HoodieInstant instant = new HoodieInstant(true, "commit", "1");
        activeTimeline.createNewInstant(instant);
        activeTimeline.saveAsComplete(instant, Option.of((Object)StringUtils.getUTF8Bytes((String)"test-detail")));
        activeTimeline = this.metaClient.getActiveTimeline();
        activeCommitTimeline = activeTimeline.getCommitAndReplaceTimeline();
        Assertions.assertTrue((boolean)activeCommitTimeline.empty(), (String)"Should be empty commit timeline");
        activeTimeline = activeTimeline.reload();
        HoodieInstant completedInstant = (HoodieInstant)activeTimeline.getCommitsTimeline().getInstantsAsStream().findFirst().get();
        activeCommitTimeline = activeTimeline.getCommitAndReplaceTimeline();
        Assertions.assertFalse((boolean)activeCommitTimeline.empty(), (String)"Should be the 1 commit we made");
        Assertions.assertTrue((boolean)completedInstant.isCompleted());
        Assertions.assertTrue((boolean)completedInstant.getTimestamp().equals(instant.getTimestamp()));
        Assertions.assertArrayEquals((byte[])StringUtils.getUTF8Bytes((String)"test-detail"), (byte[])((byte[])activeCommitTimeline.getInstantDetails(completedInstant).get()), (String)"Commit value should be \"test-detail\"");
    }

    private static Stream<Arguments> argumentsForInferringRecordMergeMode() {
        Stream<Arguments> arguments = Stream.of(Arguments.arguments((Object[])new Object[]{Option.of((Object)OverwriteWithLatestAvroPayload.class.getName()), Option.empty(), Option.empty(), RecordMergeMode.OVERWRITE_WITH_LATEST}), Arguments.arguments((Object[])new Object[]{Option.of((Object)DefaultHoodieRecordPayload.class.getName()), Option.empty(), Option.empty(), RecordMergeMode.EVENT_TIME_ORDERING}), Arguments.arguments((Object[])new Object[]{Option.of((Object)PostgresDebeziumAvroPayload.class.getName()), Option.empty(), Option.empty(), RecordMergeMode.CUSTOM}), Arguments.arguments((Object[])new Object[]{Option.of((Object)OverwriteWithLatestAvroPayload.class.getName()), Option.of((Object)RecordPayloadType.OVERWRITE_LATEST_AVRO.name()), Option.empty(), RecordMergeMode.OVERWRITE_WITH_LATEST}), Arguments.arguments((Object[])new Object[]{Option.of((Object)DefaultHoodieRecordPayload.class.getName()), Option.of((Object)RecordPayloadType.OVERWRITE_LATEST_AVRO.name()), Option.empty(), RecordMergeMode.EVENT_TIME_ORDERING}), Arguments.arguments((Object[])new Object[]{Option.of((Object)PostgresDebeziumAvroPayload.class.getName()), Option.of((Object)RecordPayloadType.OVERWRITE_LATEST_AVRO.name()), Option.empty(), RecordMergeMode.CUSTOM}), Arguments.arguments((Object[])new Object[]{Option.of((Object)OverwriteWithLatestAvroPayload.class.getName()), Option.empty(), Option.of((Object)"eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"), RecordMergeMode.OVERWRITE_WITH_LATEST}), Arguments.arguments((Object[])new Object[]{Option.of((Object)DefaultHoodieRecordPayload.class.getName()), Option.empty(), Option.of((Object)"eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"), RecordMergeMode.EVENT_TIME_ORDERING}), Arguments.arguments((Object[])new Object[]{Option.of((Object)PostgresDebeziumAvroPayload.class.getName()), Option.empty(), Option.of((Object)"eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"), RecordMergeMode.CUSTOM}), Arguments.arguments((Object[])new Object[]{Option.empty(), Option.of((Object)RecordPayloadType.OVERWRITE_LATEST_AVRO.name()), Option.of((Object)"eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"), RecordMergeMode.OVERWRITE_WITH_LATEST}), Arguments.arguments((Object[])new Object[]{Option.empty(), Option.of((Object)RecordPayloadType.HOODIE_AVRO_DEFAULT.name()), Option.of((Object)"eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"), RecordMergeMode.EVENT_TIME_ORDERING}), Arguments.arguments((Object[])new Object[]{Option.empty(), Option.of((Object)RecordPayloadType.HOODIE_METADATA.name()), Option.of((Object)"eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"), RecordMergeMode.CUSTOM}), Arguments.arguments((Object[])new Object[]{Option.empty(), Option.empty(), Option.of((Object)"eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"), RecordMergeMode.valueOf((String)((String)HoodieTableConfig.RECORD_MERGE_MODE.defaultValue()))}), Arguments.arguments((Object[])new Object[]{Option.empty(), Option.empty(), Option.of((Object)"custom_merge_strategy"), RecordMergeMode.CUSTOM}), Arguments.arguments((Object[])new Object[]{Option.of((Object)DefaultHoodieRecordPayload.class.getName()), Option.of((Object)RecordPayloadType.OVERWRITE_LATEST_AVRO.name()), Option.of((Object)"custom_merge_strategy"), RecordMergeMode.CUSTOM}));
        return arguments;
    }

    @ParameterizedTest
    @MethodSource(value={"argumentsForInferringRecordMergeMode"})
    public void testInferRecordMergeMode(Option<String> payloadClassName, Option<String> payloadType, Option<String> recordMergerStrategy, RecordMergeMode expectedRecordMergeMode) {
        HoodieTableMetaClient.PropertyBuilder builder = HoodieTableMetaClient.withPropertyBuilder().setTableType(HoodieTableType.MERGE_ON_READ.name()).setTableName("table_name");
        if (payloadClassName.isPresent()) {
            builder.setPayloadClassName((String)payloadClassName.get());
        }
        if (payloadType.isPresent()) {
            builder.setPayloadType((String)payloadType.get());
        }
        if (recordMergerStrategy.isPresent()) {
            builder.setRecordMergerStrategy((String)recordMergerStrategy.get());
        }
        Assertions.assertEquals((Object)expectedRecordMergeMode, (Object)RecordMergeMode.valueOf((String)builder.build().getProperty(HoodieTableConfig.RECORD_MERGE_MODE.key())));
    }

    private static Stream<Arguments> argumentsForValidationFailureOnMergeConfigs() {
        Stream<Arguments> arguments = Stream.of(Arguments.arguments((Object[])new Object[]{Option.of((Object)DefaultHoodieRecordPayload.class.getName()), Option.empty(), Option.of((Object)"eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"), RecordMergeMode.OVERWRITE_WITH_LATEST, "Payload class name (org.apache.hudi.common.model.DefaultHoodieRecordPayload) or type (null) should be consistent with the record merge mode OVERWRITE_WITH_LATEST"}), Arguments.arguments((Object[])new Object[]{Option.empty(), Option.of((Object)RecordPayloadType.HOODIE_AVRO_DEFAULT.name()), Option.of((Object)"eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"), RecordMergeMode.OVERWRITE_WITH_LATEST, "Payload class name (null) or type (HOODIE_AVRO_DEFAULT) should be consistent with the record merge mode OVERWRITE_WITH_LATEST"}), Arguments.arguments((Object[])new Object[]{Option.of((Object)OverwriteWithLatestAvroPayload.class.getName()), Option.empty(), Option.of((Object)"eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"), RecordMergeMode.EVENT_TIME_ORDERING, "Payload class name (org.apache.hudi.common.model.OverwriteWithLatestAvroPayload) or type (null) should be consistent with the record merge mode EVENT_TIME_ORDERING"}), Arguments.arguments((Object[])new Object[]{Option.empty(), Option.of((Object)RecordPayloadType.OVERWRITE_LATEST_AVRO.name()), Option.of((Object)"eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"), RecordMergeMode.EVENT_TIME_ORDERING, "Payload class name (null) or type (OVERWRITE_LATEST_AVRO) should be consistent with the record merge mode EVENT_TIME_ORDERING"}));
        return arguments;
    }

    @ParameterizedTest
    @MethodSource(value={"argumentsForValidationFailureOnMergeConfigs"})
    public void testValidationFailureOnMergeConfigs(Option<String> payloadClassName, Option<String> payloadType, Option<String> recordMergerStrategy, RecordMergeMode recordMergeMode, String expectedErrorMessage) {
        HoodieTableMetaClient.PropertyBuilder builder = HoodieTableMetaClient.withPropertyBuilder().setTableType(HoodieTableType.MERGE_ON_READ.name()).setTableName("table_name").setRecordMergeMode(recordMergeMode);
        if (payloadClassName.isPresent()) {
            builder.setPayloadClassName((String)payloadClassName.get());
        }
        if (payloadType.isPresent()) {
            builder.setPayloadType((String)payloadType.get());
        }
        if (recordMergerStrategy.isPresent()) {
            builder.setRecordMergerStrategy((String)recordMergerStrategy.get());
        }
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((HoodieTableMetaClient.PropertyBuilder)builder).build());
        Assertions.assertEquals((Object)expectedErrorMessage, (Object)exception.getMessage());
    }

    @Test
    public void testEquals() throws IOException {
        HoodieTableMetaClient metaClient1 = HoodieTestUtils.init((String)this.tempDir.toAbsolutePath().toString(), (HoodieTableType)this.getTableType());
        HoodieTableMetaClient metaClient2 = HoodieTestUtils.init((String)this.tempDir.toAbsolutePath().toString(), (HoodieTableType)this.getTableType());
        Assertions.assertEquals((Object)metaClient1, (Object)metaClient1);
        Assertions.assertEquals((Object)metaClient1, (Object)metaClient2);
        Assertions.assertNotEquals((Object)metaClient1, null);
        Assertions.assertNotEquals((Object)metaClient1, (Object)new Object());
    }

    @Test
    public void testToString() throws IOException {
        HoodieTableMetaClient metaClient1 = HoodieTestUtils.init((String)this.tempDir.toAbsolutePath().toString(), (HoodieTableType)this.getTableType());
        HoodieTableMetaClient metaClient2 = HoodieTestUtils.init((String)this.tempDir.toAbsolutePath().toString(), (HoodieTableType)this.getTableType());
        Assertions.assertEquals((Object)metaClient1.toString(), (Object)metaClient2.toString());
        Assertions.assertNotEquals((Object)metaClient1.toString(), (Object)new Object().toString());
    }
}

