/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.timeline.CompletionTimeQueryView;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.MockHoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.storage.StoragePath;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestHoodieFileGroup {
    @Test
    public void testCommittedFileSlices() {
        Stream<String> completed = Stream.of("001");
        Stream<String> inflight = Stream.of("002");
        MockHoodieTimeline activeTimeline = new MockHoodieTimeline(completed, inflight);
        HoodieFileGroup fileGroup = new HoodieFileGroup("", "data", activeTimeline.getCommitsTimeline().filterCompletedInstants());
        for (int i = 0; i < 3; ++i) {
            HoodieBaseFile baseFile = new HoodieBaseFile("data_1_00" + i);
            fileGroup.addBaseFile(baseFile);
        }
        Assertions.assertEquals((long)2L, (long)fileGroup.getAllFileSlices().count());
        Assertions.assertFalse((boolean)fileGroup.getAllFileSlices().anyMatch(s -> s.getBaseInstantTime().equals("002")));
        Assertions.assertEquals((long)3L, (long)fileGroup.getAllFileSlicesIncludingInflight().count());
        Assertions.assertEquals((Object)"001", (Object)((FileSlice)fileGroup.getLatestFileSlice().get()).getBaseInstantTime());
        Assertions.assertEquals((Object)"001", (Object)((FileSlice)new HoodieFileGroup(fileGroup).getLatestFileSlice().get()).getBaseInstantTime());
    }

    @Test
    public void testCommittedFileSlicesWithSavepointAndHoles() {
        MockHoodieTimeline activeTimeline = new MockHoodieTimeline(Stream.of(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "01"), new HoodieInstant(HoodieInstant.State.COMPLETED, "savepoint", "01"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "03"), new HoodieInstant(HoodieInstant.State.COMPLETED, "savepoint", "03"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "05")).collect(Collectors.toList()));
        HoodieFileGroup fileGroup = new HoodieFileGroup("", "data", activeTimeline.filterCompletedAndCompactionInstants());
        for (int i = 0; i < 7; ++i) {
            HoodieBaseFile baseFile = new HoodieBaseFile("data_1_0" + i);
            fileGroup.addBaseFile(baseFile);
        }
        List allFileSlices = fileGroup.getAllFileSlices().collect(Collectors.toList());
        Assertions.assertEquals((int)6, (int)allFileSlices.size());
        Assertions.assertFalse((boolean)allFileSlices.stream().anyMatch(s -> s.getBaseInstantTime().equals("06")));
        Assertions.assertEquals((long)7L, (long)fileGroup.getAllFileSlicesIncludingInflight().count());
        Assertions.assertEquals((Object)"05", (Object)((FileSlice)fileGroup.getLatestFileSlice().get()).getBaseInstantTime());
    }

    @Test
    public void testGetBaseInstantTime() {
        MockHoodieTimeline activeTimeline = new MockHoodieTimeline(Stream.of(new HoodieInstant(HoodieInstant.State.INFLIGHT, "deltacommit", "001", "001"), new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "002", "011"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "003", "007"), new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "004", "006"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "005", "007")).collect(Collectors.toList()));
        CompletionTimeQueryView queryView = this.getMockCompletionTimeQueryView(activeTimeline);
        HoodieFileGroup fileGroup = new HoodieFileGroup("", "data", activeTimeline.filterCompletedAndCompactionInstants());
        HoodieLogFile logFile1 = new HoodieLogFile(new StoragePath(TestHoodieFileGroup.getLogFileName("001")));
        fileGroup.addLogFile(queryView, logFile1);
        MatcherAssert.assertThat((String)"no base file in the file group, returns the delta commit instant itself", (Object)fileGroup.getBaseInstantTime(queryView, logFile1), (Matcher)CoreMatchers.is((Object)"001"));
        MatcherAssert.assertThat((Object)TestHoodieFileGroup.collectFileSlices(fileGroup), (Matcher)CoreMatchers.is((Object)"001"));
        HoodieLogFile logFile2 = new HoodieLogFile(new StoragePath(TestHoodieFileGroup.getLogFileName("002")));
        fileGroup.addLogFile(queryView, logFile2);
        MatcherAssert.assertThat((String)"no base file in the file group, returns the earliest delta commit instant", (Object)fileGroup.getBaseInstantTime(queryView, logFile2), (Matcher)CoreMatchers.is((Object)"001"));
        MatcherAssert.assertThat((Object)TestHoodieFileGroup.collectFileSlices(fileGroup), (Matcher)CoreMatchers.is((Object)"001"));
        fileGroup.addNewFileSliceAtInstant("003");
        MatcherAssert.assertThat((String)"Include the pending compaction instant time as constitute of the file slice base instant time list", (Object)TestHoodieFileGroup.collectFileSlices(fileGroup), (Matcher)CoreMatchers.is((Object)"001,003"));
        HoodieLogFile logFile3 = new HoodieLogFile(new StoragePath(TestHoodieFileGroup.getLogFileName("004")));
        fileGroup.addLogFile(queryView, logFile3);
        MatcherAssert.assertThat((String)"Assign the log file to maximum base instant time that less than or equals its completion time", (Object)fileGroup.getBaseInstantTime(queryView, logFile2), (Matcher)CoreMatchers.is((Object)"003"));
        MatcherAssert.assertThat((Object)TestHoodieFileGroup.collectFileSlices(fileGroup), (Matcher)CoreMatchers.is((Object)"001,003"));
        fileGroup.addBaseFile(new HoodieBaseFile(TestHoodieFileGroup.getBaseFileName("003")));
        fileGroup.addBaseFile(new HoodieBaseFile(TestHoodieFileGroup.getBaseFileName("005")));
        MatcherAssert.assertThat((Object)TestHoodieFileGroup.collectFileSlices(fileGroup), (Matcher)CoreMatchers.is((Object)"001,003,005"));
        MatcherAssert.assertThat((String)"no base file in the file group, returns the earliest delta commit instant", (Object)fileGroup.getBaseInstantTime(queryView, logFile2), (Matcher)CoreMatchers.is((Object)"005"));
    }

    private CompletionTimeQueryView getMockCompletionTimeQueryView(MockHoodieTimeline activeTimeline) {
        Map<String, String> completionTimeMap = activeTimeline.filterCompletedInstants().getInstantsAsStream().collect(Collectors.toMap(HoodieInstant::getTimestamp, HoodieInstant::getCompletionTime));
        CompletionTimeQueryView queryView = (CompletionTimeQueryView)Mockito.mock(CompletionTimeQueryView.class);
        Mockito.when((Object)queryView.getCompletionTime((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class))).thenAnswer(invocationOnMock -> {
            String instantTime = (String)invocationOnMock.getArgument(1);
            return Option.ofNullable(completionTimeMap.get(instantTime));
        });
        return queryView;
    }

    private static String collectFileSlices(HoodieFileGroup fileGroup) {
        return fileGroup.getAllFileSlices().map(FileSlice::getBaseInstantTime).sorted().collect(Collectors.joining(","));
    }

    private static String getLogFileName(String instantTime) {
        return ".fg1_" + instantTime + ".log.1_1-0-1";
    }

    private static String getBaseFileName(String instantTime) {
        return "fg1_1-0-1_" + instantTime + ".parquet";
    }
}

