/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.functional;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieCommandBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestHoodieLogFormatAppendFailure {
    private static File baseDir;
    private static MiniDFSCluster cluster;

    @BeforeAll
    public static void setUpClass() throws IOException {
        Assumptions.assumeFalse((boolean)HoodieTestUtils.shouldUseExternalHdfs());
        baseDir = new File("/tmp/" + UUID.randomUUID());
        FileUtil.fullyDelete((File)baseDir);
        Configuration conf = new Configuration();
        conf.set("hdfs.minidfs.basedir", baseDir.getAbsolutePath());
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.client.socket-timeout", 3000);
        cluster = new MiniDFSCluster.Builder(conf).checkExitOnShutdown(true).numDataNodes(4).build();
    }

    @AfterAll
    public static void tearDownClass() {
        Assumptions.assumeFalse((boolean)HoodieTestUtils.shouldUseExternalHdfs());
        cluster.shutdown(true);
        FileUtil.fullyDelete((File)baseDir);
    }

    @Test
    @Timeout(value=60L)
    public void testFailedToGetAppendStreamFromHDFSNameNode() throws IOException, URISyntaxException, InterruptedException, TimeoutException {
        String uuid = UUID.randomUUID().toString();
        StoragePath localPartitionPath = new StoragePath("/tmp/");
        HoodieHadoopStorage storage = new HoodieHadoopStorage((FileSystem)cluster.getFileSystem());
        StoragePath testPath = new StoragePath(localPartitionPath, uuid);
        storage.createDirectory(testPath);
        List records = SchemaTestUtil.generateTestRecords((int)0, (int)10).stream().map(HoodieAvroIndexedRecord::new).collect(Collectors.toList());
        HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>(2);
        header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, "100");
        header.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, SchemaTestUtil.getSimpleSchema().toString());
        HoodieAvroDataBlock dataBlock = new HoodieAvroDataBlock(records, false, header, HoodieRecord.RECORD_KEY_METADATA_FIELD);
        HoodieLogFormat.Writer writer = HoodieLogFormat.newWriterBuilder().onParentPath(testPath).withFileExtension(".archive").withFileId("commits").withDeltaCommit("").withStorage((HoodieStorage)storage).build();
        writer.appendBlock((HoodieLogBlock)dataBlock);
        int logFileVersion = writer.getLogFile().getLogVersion();
        StoragePath logFilePath = writer.getLogFile().getPath();
        writer.close();
        FileSystem fs = (FileSystem)storage.getFileSystem();
        DFSTestUtil.waitReplication((FileSystem)fs, (Path)new Path(logFilePath.toUri()), (short)3);
        LocatedBlocks lbs = cluster.getFileSystem().getClient().getNamenode().getBlockLocations("/tmp/" + uuid + "/" + logFilePath.getName(), 0L, Long.MAX_VALUE);
        ArrayList dnsOfCluster = cluster.getDataNodes();
        DatanodeInfo[] dnsWithLocations = lbs.getLastLocatedBlock().getLocations();
        for (DataNode dn : dnsOfCluster) {
            for (DatanodeInfo loc : dnsWithLocations) {
                if (!dn.getDatanodeId().equals((Object)loc)) continue;
                dn.shutdown();
                cluster.stopDataNode(dn.getDisplayName());
                DFSTestUtil.waitForDatanodeDeath((DataNode)dn);
            }
        }
        DFSTestUtil.waitReplication((FileSystem)fs, (Path)new Path(logFilePath.toUri()), (short)0);
        writer = HoodieLogFormat.newWriterBuilder().onParentPath(testPath).withFileExtension(".archive").withFileId("commits").withDeltaCommit("").withStorage((HoodieStorage)storage).build();
        header = new HashMap();
        header.put(HoodieLogBlock.HeaderMetadataType.COMMAND_BLOCK_TYPE, String.valueOf(HoodieCommandBlock.HoodieCommandBlockTypeEnum.ROLLBACK_BLOCK.ordinal()));
        writer.appendBlock((HoodieLogBlock)new HoodieCommandBlock(header));
        Assertions.assertNotEquals((int)writer.getLogFile().getLogVersion(), (int)logFileVersion);
        writer.close();
    }
}

