/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs.inline;

import java.util.stream.Stream;
import org.apache.hudi.common.testutils.FileSystemTestUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.inline.InLineFSUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class InLineFSUtilsTest {
    private static Stream<Arguments> configParams() {
        Long[] data = new Long[]{0L, 1000L, 0x80000000L, Long.MAX_VALUE};
        return Stream.of(data).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"configParams"})
    void startOffset(long startOffset) {
        StoragePath inlinePath = FileSystemTestUtils.getPhantomFile(FileSystemTestUtils.getRandomOuterFSPath(), startOffset, 0L);
        Assertions.assertEquals((long)startOffset, (long)InLineFSUtils.startOffset((StoragePath)inlinePath));
    }

    @ParameterizedTest
    @MethodSource(value={"configParams"})
    void length(long inlineLength) {
        StoragePath inlinePath = FileSystemTestUtils.getPhantomFile(FileSystemTestUtils.getRandomOuterFSPath(), 0L, inlineLength);
        Assertions.assertEquals((long)inlineLength, (long)InLineFSUtils.length((StoragePath)inlinePath));
    }
}

