/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import org.apache.hadoop.fs.Path;
import org.apache.hudi.hadoop.fs.HoodieWrapperFileSystem;
import org.apache.hudi.storage.StorageSchemes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStorageSchemes {
    @Test
    public void testStorageSchemes() {
        Assertions.assertTrue((boolean)StorageSchemes.isSchemeSupported((String)"hdfs"));
        Assertions.assertTrue((boolean)StorageSchemes.isSchemeSupported((String)"afs"));
        Assertions.assertFalse((boolean)StorageSchemes.isSchemeSupported((String)"s2"));
        Assertions.assertTrue((boolean)StorageSchemes.isAtomicCreationSupported((String)"file"));
        Assertions.assertTrue((boolean)StorageSchemes.isAtomicCreationSupported((String)"hdfs"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"afs"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"s3a"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"gs"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"wasb"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"adl"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"abfs"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"oss"));
        Assertions.assertTrue((boolean)StorageSchemes.isAtomicCreationSupported((String)"viewfs"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"alluxio"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"cosn"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"dbfs"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"cos"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"jfs"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"bos"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"ks3"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"nos"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"ofs"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"oci"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"tos"));
        Assertions.assertFalse((boolean)StorageSchemes.isAtomicCreationSupported((String)"cfs"));
        Assertions.assertTrue((boolean)StorageSchemes.isAtomicCreationSupported((String)"hopsfs"));
    }

    @Test
    public void testConversionToNewSchema() {
        Path s3TablePath1 = new Path("s3://test.1234/table1");
        Assertions.assertEquals((Object)s3TablePath1, (Object)HoodieWrapperFileSystem.convertPathWithScheme((Path)s3TablePath1, (String)"s3"));
        Path s3TablePath2 = new Path("s3://1234.test/table1");
        Assertions.assertEquals((Object)s3TablePath2, (Object)HoodieWrapperFileSystem.convertPathWithScheme((Path)s3TablePath2, (String)"s3"));
        Path s3TablePath3 = new Path("s3://test1234/table1");
        Assertions.assertEquals((Object)s3TablePath3, (Object)HoodieWrapperFileSystem.convertPathWithScheme((Path)s3TablePath3, (String)"s3"));
        Path hdfsTablePath = new Path("hdfs://sandbox.foo.com:8020/test.1234/table1");
        Assertions.assertEquals((Object)hdfsTablePath, (Object)HoodieWrapperFileSystem.convertPathWithScheme((Path)hdfsTablePath, (String)"hdfs"));
        Path localTablePath = new Path("file:/var/table1");
        Path localTablePathNoPrefix = new Path("/var/table1");
        Assertions.assertEquals((Object)localTablePath, (Object)HoodieWrapperFileSystem.convertPathWithScheme((Path)localTablePath, (String)"file"));
        Assertions.assertEquals((Object)localTablePath, (Object)HoodieWrapperFileSystem.convertPathWithScheme((Path)localTablePathNoPrefix, (String)"file"));
    }
}

