/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.hudi.common.fs.ConsistencyGuard;
import org.apache.hudi.common.fs.FileSystemRetryConfig;
import org.apache.hudi.common.fs.NoOpConsistencyGuard;
import org.apache.hudi.common.fs.TestFSUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.fs.HoodieRetryWrapperFileSystem;
import org.apache.hudi.hadoop.fs.HoodieWrapperFileSystem;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFSUtilsWithRetryWrapperEnable
extends TestFSUtils {
    private static final String EXCEPTION_MESSAGE = "Fake runtime exception here.";
    private long maxRetryIntervalMs;
    private int maxRetryNumbers;
    private long initialRetryIntervalMs;

    @Override
    @BeforeEach
    public void setUp() throws IOException {
        this.initMetaClient();
        FileSystemRetryConfig fileSystemRetryConfig = FileSystemRetryConfig.newBuilder().withFileSystemActionRetryEnabled(true).build();
        this.maxRetryIntervalMs = fileSystemRetryConfig.getMaxRetryIntervalMs();
        this.maxRetryNumbers = fileSystemRetryConfig.getMaxRetryNumbers();
        this.initialRetryIntervalMs = fileSystemRetryConfig.getInitialRetryIntervalMs();
        FakeRemoteFileSystem fakeFs = new FakeRemoteFileSystem(HadoopFSUtils.getFs((String)this.metaClient.getMetaPath().toString(), (StorageConfiguration)this.metaClient.getStorageConf()), 2);
        HoodieRetryWrapperFileSystem fileSystem = new HoodieRetryWrapperFileSystem((FileSystem)fakeFs, this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, "");
        HoodieWrapperFileSystem fs = new HoodieWrapperFileSystem((FileSystem)fileSystem, (ConsistencyGuard)new NoOpConsistencyGuard());
        HoodieHadoopStorage storage = new HoodieHadoopStorage((FileSystem)fs);
        this.metaClient.setHoodieStorage((HoodieStorage)storage);
    }

    @Test
    public void testProcessFilesWithExceptions() throws Exception {
        FakeRemoteFileSystem fakeFs = new FakeRemoteFileSystem(HadoopFSUtils.getFs((String)this.metaClient.getMetaPath().toString(), (StorageConfiguration)this.metaClient.getStorageConf()), 100);
        HoodieRetryWrapperFileSystem fileSystem = new HoodieRetryWrapperFileSystem((FileSystem)fakeFs, this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, "");
        HoodieWrapperFileSystem fs = new HoodieWrapperFileSystem((FileSystem)fileSystem, (ConsistencyGuard)new NoOpConsistencyGuard());
        HoodieHadoopStorage storage = new HoodieHadoopStorage((FileSystem)fs);
        this.metaClient.setHoodieStorage((HoodieStorage)storage);
        List<String> folders = Arrays.asList("2016/04/15", ".hoodie/.temp/2/2016/04/15");
        folders.forEach(f -> {
            RuntimeException cfr_ignored_0 = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.metaClient.getStorage().createDirectory(new StoragePath(new StoragePath(this.basePath), f)));
        });
    }

    @Test
    public void testGetSchema() {
        FakeRemoteFileSystem fakeFs = new FakeRemoteFileSystem(HadoopFSUtils.getFs((String)this.metaClient.getMetaPath().toString(), (StorageConfiguration)this.metaClient.getStorageConf()), 100);
        HoodieRetryWrapperFileSystem fileSystem = new HoodieRetryWrapperFileSystem((FileSystem)fakeFs, this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, "");
        HoodieWrapperFileSystem fs = new HoodieWrapperFileSystem((FileSystem)fileSystem, (ConsistencyGuard)new NoOpConsistencyGuard());
        Assertions.assertDoesNotThrow(() -> ((HoodieWrapperFileSystem)fs).getScheme(), (String)"Method #getSchema does not implement correctly");
    }

    @Test
    public void testGetDefaultReplication() {
        FakeRemoteFileSystem fakeFs = new FakeRemoteFileSystem(HadoopFSUtils.getFs((String)this.metaClient.getMetaPath().toString(), (StorageConfiguration)this.metaClient.getStorageConf()), 100);
        HoodieRetryWrapperFileSystem fileSystem = new HoodieRetryWrapperFileSystem((FileSystem)fakeFs, this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, "");
        HoodieWrapperFileSystem fs = new HoodieWrapperFileSystem((FileSystem)fileSystem, (ConsistencyGuard)new NoOpConsistencyGuard());
        Assertions.assertEquals((int)fs.getDefaultReplication(), (int)3);
        Assertions.assertEquals((int)fs.getDefaultReplication(new Path(this.basePath)), (int)3);
    }

    class FakeRemoteFileSystem
    extends FileSystem {
        private FileSystem fs;
        private int count = 1;
        private int loop;
        private short defaultReplication = (short)3;

        public FakeRemoteFileSystem(FileSystem fs, int retryLoop) {
            this.fs = fs;
            this.loop = retryLoop;
        }

        public URI getUri() {
            return this.fs.getUri();
        }

        public FSDataInputStream open(Path f, int bufferSize) throws IOException {
            if (this.count % this.loop == 0) {
                ++this.count;
                return this.fs.open(f, bufferSize);
            }
            ++this.count;
            throw new RuntimeException(TestFSUtilsWithRetryWrapperEnable.EXCEPTION_MESSAGE);
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            if (this.count % this.loop == 0) {
                ++this.count;
                return this.fs.create(f, permission, overwrite, bufferSize, replication, blockSize, progress);
            }
            ++this.count;
            throw new RuntimeException(TestFSUtilsWithRetryWrapperEnable.EXCEPTION_MESSAGE);
        }

        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
            if (this.count % this.loop == 0) {
                ++this.count;
                return this.fs.append(f, bufferSize, progress);
            }
            ++this.count;
            throw new RuntimeException(TestFSUtilsWithRetryWrapperEnable.EXCEPTION_MESSAGE);
        }

        public boolean rename(Path src, Path dst) throws IOException {
            if (this.count % this.loop == 0) {
                ++this.count;
                return this.fs.rename(src, dst);
            }
            ++this.count;
            throw new RuntimeException(TestFSUtilsWithRetryWrapperEnable.EXCEPTION_MESSAGE);
        }

        public boolean delete(Path f, boolean recursive) throws IOException {
            if (this.count % this.loop == 0) {
                ++this.count;
                return this.fs.delete(f, recursive);
            }
            ++this.count;
            throw new RuntimeException(TestFSUtilsWithRetryWrapperEnable.EXCEPTION_MESSAGE);
        }

        public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
            if (this.count % this.loop == 0) {
                ++this.count;
                return this.fs.listStatus(f);
            }
            ++this.count;
            throw new RuntimeException(TestFSUtilsWithRetryWrapperEnable.EXCEPTION_MESSAGE);
        }

        public void setWorkingDirectory(Path newDir) {
            this.fs.setWorkingDirectory(newDir);
        }

        public Path getWorkingDirectory() {
            return this.fs.getWorkingDirectory();
        }

        public boolean mkdirs(Path f, FsPermission permission) throws IOException {
            if (this.count % this.loop == 0) {
                ++this.count;
                return this.fs.mkdirs(f, permission);
            }
            ++this.count;
            throw new RuntimeException(TestFSUtilsWithRetryWrapperEnable.EXCEPTION_MESSAGE);
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            if (this.count % this.loop == 0) {
                ++this.count;
                return this.fs.getFileStatus(f);
            }
            ++this.count;
            throw new RuntimeException(TestFSUtilsWithRetryWrapperEnable.EXCEPTION_MESSAGE);
        }

        public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws IOException {
            return this.fs.listLocatedStatus(f);
        }

        public Configuration getConf() {
            return this.fs.getConf();
        }

        public String getScheme() {
            return this.fs.getScheme();
        }

        public short getDefaultReplication() {
            return this.defaultReplication;
        }

        public short getDefaultReplication(Path path) {
            return this.defaultReplication;
        }
    }
}

