/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.gcp.transaction.lock;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.gcp.transaction.lock.GCSStorageLockClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

public class TestGCSStorageLockClientAuditOperations {
    private Storage mockGcsClient;
    private Blob mockBlob;
    private Logger mockLogger;
    private GCSStorageLockClient lockClient;

    @BeforeEach
    void setUp() {
        this.mockGcsClient = (Storage)Mockito.mock(Storage.class);
        this.mockLogger = (Logger)Mockito.mock(Logger.class);
        this.mockBlob = (Blob)Mockito.mock(Blob.class);
        String lockFileUri = "gs://test-bucket/table/.hoodie/.locks/table_lock.json";
        String ownerId = "test-owner";
        this.lockClient = new GCSStorageLockClient(ownerId, lockFileUri, new Properties(), (Functions.Function1 & Serializable)props -> this.mockGcsClient, this.mockLogger);
    }

    @Test
    void testReadConfigWithCheckExistsFirstFileNotFound() {
        String configPath = "gs://test-bucket/table/.hoodie/.locks/audit_enabled.json";
        Mockito.when((Object)this.mockGcsClient.get((BlobId)ArgumentMatchers.any(BlobId.class))).thenReturn(null);
        Option result = this.lockClient.readObject(configPath, true);
        Assertions.assertTrue((boolean)result.isEmpty());
        ((Storage)Mockito.verify((Object)this.mockGcsClient, (VerificationMode)Mockito.times((int)1))).get((BlobId)ArgumentMatchers.any(BlobId.class));
        ((Storage)Mockito.verify((Object)this.mockGcsClient, (VerificationMode)Mockito.never())).readAllBytes((BlobId)ArgumentMatchers.any(BlobId.class), new Storage.BlobSourceOption[0]);
    }

    @Test
    void testReadConfigWithCheckExistsFirstBlobExistsFalse() {
        String configPath = "gs://test-bucket/table/.hoodie/.locks/audit_enabled.json";
        Mockito.when((Object)this.mockGcsClient.get((BlobId)ArgumentMatchers.any(BlobId.class))).thenReturn((Object)this.mockBlob);
        Mockito.when((Object)this.mockBlob.exists(new Blob.BlobSourceOption[0])).thenReturn((Object)false);
        Option result = this.lockClient.readObject(configPath, true);
        Assertions.assertTrue((boolean)result.isEmpty());
        ((Storage)Mockito.verify((Object)this.mockGcsClient, (VerificationMode)Mockito.times((int)1))).get((BlobId)ArgumentMatchers.any(BlobId.class));
        ((Blob)Mockito.verify((Object)this.mockBlob, (VerificationMode)Mockito.times((int)1))).exists(new Blob.BlobSourceOption[0]);
        ((Blob)Mockito.verify((Object)this.mockBlob, (VerificationMode)Mockito.never())).getContent(new Blob.BlobSourceOption[0]);
    }

    @Test
    void testReadConfigWithCheckExistsFirstFileExists() {
        String configPath = "gs://test-bucket/table/.hoodie/.locks/audit_enabled.json";
        String expectedContent = "{\"STORAGE_LP_AUDIT_SERVICE_ENABLED\": true}";
        Mockito.when((Object)this.mockGcsClient.get((BlobId)ArgumentMatchers.any(BlobId.class))).thenReturn((Object)this.mockBlob);
        Mockito.when((Object)this.mockBlob.exists(new Blob.BlobSourceOption[0])).thenReturn((Object)true);
        Mockito.when((Object)this.mockBlob.getContent(new Blob.BlobSourceOption[0])).thenReturn((Object)expectedContent.getBytes(StandardCharsets.UTF_8));
        Option result = this.lockClient.readObject(configPath, true);
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)expectedContent, (Object)result.get());
        ((Storage)Mockito.verify((Object)this.mockGcsClient, (VerificationMode)Mockito.times((int)1))).get((BlobId)ArgumentMatchers.any(BlobId.class));
        ((Blob)Mockito.verify((Object)this.mockBlob, (VerificationMode)Mockito.times((int)1))).exists(new Blob.BlobSourceOption[0]);
        ((Blob)Mockito.verify((Object)this.mockBlob, (VerificationMode)Mockito.times((int)1))).getContent(new Blob.BlobSourceOption[0]);
    }

    @Test
    void testReadConfigWithoutCheckExistsFirstFileNotFound() {
        String configPath = "gs://test-bucket/table/.hoodie/.locks/audit_enabled.json";
        StorageException notFoundException = new StorageException(404, "Not Found");
        Mockito.when((Object)this.mockGcsClient.readAllBytes((BlobId)ArgumentMatchers.any(BlobId.class), new Storage.BlobSourceOption[0])).thenThrow(new Throwable[]{notFoundException});
        Option result = this.lockClient.readObject(configPath, false);
        Assertions.assertTrue((boolean)result.isEmpty());
        ((Storage)Mockito.verify((Object)this.mockGcsClient, (VerificationMode)Mockito.never())).get((BlobId)ArgumentMatchers.any(BlobId.class));
        ((Storage)Mockito.verify((Object)this.mockGcsClient, (VerificationMode)Mockito.times((int)1))).readAllBytes((BlobId)ArgumentMatchers.any(BlobId.class), new Storage.BlobSourceOption[0]);
    }

    @Test
    void testReadConfigWithoutCheckExistsFirstFileExists() {
        String configPath = "gs://test-bucket/table/.hoodie/.locks/audit_enabled.json";
        String expectedContent = "{\"STORAGE_LP_AUDIT_SERVICE_ENABLED\": false}";
        Mockito.when((Object)this.mockGcsClient.readAllBytes((BlobId)ArgumentMatchers.any(BlobId.class), new Storage.BlobSourceOption[0])).thenReturn((Object)expectedContent.getBytes(StandardCharsets.UTF_8));
        Option result = this.lockClient.readObject(configPath, false);
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)expectedContent, (Object)result.get());
        ((Storage)Mockito.verify((Object)this.mockGcsClient, (VerificationMode)Mockito.never())).get((BlobId)ArgumentMatchers.any(BlobId.class));
        ((Storage)Mockito.verify((Object)this.mockGcsClient, (VerificationMode)Mockito.times((int)1))).readAllBytes((BlobId)ArgumentMatchers.any(BlobId.class), new Storage.BlobSourceOption[0]);
    }

    @Test
    void testReadConfigWithCheckExistsFirstOtherGcsError() {
        String configPath = "gs://test-bucket/table/.hoodie/.locks/audit_enabled.json";
        StorageException serverError = new StorageException(500, "Internal Server Error");
        Mockito.when((Object)this.mockGcsClient.get((BlobId)ArgumentMatchers.any(BlobId.class))).thenThrow(new Throwable[]{serverError});
        Option result = this.lockClient.readObject(configPath, true);
        Assertions.assertTrue((boolean)result.isEmpty());
        ((Storage)Mockito.verify((Object)this.mockGcsClient, (VerificationMode)Mockito.times((int)1))).get((BlobId)ArgumentMatchers.any(BlobId.class));
        ((Storage)Mockito.verify((Object)this.mockGcsClient, (VerificationMode)Mockito.never())).readAllBytes((BlobId)ArgumentMatchers.any(BlobId.class), new Storage.BlobSourceOption[0]);
    }

    @Test
    void testReadConfigWithInvalidUri() {
        String invalidPath = "not-a-valid-uri";
        Option result = this.lockClient.readObject(invalidPath, false);
        Assertions.assertTrue((boolean)result.isEmpty());
        ((Storage)Mockito.verify((Object)this.mockGcsClient, (VerificationMode)Mockito.never())).get((BlobId)ArgumentMatchers.any(BlobId.class));
        ((Storage)Mockito.verify((Object)this.mockGcsClient, (VerificationMode)Mockito.never())).readAllBytes((BlobId)ArgumentMatchers.any(BlobId.class), new Storage.BlobSourceOption[0]);
    }

    @Test
    void testReadConfigWithRateLimitError() {
        String configPath = "gs://test-bucket/table/.hoodie/.locks/audit_enabled.json";
        StorageException rateLimitException = new StorageException(429, "Too Many Requests");
        Mockito.when((Object)this.mockGcsClient.readAllBytes((BlobId)ArgumentMatchers.any(BlobId.class), new Storage.BlobSourceOption[0])).thenThrow(new Throwable[]{rateLimitException});
        Option result = this.lockClient.readObject(configPath, false);
        Assertions.assertTrue((boolean)result.isEmpty());
        ((Storage)Mockito.verify((Object)this.mockGcsClient, (VerificationMode)Mockito.times((int)1))).readAllBytes((BlobId)ArgumentMatchers.any(BlobId.class), new Storage.BlobSourceOption[0]);
    }

    @Test
    void testWriteObject_success() {
        String filePath = "gs://test-bucket/audit/test-audit.jsonl";
        String content = "{\"test\": \"data\"}\n";
        Mockito.when((Object)this.mockGcsClient.create((BlobInfo)ArgumentMatchers.any(BlobInfo.class), (byte[])ArgumentMatchers.any(byte[].class), new Storage.BlobTargetOption[0])).thenReturn((Object)this.mockBlob);
        boolean result = this.lockClient.writeObject(filePath, content);
        Assertions.assertTrue((boolean)result);
        ((Storage)Mockito.verify((Object)this.mockGcsClient)).create((BlobInfo)ArgumentMatchers.any(BlobInfo.class), (byte[])ArgumentMatchers.eq((Object)content.getBytes(StandardCharsets.UTF_8)), new Storage.BlobTargetOption[0]);
        ((Logger)Mockito.verify((Object)this.mockLogger)).debug("Successfully wrote object to: {}", (Object)filePath);
    }

    @Test
    void testWriteObject_storageException() {
        String filePath = "gs://test-bucket/audit/test-audit.jsonl";
        String content = "{\"test\": \"data\"}\n";
        StorageException storageException = new StorageException(500, "Internal Server Error");
        Mockito.when((Object)this.mockGcsClient.create((BlobInfo)ArgumentMatchers.any(BlobInfo.class), (byte[])ArgumentMatchers.any(byte[].class), new Storage.BlobTargetOption[0])).thenThrow(new Throwable[]{storageException});
        boolean result = this.lockClient.writeObject(filePath, content);
        Assertions.assertFalse((boolean)result);
        ((Logger)Mockito.verify((Object)this.mockLogger)).error(ArgumentMatchers.contains((String)"Error writing object to"), ArgumentMatchers.eq((Object)filePath), ArgumentMatchers.eq((Object)storageException));
    }

    @Test
    void testWriteObject_invalidPath() {
        String invalidPath = "invalid-path";
        String content = "{\"test\": \"data\"}\n";
        boolean result = this.lockClient.writeObject(invalidPath, content);
        Assertions.assertFalse((boolean)result);
        ((Logger)Mockito.verify((Object)this.mockLogger)).error(ArgumentMatchers.contains((String)"Error writing object to"), ArgumentMatchers.eq((Object)invalidPath), ArgumentMatchers.any(Exception.class));
    }

    @Test
    void testWriteObject_emptyContent() {
        String filePath = "gs://test-bucket/audit/empty-content.jsonl";
        String content = "";
        Mockito.when((Object)this.mockGcsClient.create((BlobInfo)ArgumentMatchers.any(BlobInfo.class), (byte[])ArgumentMatchers.any(byte[].class), new Storage.BlobTargetOption[0])).thenReturn((Object)this.mockBlob);
        boolean result = this.lockClient.writeObject(filePath, content);
        Assertions.assertTrue((boolean)result);
        ((Storage)Mockito.verify((Object)this.mockGcsClient)).create((BlobInfo)ArgumentMatchers.any(BlobInfo.class), (byte[])ArgumentMatchers.eq((Object)content.getBytes(StandardCharsets.UTF_8)), new Storage.BlobTargetOption[0]);
        ((Logger)Mockito.verify((Object)this.mockLogger)).debug("Successfully wrote object to: {}", (Object)filePath);
    }

    @Test
    void testWriteObject_rateLimitExceeded() {
        String filePath = "gs://test-bucket/audit/test-audit.jsonl";
        String content = "{\"test\": \"data\"}\n";
        StorageException rateLimitException = new StorageException(429, "Rate Limit Exceeded");
        Mockito.when((Object)this.mockGcsClient.create((BlobInfo)ArgumentMatchers.any(BlobInfo.class), (byte[])ArgumentMatchers.any(byte[].class), new Storage.BlobTargetOption[0])).thenThrow(new Throwable[]{rateLimitException});
        boolean result = this.lockClient.writeObject(filePath, content);
        Assertions.assertFalse((boolean)result);
        ((Logger)Mockito.verify((Object)this.mockLogger)).error(ArgumentMatchers.contains((String)"Error writing object to"), ArgumentMatchers.eq((Object)filePath), ArgumentMatchers.eq((Object)rateLimitException));
    }
}

