/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.gcp.transaction.lock;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.util.Properties;
import org.apache.hudi.client.transaction.lock.StorageBasedLockProvider;
import org.apache.hudi.client.transaction.lock.StorageBasedLockProviderTestBase;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

@Disabled(value="HUDI-9160 The dockerized tests do not work. Disabling them to unblock Azure CI")
public class TestGCSStorageBasedLockProvider
extends StorageBasedLockProviderTestBase {
    private static final DockerImageName FAKE_GCS_IMAGE = DockerImageName.parse((String)"fsouza/fake-gcs-server:latest");
    private static GenericContainer<?> GCS_CONTAINER;
    private static String endpoint;
    private static String testBucket;
    protected static Storage storage;

    @BeforeAll
    static void initContainer() {
        GCS_CONTAINER = new GenericContainer(FAKE_GCS_IMAGE).withExposedPorts(new Integer[]{4443}).withCommand("-scheme http");
        GCS_CONTAINER.start();
        Integer mappedPort = GCS_CONTAINER.getMappedPort(4443);
        endpoint = String.format("http://%s:%d", GCS_CONTAINER.getHost(), mappedPort);
        storage = (Storage)((StorageOptions.Builder)((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId("test-project")).setCredentials((Credentials)NoCredentials.getInstance())).setHost(endpoint)).build().getService();
        storage.create(Bucket.newBuilder((String)testBucket).build(), new Storage.BucketTargetOption[0]);
        Bucket retrievedBucket = storage.get(testBucket, new Storage.BucketGetOption[0]);
        Assertions.assertNotNull((Object)retrievedBucket, (String)("Bucket " + testBucket + " should exist but does not."));
    }

    protected StorageBasedLockProvider createLockProvider() {
        LockConfiguration lockConf = new LockConfiguration((Properties)providerProperties);
        try (MockedStatic storageOptionsMock = Mockito.mockStatic(StorageOptions.class);){
            StorageOptions.Builder builderMock = (StorageOptions.Builder)Mockito.mock(StorageOptions.Builder.class);
            StorageOptions storageOptionsInstanceMock = (StorageOptions)Mockito.mock(StorageOptions.class);
            storageOptionsMock.when(StorageOptions::newBuilder).thenReturn((Object)builderMock);
            Mockito.when((Object)builderMock.build()).thenReturn((Object)storageOptionsInstanceMock);
            Mockito.when((Object)storageOptionsInstanceMock.getService()).thenReturn((Object)storage);
            StorageBasedLockProvider storageBasedLockProvider = new StorageBasedLockProvider(lockConf, null);
            return storageBasedLockProvider;
        }
    }

    @BeforeEach
    void setupLockProvider() {
        providerProperties.put((Object)HoodieCommonConfig.BASE_PATH.key(), (Object)String.format("gs://%s/lake/db/tbl-default", testBucket));
        this.lockProvider = this.createLockProvider();
    }

    @AfterAll
    static void stopContainer() {
        if (GCS_CONTAINER != null) {
            GCS_CONTAINER.stop();
        }
    }

    @Test
    void testValidDefaultConstructor() {
        TypedProperties props = new TypedProperties();
        props.put((Object)HoodieCommonConfig.BASE_PATH.key(), (Object)"gs://bucket/lake/db/tbl-default");
        LockConfiguration lockConf = new LockConfiguration((Properties)props);
        StorageBasedLockProvider provider = new StorageBasedLockProvider(lockConf, HoodieTestUtils.getDefaultStorageConf());
        Assertions.assertNull((Object)provider.getLock());
        provider.close();
    }

    @Test
    void testGcsPreconditions() {
        Blob b1 = storage.create(BlobInfo.newBuilder((BlobId)BlobId.of((String)"test-bucket", (String)"myblob")).build(), new byte[]{15}, new Storage.BlobTargetOption[]{Storage.BlobTargetOption.generationMatch((long)0L)});
        Blob b2 = storage.create(BlobInfo.newBuilder((BlobId)BlobId.of((String)"test-bucket", (String)"myblob")).build(), new byte[]{13}, new Storage.BlobTargetOption[]{Storage.BlobTargetOption.generationMatch((long)b1.getGeneration())});
        Assertions.assertNotEquals((Long)b1.getGeneration(), (Long)b2.getGeneration());
    }

    static {
        testBucket = "test-bucket";
    }
}

