/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.gcp.bigquery;

import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.HivePartitioningOptions;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatus;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.gcp.bigquery.BigQuerySyncConfig;
import org.apache.hudi.gcp.bigquery.HoodieBigQuerySyncClient;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHoodieBigQuerySyncClient {
    private static final String PROJECT_ID = "test_project";
    private static final String BILLING_PROJECT_ID = "test_billing_project";
    private static final String MANIFEST_FILE_URI = "file:/manifest_file";
    private static final String SOURCE_PREFIX = "file:/manifest_file/date=*";
    private static final String TEST_TABLE = "test_table";
    private static final String TEST_DATASET = "test_dataset";
    @TempDir
    static Path tempDir;
    private static String basePath;
    private static HoodieTableMetaClient metaClient;
    private final BigQuery mockBigQuery = (BigQuery)Mockito.mock(BigQuery.class);
    private HoodieBigQuerySyncClient client;
    private Properties properties;

    @BeforeAll
    static void setupOnce() throws Exception {
        basePath = tempDir.toString();
        metaClient = HoodieTableMetaClient.newTableBuilder().setTableType(HoodieTableType.COPY_ON_WRITE).setTableName(TEST_TABLE).setPayloadClass(HoodieAvroPayload.class).initTable(HadoopFSUtils.getStorageConf((Configuration)new Configuration()), basePath);
    }

    @BeforeEach
    void setup() {
        this.properties = new Properties();
        this.properties.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_PROJECT_ID.key(), PROJECT_ID);
        this.properties.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_BILLING_PROJECT_ID.key(), BILLING_PROJECT_ID);
        this.properties.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_NAME.key(), TEST_DATASET);
        this.properties.setProperty(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), tempDir.toString());
        this.properties.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_REQUIRE_PARTITION_FILTER.key(), "true");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testCreateOrUpdateTableUsingManifestWithBillingProjectId(boolean setBillingProjectId) {
        Properties props = new Properties();
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_PROJECT_ID.key(), PROJECT_ID);
        if (setBillingProjectId) {
            props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_BILLING_PROJECT_ID.key(), BILLING_PROJECT_ID);
        }
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_NAME.key(), TEST_DATASET);
        props.setProperty(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), tempDir.toString());
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_REQUIRE_PARTITION_FILTER.key(), "true");
        BigQuerySyncConfig syncConfig = new BigQuerySyncConfig(props);
        Job mockJob = (Job)Mockito.mock(Job.class);
        ArgumentCaptor jobInfoCaptor = ArgumentCaptor.forClass(JobInfo.class);
        Mockito.when((Object)this.mockBigQuery.create((JobInfo)jobInfoCaptor.capture(), new BigQuery.JobOption[0])).thenReturn((Object)mockJob);
        HoodieBigQuerySyncClient syncClient = new HoodieBigQuerySyncClient(syncConfig, this.mockBigQuery, metaClient);
        Schema schema = Schema.of((Field[])new Field[]{Field.of((String)"field", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0])});
        syncClient.createOrUpdateTableUsingBqManifestFile(TEST_TABLE, MANIFEST_FILE_URI, SOURCE_PREFIX, schema);
        Assertions.assertEquals((Object)(setBillingProjectId ? BILLING_PROJECT_ID : PROJECT_ID), (Object)((JobInfo)jobInfoCaptor.getValue()).getJobId().getProject());
    }

    @Test
    void createTableWithManifestFile_partitioned() throws Exception {
        this.properties.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_BIG_LAKE_CONNECTION_ID.key(), "my-project.us.bl_connection");
        BigQuerySyncConfig config = new BigQuerySyncConfig(this.properties);
        this.client = new HoodieBigQuerySyncClient(config, this.mockBigQuery, metaClient);
        Schema schema = Schema.of((Field[])new Field[]{Field.of((String)"field", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0])});
        ArgumentCaptor jobInfoCaptor = ArgumentCaptor.forClass(JobInfo.class);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)this.mockBigQuery.create((JobInfo)jobInfoCaptor.capture(), new BigQuery.JobOption[0])).thenReturn((Object)mockJob);
        Job mockJobFinished = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.waitFor(new RetryOption[0])).thenReturn((Object)mockJobFinished);
        JobStatus mockJobStatus = (JobStatus)Mockito.mock(JobStatus.class);
        Mockito.when((Object)mockJobFinished.getStatus()).thenReturn((Object)mockJobStatus);
        Mockito.when((Object)mockJobStatus.getError()).thenReturn(null);
        this.client.createOrUpdateTableUsingBqManifestFile(TEST_TABLE, MANIFEST_FILE_URI, SOURCE_PREFIX, schema);
        QueryJobConfiguration configuration = (QueryJobConfiguration)((JobInfo)jobInfoCaptor.getValue()).getConfiguration();
        Assertions.assertEquals((Object)configuration.getQuery(), (Object)String.format("CREATE OR REPLACE EXTERNAL TABLE `%s.%s.%s` ( `field` STRING ) WITH PARTITION COLUMNS WITH CONNECTION `my-project.us.bl_connection` OPTIONS (enable_list_inference=true, hive_partition_uri_prefix=\"%s\", require_hive_partition_filter=true, uris=[\"%s\"], format=\"PARQUET\", file_set_spec_type=\"NEW_LINE_DELIMITED_MANIFEST\")", PROJECT_ID, TEST_DATASET, TEST_TABLE, SOURCE_PREFIX, MANIFEST_FILE_URI));
    }

    @Test
    void createTableWithManifestFile_nonPartitioned() throws Exception {
        BigQuerySyncConfig config = new BigQuerySyncConfig(this.properties);
        this.client = new HoodieBigQuerySyncClient(config, this.mockBigQuery, metaClient);
        Schema schema = Schema.of((Field[])new Field[]{Field.of((String)"field", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0])});
        ArgumentCaptor jobInfoCaptor = ArgumentCaptor.forClass(JobInfo.class);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)this.mockBigQuery.create((JobInfo)jobInfoCaptor.capture(), new BigQuery.JobOption[0])).thenReturn((Object)mockJob);
        Job mockJobFinished = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.waitFor(new RetryOption[0])).thenReturn((Object)mockJobFinished);
        JobStatus mockJobStatus = (JobStatus)Mockito.mock(JobStatus.class);
        Mockito.when((Object)mockJobFinished.getStatus()).thenReturn((Object)mockJobStatus);
        Mockito.when((Object)mockJobStatus.getError()).thenReturn(null);
        this.client.createOrUpdateTableUsingBqManifestFile(TEST_TABLE, MANIFEST_FILE_URI, "", schema);
        QueryJobConfiguration configuration = (QueryJobConfiguration)((JobInfo)jobInfoCaptor.getValue()).getConfiguration();
        Assertions.assertEquals((Object)configuration.getQuery(), (Object)String.format("CREATE OR REPLACE EXTERNAL TABLE `%s.%s.%s` ( `field` STRING ) OPTIONS (enable_list_inference=true, uris=[\"%s\"], format=\"PARQUET\", file_set_spec_type=\"NEW_LINE_DELIMITED_MANIFEST\")", PROJECT_ID, TEST_DATASET, TEST_TABLE, MANIFEST_FILE_URI));
    }

    @Test
    void skipUpdatingSchema_partitioned() {
        BigQuerySyncConfig config = new BigQuerySyncConfig(this.properties);
        this.client = new HoodieBigQuerySyncClient(config, this.mockBigQuery, metaClient);
        Table mockTable = (Table)Mockito.mock(Table.class);
        ExternalTableDefinition mockTableDefinition = (ExternalTableDefinition)Mockito.mock(ExternalTableDefinition.class);
        Schema schema = Schema.of((Field[])new Field[]{Field.of((String)"field", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0])});
        ArrayList<String> partitionFields = new ArrayList<String>();
        partitionFields.add("partition_field");
        ArrayList<Field> bqFields = new ArrayList<Field>();
        bqFields.add(Field.of((String)"field", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]));
        bqFields.add(Field.of((String)"partition_field", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]));
        Schema bqSchema = Schema.of(bqFields);
        HivePartitioningOptions hivePartitioningOptions = HivePartitioningOptions.newBuilder().setRequirePartitionFilter(Boolean.valueOf(true)).build();
        Mockito.when((Object)this.mockBigQuery.getTable((TableId)ArgumentMatchers.any(), new BigQuery.TableOption[0])).thenReturn((Object)mockTable);
        Mockito.when((Object)mockTable.getDefinition()).thenReturn((Object)mockTableDefinition);
        Mockito.when((Object)mockTableDefinition.getSchema()).thenReturn((Object)bqSchema);
        Mockito.when((Object)mockTableDefinition.getHivePartitioningOptions()).thenReturn((Object)hivePartitioningOptions);
        this.client.updateTableSchema(TEST_TABLE, schema, partitionFields);
        ((BigQuery)Mockito.verify((Object)this.mockBigQuery, (VerificationMode)Mockito.never())).update((TableInfo)mockTable, new BigQuery.TableOption[0]);
    }

    @Test
    void testTableNotExistsOrDoesNotMatchSpecification() {
        BigQuerySyncConfig config = new BigQuerySyncConfig(this.properties);
        this.client = new HoodieBigQuerySyncClient(config, this.mockBigQuery, metaClient);
        Assertions.assertTrue((boolean)this.client.tableNotExistsOrDoesNotMatchSpecification(TEST_TABLE));
        TableId tableId = TableId.of((String)PROJECT_ID, (String)TEST_DATASET, (String)TEST_TABLE);
        Table table = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)this.mockBigQuery.getTable(tableId, new BigQuery.TableOption[0])).thenReturn((Object)table);
        ExternalTableDefinition externalTableDefinition = (ExternalTableDefinition)Mockito.mock(ExternalTableDefinition.class);
        Mockito.when((Object)table.exists()).thenReturn((Object)true);
        Mockito.when((Object)table.getDefinition()).thenReturn((Object)externalTableDefinition);
        Mockito.when((Object)externalTableDefinition.getSourceUris()).thenReturn(Collections.emptyList());
        Assertions.assertTrue((boolean)this.client.tableNotExistsOrDoesNotMatchSpecification(TEST_TABLE));
        Mockito.when((Object)externalTableDefinition.getSourceUris()).thenReturn(Collections.singletonList(basePath + "/.hoodie/" + "absolute-path-manifest"));
        Assertions.assertFalse((boolean)this.client.tableNotExistsOrDoesNotMatchSpecification(TEST_TABLE));
        Mockito.when((Object)externalTableDefinition.getSourceUris()).thenReturn(Collections.singletonList("absolute-path-manifest"));
        Mockito.when((Object)externalTableDefinition.getHivePartitioningOptions()).thenReturn((Object)HivePartitioningOptions.newBuilder().setSourceUriPrefix(basePath + "1").build());
        Assertions.assertTrue((boolean)this.client.tableNotExistsOrDoesNotMatchSpecification(TEST_TABLE));
        Mockito.when((Object)externalTableDefinition.getHivePartitioningOptions()).thenReturn((Object)HivePartitioningOptions.newBuilder().setSourceUriPrefix(basePath + "/").build());
        Assertions.assertFalse((boolean)this.client.tableNotExistsOrDoesNotMatchSpecification(TEST_TABLE));
    }
}

