/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.gcp.bigquery;

import java.util.Arrays;
import java.util.Properties;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.gcp.bigquery.BigQuerySyncConfig;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBigQuerySyncConfig {
    @Test
    public void testGetConfigs() {
        Properties props = new Properties();
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_PROJECT_ID.key(), "fooproject");
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_BILLING_PROJECT_ID.key(), "foobillingproject");
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_NAME.key(), "foodataset");
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_LOCATION.key(), "US");
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_TABLE_NAME.key(), "footable");
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_USE_BQ_MANIFEST_FILE.key(), "true");
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI.key(), "gs://test-bucket/dwh/table_name/dt=*");
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI_PREFIX.key(), "gs://test-bucket/dwh/table_name/");
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_PARTITION_FIELDS.key(), "a,b");
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_USE_FILE_LISTING_FROM_METADATA.key(), "true");
        BigQuerySyncConfig syncConfig = new BigQuerySyncConfig(props);
        Assertions.assertEquals((Object)"fooproject", (Object)syncConfig.getString(BigQuerySyncConfig.BIGQUERY_SYNC_PROJECT_ID));
        Assertions.assertEquals((Object)"foobillingproject", (Object)syncConfig.getString(BigQuerySyncConfig.BIGQUERY_SYNC_BILLING_PROJECT_ID));
        Assertions.assertEquals((Object)"foodataset", (Object)syncConfig.getString(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_NAME));
        Assertions.assertEquals((Object)"US", (Object)syncConfig.getString(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_LOCATION));
        Assertions.assertEquals((Object)"footable", (Object)syncConfig.getString(BigQuerySyncConfig.BIGQUERY_SYNC_TABLE_NAME));
        Assertions.assertEquals((Object)true, (Object)syncConfig.getBoolean(BigQuerySyncConfig.BIGQUERY_SYNC_USE_BQ_MANIFEST_FILE));
        Assertions.assertEquals((Object)"gs://test-bucket/dwh/table_name/dt=*", (Object)syncConfig.getString(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI));
        Assertions.assertEquals((Object)"gs://test-bucket/dwh/table_name/", (Object)syncConfig.getString(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI_PREFIX));
        Assertions.assertEquals(Arrays.asList("a", "b"), (Object)syncConfig.getSplitStrings(BigQuerySyncConfig.BIGQUERY_SYNC_PARTITION_FIELDS));
        Assertions.assertEquals((Object)true, (Object)syncConfig.getBoolean(BigQuerySyncConfig.BIGQUERY_SYNC_USE_FILE_LISTING_FROM_METADATA));
    }

    @Test
    public void testInferDatasetAndTableNames() {
        Properties props1 = new Properties();
        props1.setProperty(HoodieTableConfig.DATABASE_NAME.key(), "db1");
        props1.setProperty("hoodie.table.name", "tbl1");
        BigQuerySyncConfig config1 = new BigQuerySyncConfig(props1);
        Assertions.assertEquals((Object)"db1", (Object)config1.getString(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_NAME));
        Assertions.assertEquals((Object)"tbl1", (Object)config1.getString(BigQuerySyncConfig.BIGQUERY_SYNC_TABLE_NAME));
        Properties props2 = new Properties();
        props2.setProperty(HoodieTableConfig.DATABASE_NAME.key(), "db2");
        props2.setProperty("hoodie.datasource.write.table.name", "tbl2");
        BigQuerySyncConfig config2 = new BigQuerySyncConfig(props2);
        Assertions.assertEquals((Object)"db2", (Object)config2.getString(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_NAME));
        Assertions.assertEquals((Object)"tbl2", (Object)config2.getString(BigQuerySyncConfig.BIGQUERY_SYNC_TABLE_NAME));
    }

    @Test
    public void testInferPartitionFields() {
        Properties props0 = new Properties();
        BigQuerySyncConfig config0 = new BigQuerySyncConfig(props0);
        Assertions.assertNull((Object)config0.getString(BigQuerySyncConfig.BIGQUERY_SYNC_PARTITION_FIELDS), (String)String.format("should get null due to absence of both %s and %s", HoodieTableConfig.PARTITION_FIELDS.key(), KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()));
        Properties props1 = new Properties();
        props1.setProperty(HoodieTableConfig.PARTITION_FIELDS.key(), "foo,bar,baz");
        BigQuerySyncConfig config1 = new BigQuerySyncConfig(props1);
        Assertions.assertEquals((Object)"foo,bar,baz", (Object)config1.getString(BigQuerySyncConfig.BIGQUERY_SYNC_PARTITION_FIELDS), (String)String.format("should infer from %s", HoodieTableConfig.PARTITION_FIELDS.key()));
        Properties props2 = new Properties();
        props2.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "foo,bar");
        BigQuerySyncConfig config2 = new BigQuerySyncConfig(props2);
        Assertions.assertEquals((Object)"foo,bar", (Object)config2.getString(BigQuerySyncConfig.BIGQUERY_SYNC_PARTITION_FIELDS), (String)String.format("should infer from %s", KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()));
        Properties props3 = new Properties();
        props3.setProperty(HoodieTableConfig.PARTITION_FIELDS.key(), "foo,bar,baz");
        props3.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "foo,bar");
        BigQuerySyncConfig config3 = new BigQuerySyncConfig(props3);
        Assertions.assertEquals((Object)"foo,bar,baz", (Object)config3.getString(BigQuerySyncConfig.BIGQUERY_SYNC_PARTITION_FIELDS), (String)String.format("should infer from %s, which has higher precedence.", HoodieTableConfig.PARTITION_FIELDS.key()));
    }

    @Test
    void testInferUseFileListingFromMetadata() {
        BigQuerySyncConfig config1 = new BigQuerySyncConfig(new Properties());
        Assertions.assertEquals((Object)true, (Object)config1.getBoolean(BigQuerySyncConfig.BIGQUERY_SYNC_USE_FILE_LISTING_FROM_METADATA));
        Properties props2 = new Properties();
        props2.setProperty(HoodieMetadataConfig.ENABLE.key(), "true");
        BigQuerySyncConfig config2 = new BigQuerySyncConfig(props2);
        Assertions.assertEquals((Object)true, (Object)config2.getBoolean(BigQuerySyncConfig.BIGQUERY_SYNC_USE_FILE_LISTING_FROM_METADATA));
    }
}

