/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.gcp.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.StandardSQLTypeName;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.gcp.bigquery.BigQuerySchemaResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestBigQuerySchemaResolver {
    private static final com.google.cloud.bigquery.Schema PRIMITIVE_TYPES_BQ_SCHEMA = com.google.cloud.bigquery.Schema.of((Field[])new Field[]{Field.newBuilder((String)"requiredBoolean", (StandardSQLTypeName)StandardSQLTypeName.BOOL, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"optionalBoolean", (StandardSQLTypeName)StandardSQLTypeName.BOOL, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"requiredInt", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"optionalInt", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"requiredLong", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"optionalLong", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"requiredDouble", (StandardSQLTypeName)StandardSQLTypeName.FLOAT64, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"optionalDouble", (StandardSQLTypeName)StandardSQLTypeName.FLOAT64, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"requiredFloat", (StandardSQLTypeName)StandardSQLTypeName.FLOAT64, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"optionalFloat", (StandardSQLTypeName)StandardSQLTypeName.FLOAT64, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"requiredString", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"optionalString", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"requiredBytes", (StandardSQLTypeName)StandardSQLTypeName.BYTES, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"optionalBytes", (StandardSQLTypeName)StandardSQLTypeName.BYTES, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"requiredEnum", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"optionalEnum", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()});
    private static final Schema PRIMITIVE_TYPES = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.EnumDefault)SchemaBuilder.record((String)"testRecord").fields().requiredBoolean("requiredBoolean").optionalBoolean("optionalBoolean").requiredInt("requiredInt").optionalInt("optionalInt").requiredLong("requiredLong").optionalLong("optionalLong").requiredDouble("requiredDouble").optionalDouble("optionalDouble").requiredFloat("requiredFloat").optionalFloat("optionalFloat").requiredString("requiredString").optionalString("optionalString").requiredBytes("requiredBytes").optionalBytes("optionalBytes").name("requiredEnum").type().enumeration("REQUIRED_ENUM").symbols(new String[]{"ONE", "TWO"})).enumDefault("ONE").name("optionalEnum").type().optional().enumeration("OPTIONAL_ENUM").symbols(new String[]{"ONE", "TWO"})).endRecord();
    private static final Schema NESTED_FIELDS = (Schema)((SchemaBuilder.FieldAssembler)SchemaBuilder.record((String)"testRecord").fields().name("nestedOne").type().optional().record("nestedOneType").fields().optionalInt("nestedOptionalInt").requiredDouble("nestedRequiredDouble").name("nestedTwo").type((Schema)SchemaBuilder.record((String)"nestedTwoType").fields().optionalString("doublyNestedString").endRecord()).noDefault().endRecord()).endRecord();
    private static final Schema LISTS = (Schema)((SchemaBuilder.ArrayDefault)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)"testRecord").fields().name("intList").type().array().items().intType()).noDefault().name("recordList").type().nullable().array().items((Schema)SchemaBuilder.record((String)"randomname").fields().requiredDouble("requiredDouble").optionalString("optionalString").endRecord())).noDefault().endRecord();
    private static final BigQuerySchemaResolver SCHEMA_RESOLVER = BigQuerySchemaResolver.getInstance();

    @Test
    void convertSchema_primitiveFields() {
        Assertions.assertEquals((Object)PRIMITIVE_TYPES_BQ_SCHEMA, (Object)SCHEMA_RESOLVER.convertSchema(PRIMITIVE_TYPES));
    }

    @Test
    void convertSchemaToString_primitiveTypes() {
        String expectedSqlSchema = "`requiredBoolean` BOOL NOT NULL, `optionalBoolean` BOOL, `requiredInt` INT64 NOT NULL, `optionalInt` INT64, `requiredLong` INT64 NOT NULL, `optionalLong` INT64, `requiredDouble` FLOAT64 NOT NULL, `optionalDouble` FLOAT64, `requiredFloat` FLOAT64 NOT NULL, `optionalFloat` FLOAT64, `requiredString` STRING NOT NULL, `optionalString` STRING, `requiredBytes` BYTES NOT NULL, `optionalBytes` BYTES, `requiredEnum` STRING NOT NULL, `optionalEnum` STRING";
        Assertions.assertEquals((Object)expectedSqlSchema, (Object)BigQuerySchemaResolver.schemaToSqlString((com.google.cloud.bigquery.Schema)SCHEMA_RESOLVER.convertSchema(PRIMITIVE_TYPES)));
    }

    @Test
    void convertSchema_nestedFields() {
        com.google.cloud.bigquery.Schema expected = com.google.cloud.bigquery.Schema.of((Field[])new Field[]{Field.newBuilder((String)"nestedOne", (StandardSQLTypeName)StandardSQLTypeName.STRUCT, (Field[])new Field[]{Field.newBuilder((String)"nestedOptionalInt", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"nestedRequiredDouble", (StandardSQLTypeName)StandardSQLTypeName.FLOAT64, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"nestedTwo", (StandardSQLTypeName)StandardSQLTypeName.STRUCT, (Field[])new Field[]{Field.newBuilder((String)"doublyNestedString", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()}).setMode(Field.Mode.REQUIRED).build()}).setMode(Field.Mode.NULLABLE).build()});
        Assertions.assertEquals((Object)expected, (Object)SCHEMA_RESOLVER.convertSchema(NESTED_FIELDS));
    }

    @Test
    void convertSchemaToString_nestedFields() {
        String expectedSqlSchema = "`nestedOne` STRUCT<`nestedOptionalInt` INT64, `nestedRequiredDouble` FLOAT64 NOT NULL, `nestedTwo` STRUCT<`doublyNestedString` STRING> NOT NULL>";
        Assertions.assertEquals((Object)expectedSqlSchema, (Object)BigQuerySchemaResolver.schemaToSqlString((com.google.cloud.bigquery.Schema)SCHEMA_RESOLVER.convertSchema(NESTED_FIELDS)));
    }

    @Test
    void convertSchema_lists() {
        Field intListField = Field.newBuilder((String)"intList", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).build();
        Field requiredDoubleField = Field.newBuilder((String)"requiredDouble", (StandardSQLTypeName)StandardSQLTypeName.FLOAT64, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build();
        Field optionalStringField = Field.newBuilder((String)"optionalString", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build();
        Field recordListField = Field.newBuilder((String)"recordList", (StandardSQLTypeName)StandardSQLTypeName.STRUCT, (Field[])new Field[]{requiredDoubleField, optionalStringField}).setMode(Field.Mode.REPEATED).build();
        com.google.cloud.bigquery.Schema expected = com.google.cloud.bigquery.Schema.of((Field[])new Field[]{intListField, recordListField});
        Assertions.assertEquals((Object)expected, (Object)SCHEMA_RESOLVER.convertSchema(LISTS));
    }

    @Test
    void convertSchemaToString_lists() {
        String expectedSqlSchema = "`intList` ARRAY<INT64>, `recordList` ARRAY<STRUCT<`requiredDouble` FLOAT64 NOT NULL, `optionalString` STRING>>";
        Assertions.assertEquals((Object)expectedSqlSchema, (Object)BigQuerySchemaResolver.schemaToSqlString((com.google.cloud.bigquery.Schema)SCHEMA_RESOLVER.convertSchema(LISTS)));
    }

    @Test
    void convertSchemaListOfNullableRecords() {
        Schema nestedRecordType = (Schema)SchemaBuilder.record((String)"nested_record").fields().optionalString("inner_string_field").endRecord();
        Schema input = (Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)"top_level_schema").fields().name("top_level_schema_field").type().nullable().array().items((Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().nullType()).and().type(nestedRecordType)).endUnion())).noDefault().endRecord();
        Field innerStringField = Field.newBuilder((String)"inner_string_field", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build();
        Field topLevelSchemaField = Field.newBuilder((String)"top_level_schema_field", (StandardSQLTypeName)StandardSQLTypeName.STRUCT, (Field[])new Field[]{innerStringField}).setMode(Field.Mode.REPEATED).build();
        com.google.cloud.bigquery.Schema expected = com.google.cloud.bigquery.Schema.of((Field[])new Field[]{topLevelSchemaField});
        Assertions.assertEquals((Object)expected, (Object)SCHEMA_RESOLVER.convertSchema(input));
    }

    @Test
    void convertSchema_logicalTypes() {
        String schemaString = "{\"type\":\"record\",\"name\":\"logicalTypes\",\"fields\":[{\"name\":\"int_date\",\"type\":{\"type\":\"int\",\"logicalType\":\"date\"}},{\"name\":\"int_time_millis\",\"type\":{\"type\":\"int\",\"logicalType\":\"time-millis\"}},{\"name\":\"long_time_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"time-micros\"}},{\"name\":\"long_timestamp_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},{\"name\":\"long_timestamp_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}},{\"name\":\"long_timestamp_millis_local\",\"type\":{\"type\":\"long\",\"logicalType\":\"local-timestamp-millis\"}},{\"name\":\"long_timestamp_micros_local\",\"type\":{\"type\":\"long\",\"logicalType\":\"local-timestamp-micros\"}},{\"name\":\"bytes_decimal\",\"type\":{\"type\":\"bytes\",\"logicalType\":\"decimal\", \"precision\": 4, \"scale\": 2}}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema input = parser.parse(schemaString);
        com.google.cloud.bigquery.Schema expected = com.google.cloud.bigquery.Schema.of((Field[])new Field[]{Field.newBuilder((String)"int_date", (StandardSQLTypeName)StandardSQLTypeName.DATE, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"int_time_millis", (StandardSQLTypeName)StandardSQLTypeName.TIME, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"long_time_micros", (StandardSQLTypeName)StandardSQLTypeName.TIME, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"long_timestamp_millis", (StandardSQLTypeName)StandardSQLTypeName.TIMESTAMP, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"long_timestamp_micros", (StandardSQLTypeName)StandardSQLTypeName.TIMESTAMP, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"long_timestamp_millis_local", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"long_timestamp_micros_local", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"bytes_decimal", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build()});
        Assertions.assertEquals((Object)expected, (Object)SCHEMA_RESOLVER.convertSchema(input));
    }

    @Test
    void convertSchema_maps() {
        Schema input = (Schema)((SchemaBuilder.MapDefault)((SchemaBuilder.MapDefault)SchemaBuilder.record((String)"testRecord").fields().name("intMap").type().map().values().intType()).noDefault().name("recordMap").type().nullable().map().values((Schema)SchemaBuilder.record((String)"element").fields().requiredDouble("requiredDouble").optionalString("optionalString").endRecord())).noDefault().endRecord();
        com.google.cloud.bigquery.Schema expected = com.google.cloud.bigquery.Schema.of((Field[])new Field[]{Field.newBuilder((String)"intMap", (StandardSQLTypeName)StandardSQLTypeName.STRUCT, (Field[])new Field[]{Field.newBuilder((String)"key_value", (StandardSQLTypeName)StandardSQLTypeName.STRUCT, (Field[])new Field[]{Field.newBuilder((String)"key", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"value", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build()}).setMode(Field.Mode.REPEATED).build()}).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"recordMap", (StandardSQLTypeName)StandardSQLTypeName.STRUCT, (Field[])new Field[]{Field.newBuilder((String)"key_value", (StandardSQLTypeName)StandardSQLTypeName.STRUCT, (Field[])new Field[]{Field.newBuilder((String)"key", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"value", (StandardSQLTypeName)StandardSQLTypeName.STRUCT, (Field[])new Field[]{Field.newBuilder((String)"requiredDouble", (StandardSQLTypeName)StandardSQLTypeName.FLOAT64, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"optionalString", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()}).setMode(Field.Mode.REQUIRED).build()}).setMode(Field.Mode.REPEATED).build()}).setMode(Field.Mode.NULLABLE).build()});
        Assertions.assertEquals((Object)expected, (Object)SCHEMA_RESOLVER.convertSchema(input));
    }

    @Test
    void getTableSchema_withPartitionFields() throws Exception {
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        TableSchemaResolver mockTableSchemaResolver = (TableSchemaResolver)Mockito.mock(TableSchemaResolver.class);
        Mockito.when((Object)mockTableSchemaResolver.getTableAvroSchema()).thenReturn((Object)PRIMITIVE_TYPES);
        BigQuerySchemaResolver resolver = new BigQuerySchemaResolver(metaClient -> mockTableSchemaResolver);
        com.google.cloud.bigquery.Schema expected = com.google.cloud.bigquery.Schema.of((Field[])new Field[]{Field.newBuilder((String)"requiredBoolean", (StandardSQLTypeName)StandardSQLTypeName.BOOL, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"optionalBoolean", (StandardSQLTypeName)StandardSQLTypeName.BOOL, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"requiredInt", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"optionalInt", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"requiredLong", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"optionalLong", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"requiredDouble", (StandardSQLTypeName)StandardSQLTypeName.FLOAT64, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"optionalDouble", (StandardSQLTypeName)StandardSQLTypeName.FLOAT64, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"requiredFloat", (StandardSQLTypeName)StandardSQLTypeName.FLOAT64, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"optionalFloat", (StandardSQLTypeName)StandardSQLTypeName.FLOAT64, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"optionalString", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"requiredBytes", (StandardSQLTypeName)StandardSQLTypeName.BYTES, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"optionalBytes", (StandardSQLTypeName)StandardSQLTypeName.BYTES, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"requiredEnum", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"optionalEnum", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()});
        Assertions.assertEquals((Object)expected, (Object)resolver.getTableSchema(mockMetaClient, Collections.singletonList("requiredString")));
    }

    @Test
    void getTableSchema_withoutPartitionFields() throws Exception {
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        TableSchemaResolver mockTableSchemaResolver = (TableSchemaResolver)Mockito.mock(TableSchemaResolver.class);
        Mockito.when((Object)mockTableSchemaResolver.getTableAvroSchema()).thenReturn((Object)PRIMITIVE_TYPES);
        Mockito.when((Object)mockTableSchemaResolver.getTableAvroSchema()).thenReturn((Object)PRIMITIVE_TYPES);
        BigQuerySchemaResolver resolver = new BigQuerySchemaResolver(metaClient -> mockTableSchemaResolver);
        Assertions.assertEquals((Object)PRIMITIVE_TYPES_BQ_SCHEMA, (Object)resolver.getTableSchema(mockMetaClient, Collections.emptyList()));
    }
}

