/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.gcp.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.StandardSQLTypeName;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.gcp.bigquery.HoodieBigQuerySyncException;

public class BigQuerySchemaResolver {
    private static final BigQuerySchemaResolver INSTANCE = new BigQuerySchemaResolver(TableSchemaResolver::new);
    private final Function<HoodieTableMetaClient, TableSchemaResolver> tableSchemaResolverSupplier;

    @VisibleForTesting
    BigQuerySchemaResolver(Function<HoodieTableMetaClient, TableSchemaResolver> tableSchemaResolverSupplier) {
        this.tableSchemaResolverSupplier = tableSchemaResolverSupplier;
    }

    public static BigQuerySchemaResolver getInstance() {
        return INSTANCE;
    }

    com.google.cloud.bigquery.Schema getTableSchema(HoodieTableMetaClient metaClient, List<String> partitionFields) {
        try {
            com.google.cloud.bigquery.Schema schema = this.convertSchema(this.tableSchemaResolverSupplier.apply(metaClient).getTableAvroSchema());
            if (partitionFields.isEmpty()) {
                return schema;
            }
            return com.google.cloud.bigquery.Schema.of((Iterable)schema.getFields().stream().filter(field -> !partitionFields.contains(field.getName())).collect(Collectors.toList()));
        }
        catch (Exception e) {
            throw new HoodieBigQuerySyncException("Failed to get table schema", e);
        }
    }

    public static String schemaToSqlString(com.google.cloud.bigquery.Schema schema) {
        return BigQuerySchemaResolver.fieldsToSqlString((List<Field>)schema.getFields());
    }

    private static String fieldsToSqlString(List<Field> fields) {
        return fields.stream().map(field -> {
            String mode = field.getMode() == Field.Mode.REQUIRED ? " NOT NULL" : "";
            String type = field.getType().getStandardType() == StandardSQLTypeName.STRUCT ? String.format("STRUCT<%s>", BigQuerySchemaResolver.fieldsToSqlString((List<Field>)field.getSubFields())) : field.getType().getStandardType().name();
            String name = field.getName();
            if (field.getMode() == Field.Mode.REPEATED) {
                return String.format("`%s` ARRAY<%s>", name, type);
            }
            return String.format("`%s` %s%s", name, type, mode);
        }).collect(Collectors.joining(", "));
    }

    @VisibleForTesting
    com.google.cloud.bigquery.Schema convertSchema(Schema schema) {
        return com.google.cloud.bigquery.Schema.of(this.getFields(schema));
    }

    private Field getField(Schema fieldSchema, String name, boolean nullable) {
        StandardSQLTypeName standardSQLTypeName;
        Field.Mode fieldMode = nullable ? Field.Mode.NULLABLE : Field.Mode.REQUIRED;
        switch (fieldSchema.getType()) {
            case INT: 
            case LONG: {
                LogicalType logicalType = fieldSchema.getLogicalType();
                if (logicalType == null) {
                    standardSQLTypeName = StandardSQLTypeName.INT64;
                    break;
                }
                if (logicalType.equals(LogicalTypes.date())) {
                    standardSQLTypeName = StandardSQLTypeName.DATE;
                    break;
                }
                if (logicalType.equals(LogicalTypes.timeMillis()) || logicalType.equals(LogicalTypes.timeMicros())) {
                    standardSQLTypeName = StandardSQLTypeName.TIME;
                    break;
                }
                if (logicalType.equals(LogicalTypes.timestampMillis()) || logicalType.equals(LogicalTypes.timestampMicros())) {
                    standardSQLTypeName = StandardSQLTypeName.TIMESTAMP;
                    break;
                }
                if (logicalType.getName().equals("local-timestamp-millis") || logicalType.getName().equals("local-timestamp-micros")) {
                    standardSQLTypeName = StandardSQLTypeName.INT64;
                    break;
                }
                throw new IllegalArgumentException("Unexpected logical type in schema: " + logicalType);
            }
            case ENUM: 
            case STRING: {
                standardSQLTypeName = StandardSQLTypeName.STRING;
                break;
            }
            case BOOLEAN: {
                standardSQLTypeName = StandardSQLTypeName.BOOL;
                break;
            }
            case DOUBLE: 
            case FLOAT: {
                standardSQLTypeName = StandardSQLTypeName.FLOAT64;
                break;
            }
            case BYTES: 
            case FIXED: {
                LogicalType bytesLogicalType = fieldSchema.getLogicalType();
                if (bytesLogicalType == null) {
                    standardSQLTypeName = StandardSQLTypeName.BYTES;
                    break;
                }
                if (bytesLogicalType instanceof LogicalTypes.Decimal) {
                    standardSQLTypeName = StandardSQLTypeName.NUMERIC;
                    break;
                }
                throw new IllegalArgumentException("Unexpected logical type in schema: " + bytesLogicalType);
            }
            case RECORD: {
                return Field.newBuilder((String)name, (StandardSQLTypeName)StandardSQLTypeName.STRUCT, (FieldList)FieldList.of(this.getFields(fieldSchema))).setMode(fieldMode).build();
            }
            case ARRAY: {
                Field arrayField = this.getField(fieldSchema.getElementType(), "array", true);
                return Field.newBuilder((String)name, (LegacySQLTypeName)arrayField.getType(), (FieldList)arrayField.getSubFields()).setMode(Field.Mode.REPEATED).build();
            }
            case MAP: {
                Field keyField = Field.newBuilder((String)"key", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build();
                Field valueField = this.getField(fieldSchema.getValueType(), "value", false);
                Field keyValueField = Field.newBuilder((String)"key_value", (StandardSQLTypeName)StandardSQLTypeName.STRUCT, (Field[])new Field[]{keyField, valueField}).setMode(Field.Mode.REPEATED).build();
                return Field.newBuilder((String)name, (StandardSQLTypeName)StandardSQLTypeName.STRUCT, (Field[])new Field[]{keyValueField}).setMode(Field.Mode.NULLABLE).build();
            }
            case UNION: {
                List subTypes = fieldSchema.getTypes();
                this.validateUnion(subTypes);
                Schema fieldSchemaFromUnion = ((Schema)subTypes.get(0)).getType() == Schema.Type.NULL ? (Schema)subTypes.get(1) : (Schema)subTypes.get(0);
                nullable = true;
                return this.getField(fieldSchemaFromUnion, name, nullable);
            }
            default: {
                throw new RuntimeException("Unexpected field type: " + fieldSchema.getType());
            }
        }
        return Field.newBuilder((String)name, (StandardSQLTypeName)standardSQLTypeName, (Field[])new Field[0]).setMode(fieldMode).build();
    }

    private List<Field> getFields(Schema schema) {
        return schema.getFields().stream().map(field -> {
            boolean nullable;
            Schema fieldSchema;
            if (field.schema().getType() == Schema.Type.UNION) {
                List subTypes = field.schema().getTypes();
                this.validateUnion(subTypes);
                fieldSchema = ((Schema)subTypes.get(0)).getType() == Schema.Type.NULL ? (Schema)subTypes.get(1) : (Schema)subTypes.get(0);
                nullable = true;
            } else {
                fieldSchema = field.schema();
                nullable = false;
            }
            return this.getField(fieldSchema, field.name(), nullable);
        }).collect(Collectors.toList());
    }

    private void validateUnion(List<Schema> subTypes) {
        if (subTypes.size() != 2 || subTypes.get(0).getType() != Schema.Type.NULL && subTypes.get(1).getType() != Schema.Type.NULL) {
            throw new HoodieException("Only unions of a single type and null are currently supported");
        }
    }
}

