/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.gcp.bigquery;

import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.HivePartitioningOptions;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.ViewDefinition;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.gcp.bigquery.BigQuerySchemaResolver;
import org.apache.hudi.gcp.bigquery.BigQuerySyncConfig;
import org.apache.hudi.gcp.bigquery.HoodieBigQuerySyncException;
import org.apache.hudi.sync.common.HoodieSyncClient;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieBigQuerySyncClient
extends HoodieSyncClient {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieBigQuerySyncClient.class);
    protected final BigQuerySyncConfig config;
    private final String projectId;
    private final String datasetName;
    private transient BigQuery bigquery;

    public HoodieBigQuerySyncClient(BigQuerySyncConfig config) {
        super((HoodieSyncConfig)config);
        this.config = config;
        this.projectId = config.getString(BigQuerySyncConfig.BIGQUERY_SYNC_PROJECT_ID);
        this.datasetName = config.getString(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_NAME);
        this.createBigQueryConnection();
    }

    @VisibleForTesting
    HoodieBigQuerySyncClient(BigQuerySyncConfig config, BigQuery bigquery) {
        super((HoodieSyncConfig)config);
        this.config = config;
        this.projectId = config.getString(BigQuerySyncConfig.BIGQUERY_SYNC_PROJECT_ID);
        this.datasetName = config.getString(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_NAME);
        this.bigquery = bigquery;
    }

    private void createBigQueryConnection() {
        if (this.bigquery == null) {
            try {
                this.bigquery = (BigQuery)BigQueryOptions.newBuilder().setLocation(this.config.getString(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_LOCATION)).build().getService();
                LOG.info("Successfully established BigQuery connection.");
            }
            catch (BigQueryException e) {
                throw new HoodieBigQuerySyncException("Cannot create bigQuery connection ", e);
            }
        }
    }

    public void createTableUsingBqManifestFile(String tableName, String bqManifestFileUri, String sourceUriPrefix, Schema schema) {
        try {
            String withClauses = String.format("( %s )", BigQuerySchemaResolver.schemaToSqlString(schema));
            String extraOptions = "enable_list_inference=true,";
            if (!StringUtils.isNullOrEmpty((String)sourceUriPrefix)) {
                withClauses = withClauses + " WITH PARTITION COLUMNS";
                extraOptions = extraOptions + String.format(" hive_partition_uri_prefix=\"%s\",", sourceUriPrefix);
            }
            String query = String.format("CREATE EXTERNAL TABLE `%s.%s.%s` %s OPTIONS (%s uris=[\"%s\"], format=\"PARQUET\", file_set_spec_type=\"NEW_LINE_DELIMITED_MANIFEST\")", this.projectId, this.datasetName, tableName, withClauses, extraOptions, bqManifestFileUri);
            QueryJobConfiguration queryConfig = QueryJobConfiguration.newBuilder((String)query).setUseLegacySql(Boolean.valueOf(false)).build();
            JobId jobId = JobId.newBuilder().setProject(this.projectId).setRandomJob().build();
            Job queryJob = this.bigquery.create(JobInfo.newBuilder((JobConfiguration)queryConfig).setJobId(jobId).build(), new BigQuery.JobOption[0]);
            if ((queryJob = queryJob.waitFor(new RetryOption[0])) == null) {
                LOG.error("Job for table creation no longer exists");
            } else if (queryJob.getStatus().getError() != null) {
                LOG.error("Job for table creation failed: " + queryJob.getStatus().getError().toString());
            } else {
                LOG.info("External table created using manifest file.");
            }
        }
        catch (BigQueryException | InterruptedException e) {
            throw new HoodieBigQuerySyncException("Failed to create external table using manifest file. ", e);
        }
    }

    public void createManifestTable(String tableName, String sourceUri) {
        try {
            TableId tableId = TableId.of((String)this.projectId, (String)this.datasetName, (String)tableName);
            CsvOptions csvOptions = CsvOptions.newBuilder().setFieldDelimiter(",").setAllowJaggedRows(false).setAllowQuotedNewLines(false).setSkipLeadingRows(0L).build();
            Schema schema = Schema.of((Field[])new Field[]{Field.of((String)"filename", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0])});
            ExternalTableDefinition customTable = ExternalTableDefinition.newBuilder((String)sourceUri, (Schema)schema, (FormatOptions)csvOptions).setAutodetect(Boolean.valueOf(false)).setIgnoreUnknownValues(Boolean.valueOf(false)).setMaxBadRecords(Integer.valueOf(0)).build();
            this.bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)customTable), new BigQuery.TableOption[0]);
            LOG.info("Manifest External table created.");
        }
        catch (BigQueryException e) {
            throw new HoodieBigQuerySyncException("Manifest External table was not created ", e);
        }
    }

    public void updateTableSchema(String tableName, Schema schema, List<String> partitionFields) {
        Table existingTable = this.bigquery.getTable(TableId.of((String)this.projectId, (String)this.datasetName, (String)tableName), new BigQuery.TableOption[0]);
        ExternalTableDefinition definition = (ExternalTableDefinition)existingTable.getDefinition();
        Schema remoteTableSchema = definition.getSchema();
        List updatedTableFields = remoteTableSchema.getFields().stream().filter(field -> partitionFields.contains(field.getName())).collect(Collectors.toList());
        updatedTableFields.addAll(schema.getFields());
        Schema finalSchema = Schema.of(updatedTableFields);
        if (definition.getSchema() != null && definition.getSchema().equals((Object)finalSchema)) {
            return;
        }
        Table updatedTable = existingTable.toBuilder().setDefinition((TableDefinition)definition.toBuilder().setSchema(finalSchema).setAutodetect(Boolean.valueOf(false)).build()).build();
        this.bigquery.update((TableInfo)updatedTable, new BigQuery.TableOption[0]);
    }

    public void createVersionsTable(String tableName, String sourceUri, String sourceUriPrefix, List<String> partitionFields) {
        try {
            ExternalTableDefinition customTable;
            TableId tableId = TableId.of((String)this.projectId, (String)this.datasetName, (String)tableName);
            if (partitionFields.isEmpty()) {
                customTable = ExternalTableDefinition.newBuilder((String)sourceUri, (FormatOptions)FormatOptions.parquet()).setAutodetect(Boolean.valueOf(true)).setIgnoreUnknownValues(Boolean.valueOf(true)).setMaxBadRecords(Integer.valueOf(0)).build();
            } else {
                HivePartitioningOptions hivePartitioningOptions = HivePartitioningOptions.newBuilder().setMode("AUTO").setRequirePartitionFilter(Boolean.valueOf(false)).setSourceUriPrefix(sourceUriPrefix).build();
                customTable = ExternalTableDefinition.newBuilder((String)sourceUri, (FormatOptions)FormatOptions.parquet()).setAutodetect(Boolean.valueOf(true)).setHivePartitioningOptions(hivePartitioningOptions).setIgnoreUnknownValues(Boolean.valueOf(true)).setMaxBadRecords(Integer.valueOf(0)).build();
            }
            this.bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)customTable), new BigQuery.TableOption[0]);
            LOG.info("External table created using hivepartitioningoptions");
        }
        catch (BigQueryException e) {
            throw new HoodieBigQuerySyncException("External table was not created ", e);
        }
    }

    public void createSnapshotView(String viewName, String versionsTableName, String manifestTableName) {
        try {
            TableId tableId = TableId.of((String)this.projectId, (String)this.datasetName, (String)viewName);
            String query = String.format("SELECT * FROM `%s.%s.%s` WHERE _hoodie_file_name IN (SELECT filename FROM `%s.%s.%s`)", this.projectId, this.datasetName, versionsTableName, this.projectId, this.datasetName, manifestTableName);
            ViewDefinition viewDefinition = ViewDefinition.newBuilder((String)query).setUseLegacySql(Boolean.valueOf(false)).build();
            this.bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)viewDefinition), new BigQuery.TableOption[0]);
            LOG.info("View created successfully");
        }
        catch (BigQueryException e) {
            throw new HoodieBigQuerySyncException("View was not created ", e);
        }
    }

    public Map<String, String> getMetastoreSchema(String tableName) {
        return Collections.emptyMap();
    }

    public boolean datasetExists() {
        Dataset dataset = this.bigquery.getDataset(DatasetId.of((String)this.projectId, (String)this.datasetName), new BigQuery.DatasetOption[0]);
        return dataset != null;
    }

    public boolean tableExists(String tableName) {
        TableId tableId = TableId.of((String)this.projectId, (String)this.datasetName, (String)tableName);
        Table table = this.bigquery.getTable(tableId, new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])});
        return table != null && table.exists();
    }

    public void close() {
        this.bigquery = null;
    }
}

