/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.gcp.bigquery;

import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatus;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.gcp.bigquery.BigQuerySyncConfig;
import org.apache.hudi.gcp.bigquery.HoodieBigQuerySyncClient;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class TestHoodieBigQuerySyncClient {
    private static final String PROJECT_ID = "test_project";
    private static final String MANIFEST_FILE_URI = "file:/manifest_file";
    private static final String SOURCE_PREFIX = "file:/manifest_file/date=*";
    private static final String TEST_TABLE = "test_table";
    private static final String TEST_DATASET = "test_dataset";
    @TempDir
    static Path tempDir;
    private static String basePath;
    private final BigQuery mockBigQuery = (BigQuery)Mockito.mock(BigQuery.class);
    private HoodieBigQuerySyncClient client;

    @BeforeAll
    static void setupOnce() throws Exception {
        basePath = tempDir.toString();
        HoodieTableMetaClient.withPropertyBuilder().setTableType(HoodieTableType.COPY_ON_WRITE).setTableName(TEST_TABLE).setPayloadClass(HoodieAvroPayload.class).initTable(new Configuration(), basePath);
    }

    @BeforeEach
    void setup() {
        Properties properties = new Properties();
        properties.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_PROJECT_ID.key(), PROJECT_ID);
        properties.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_NAME.key(), TEST_DATASET);
        properties.setProperty(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), tempDir.toString());
        BigQuerySyncConfig config = new BigQuerySyncConfig(properties);
        this.client = new HoodieBigQuerySyncClient(config, this.mockBigQuery);
    }

    @Test
    void createTableWithManifestFile_partitioned() throws Exception {
        Schema schema = Schema.of((Field[])new Field[]{Field.of((String)"field", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0])});
        ArgumentCaptor jobInfoCaptor = ArgumentCaptor.forClass(JobInfo.class);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)this.mockBigQuery.create((JobInfo)jobInfoCaptor.capture(), new BigQuery.JobOption[0])).thenReturn((Object)mockJob);
        Job mockJobFinished = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.waitFor(new RetryOption[0])).thenReturn((Object)mockJobFinished);
        JobStatus mockJobStatus = (JobStatus)Mockito.mock(JobStatus.class);
        Mockito.when((Object)mockJobFinished.getStatus()).thenReturn((Object)mockJobStatus);
        Mockito.when((Object)mockJobStatus.getError()).thenReturn(null);
        this.client.createTableUsingBqManifestFile(TEST_TABLE, MANIFEST_FILE_URI, SOURCE_PREFIX, schema);
        QueryJobConfiguration configuration = (QueryJobConfiguration)((JobInfo)jobInfoCaptor.getValue()).getConfiguration();
        Assertions.assertEquals((Object)configuration.getQuery(), (Object)String.format("CREATE EXTERNAL TABLE `%s.%s.%s` ( `field` STRING ) WITH PARTITION COLUMNS OPTIONS (enable_list_inference=true, hive_partition_uri_prefix=\"%s\", uris=[\"%s\"], format=\"PARQUET\", file_set_spec_type=\"NEW_LINE_DELIMITED_MANIFEST\")", PROJECT_ID, TEST_DATASET, TEST_TABLE, SOURCE_PREFIX, MANIFEST_FILE_URI));
    }

    @Test
    void createTableWithManifestFile_nonPartitioned() throws Exception {
        Schema schema = Schema.of((Field[])new Field[]{Field.of((String)"field", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0])});
        ArgumentCaptor jobInfoCaptor = ArgumentCaptor.forClass(JobInfo.class);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)this.mockBigQuery.create((JobInfo)jobInfoCaptor.capture(), new BigQuery.JobOption[0])).thenReturn((Object)mockJob);
        Job mockJobFinished = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.waitFor(new RetryOption[0])).thenReturn((Object)mockJobFinished);
        JobStatus mockJobStatus = (JobStatus)Mockito.mock(JobStatus.class);
        Mockito.when((Object)mockJobFinished.getStatus()).thenReturn((Object)mockJobStatus);
        Mockito.when((Object)mockJobStatus.getError()).thenReturn(null);
        this.client.createTableUsingBqManifestFile(TEST_TABLE, MANIFEST_FILE_URI, "", schema);
        QueryJobConfiguration configuration = (QueryJobConfiguration)((JobInfo)jobInfoCaptor.getValue()).getConfiguration();
        Assertions.assertEquals((Object)configuration.getQuery(), (Object)String.format("CREATE EXTERNAL TABLE `%s.%s.%s` ( `field` STRING ) OPTIONS (enable_list_inference=true, uris=[\"%s\"], format=\"PARQUET\", file_set_spec_type=\"NEW_LINE_DELIMITED_MANIFEST\")", PROJECT_ID, TEST_DATASET, TEST_TABLE, MANIFEST_FILE_URI));
    }
}

