/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.gcp.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.gcp.bigquery.BigQuerySchemaResolver;
import org.apache.hudi.gcp.bigquery.BigQuerySyncConfig;
import org.apache.hudi.gcp.bigquery.BigQuerySyncTool;
import org.apache.hudi.gcp.bigquery.HoodieBigQuerySyncClient;
import org.apache.hudi.gcp.bigquery.HoodieBigQuerySyncException;
import org.apache.hudi.sync.common.util.ManifestFileWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestBigQuerySyncTool {
    private static final String TEST_TABLE = "test_table";
    private final ManifestFileWriter mockManifestFileWriter = (ManifestFileWriter)Mockito.mock(ManifestFileWriter.class);
    private final HoodieBigQuerySyncClient mockBqSyncClient = (HoodieBigQuerySyncClient)Mockito.mock(HoodieBigQuerySyncClient.class);
    private final BigQuerySchemaResolver mockBqSchemaResolver = (BigQuerySchemaResolver)Mockito.mock(BigQuerySchemaResolver.class);
    private final HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
    private final Properties properties = new Properties();
    private final Schema schema = Schema.of((Field[])new Field[]{Field.of((String)"id", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0])});

    @BeforeEach
    void setup() {
        this.properties.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_TABLE_NAME.key(), TEST_TABLE);
    }

    @Test
    void missingDatasetCausesFailure() {
        Mockito.when((Object)this.mockBqSyncClient.getTableType()).thenReturn((Object)HoodieTableType.COPY_ON_WRITE);
        Mockito.when((Object)this.mockBqSyncClient.datasetExists()).thenReturn((Object)false);
        BigQuerySyncTool tool = new BigQuerySyncTool(this.properties, this.mockManifestFileWriter, this.mockBqSyncClient, this.mockMetaClient, this.mockBqSchemaResolver);
        Assertions.assertThrows(HoodieBigQuerySyncException.class, () -> ((BigQuerySyncTool)tool).syncHoodieTable());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockManifestFileWriter, this.mockBqSchemaResolver});
    }

    @Test
    void useBQManifestFile_newTablePartitioned() {
        this.properties.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_USE_BQ_MANIFEST_FILE.key(), "true");
        String prefix = "file:///local/prefix";
        this.properties.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI_PREFIX.key(), prefix);
        this.properties.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_PARTITION_FIELDS.key(), "datestr,type");
        Mockito.when((Object)this.mockBqSyncClient.getTableType()).thenReturn((Object)HoodieTableType.COPY_ON_WRITE);
        Mockito.when((Object)this.mockBqSyncClient.datasetExists()).thenReturn((Object)true);
        Mockito.when((Object)this.mockBqSyncClient.tableNotExistsOrDoesNotMatchSpecification(TEST_TABLE)).thenReturn((Object)true);
        Path manifestPath = new Path("file:///local/path");
        Mockito.when((Object)this.mockManifestFileWriter.getManifestSourceUri(true)).thenReturn((Object)manifestPath.toUri().getPath());
        Mockito.when((Object)this.mockBqSchemaResolver.getTableSchema((HoodieTableMetaClient)ArgumentMatchers.any(), (List)ArgumentMatchers.eq(Arrays.asList("datestr", "type")))).thenReturn((Object)this.schema);
        BigQuerySyncTool tool = new BigQuerySyncTool(this.properties, this.mockManifestFileWriter, this.mockBqSyncClient, this.mockMetaClient, this.mockBqSchemaResolver);
        tool.syncHoodieTable();
        ((HoodieBigQuerySyncClient)Mockito.verify((Object)this.mockBqSyncClient)).createOrUpdateTableUsingBqManifestFile(TEST_TABLE, manifestPath.toUri().getPath(), prefix, this.schema);
        ((ManifestFileWriter)Mockito.verify((Object)this.mockManifestFileWriter)).writeManifestFile(true);
    }

    @Test
    void useBQManifestFile_newTableNonPartitioned() {
        this.properties.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_USE_BQ_MANIFEST_FILE.key(), "true");
        Mockito.when((Object)this.mockBqSyncClient.getTableType()).thenReturn((Object)HoodieTableType.COPY_ON_WRITE);
        Mockito.when((Object)this.mockBqSyncClient.datasetExists()).thenReturn((Object)true);
        Mockito.when((Object)this.mockBqSyncClient.tableNotExistsOrDoesNotMatchSpecification(TEST_TABLE)).thenReturn((Object)true);
        Path manifestPath = new Path("file:///local/path");
        Mockito.when((Object)this.mockManifestFileWriter.getManifestSourceUri(true)).thenReturn((Object)manifestPath.toUri().getPath());
        Mockito.when((Object)this.mockBqSchemaResolver.getTableSchema((HoodieTableMetaClient)ArgumentMatchers.any(), (List)ArgumentMatchers.eq(Collections.emptyList()))).thenReturn((Object)this.schema);
        BigQuerySyncTool tool = new BigQuerySyncTool(this.properties, this.mockManifestFileWriter, this.mockBqSyncClient, this.mockMetaClient, this.mockBqSchemaResolver);
        tool.syncHoodieTable();
        ((HoodieBigQuerySyncClient)Mockito.verify((Object)this.mockBqSyncClient)).createOrUpdateTableUsingBqManifestFile(TEST_TABLE, manifestPath.toUri().getPath(), null, this.schema);
        ((ManifestFileWriter)Mockito.verify((Object)this.mockManifestFileWriter)).writeManifestFile(true);
    }

    @Test
    void useBQManifestFile_existingPartitionedTable() {
        this.properties.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_USE_BQ_MANIFEST_FILE.key(), "true");
        String prefix = "file:///local/prefix";
        this.properties.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI_PREFIX.key(), prefix);
        this.properties.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_PARTITION_FIELDS.key(), "datestr,type");
        Mockito.when((Object)this.mockBqSyncClient.getTableType()).thenReturn((Object)HoodieTableType.COPY_ON_WRITE);
        Mockito.when((Object)this.mockBqSyncClient.datasetExists()).thenReturn((Object)true);
        Mockito.when((Object)this.mockBqSyncClient.tableNotExistsOrDoesNotMatchSpecification(TEST_TABLE)).thenReturn((Object)false);
        Path manifestPath = new Path("file:///local/path");
        Mockito.when((Object)this.mockManifestFileWriter.getManifestSourceUri(true)).thenReturn((Object)manifestPath.toUri().getPath());
        List<String> partitionFields = Arrays.asList("datestr", "type");
        Mockito.when((Object)this.mockBqSchemaResolver.getTableSchema((HoodieTableMetaClient)ArgumentMatchers.any(), (List)ArgumentMatchers.eq(partitionFields))).thenReturn((Object)this.schema);
        BigQuerySyncTool tool = new BigQuerySyncTool(this.properties, this.mockManifestFileWriter, this.mockBqSyncClient, this.mockMetaClient, this.mockBqSchemaResolver);
        tool.syncHoodieTable();
        ((HoodieBigQuerySyncClient)Mockito.verify((Object)this.mockBqSyncClient)).updateTableSchema(TEST_TABLE, this.schema, partitionFields);
        ((ManifestFileWriter)Mockito.verify((Object)this.mockManifestFileWriter)).writeManifestFile(true);
    }

    @Test
    void useBQManifestFile_existingNonPartitionedTable() {
        this.properties.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_USE_BQ_MANIFEST_FILE.key(), "true");
        Mockito.when((Object)this.mockBqSyncClient.getTableType()).thenReturn((Object)HoodieTableType.COPY_ON_WRITE);
        Mockito.when((Object)this.mockBqSyncClient.datasetExists()).thenReturn((Object)true);
        Mockito.when((Object)this.mockBqSyncClient.tableNotExistsOrDoesNotMatchSpecification(TEST_TABLE)).thenReturn((Object)false);
        Path manifestPath = new Path("file:///local/path");
        Mockito.when((Object)this.mockManifestFileWriter.getManifestSourceUri(true)).thenReturn((Object)manifestPath.toUri().getPath());
        Mockito.when((Object)this.mockBqSchemaResolver.getTableSchema((HoodieTableMetaClient)ArgumentMatchers.any(), (List)ArgumentMatchers.eq(Collections.emptyList()))).thenReturn((Object)this.schema);
        BigQuerySyncTool tool = new BigQuerySyncTool(this.properties, this.mockManifestFileWriter, this.mockBqSyncClient, this.mockMetaClient, this.mockBqSchemaResolver);
        tool.syncHoodieTable();
        ((HoodieBigQuerySyncClient)Mockito.verify((Object)this.mockBqSyncClient)).updateTableSchema(TEST_TABLE, this.schema, Collections.emptyList());
        ((ManifestFileWriter)Mockito.verify((Object)this.mockManifestFileWriter)).writeManifestFile(true);
    }
}

