/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.gcp.bigquery;

import com.beust.jcommander.JCommander;
import java.util.Properties;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.gcp.bigquery.BigQuerySyncConfig;
import org.apache.hudi.gcp.bigquery.HoodieBigQuerySyncClient;
import org.apache.hudi.gcp.bigquery.HoodieBigQuerySyncException;
import org.apache.hudi.sync.common.HoodieSyncTool;
import org.apache.hudi.sync.common.util.ManifestFileWriter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class BigQuerySyncTool
extends HoodieSyncTool {
    private static final Logger LOG = LogManager.getLogger(BigQuerySyncTool.class);
    public final BigQuerySyncConfig config;
    public final String tableName;
    public final String manifestTableName;
    public final String versionsTableName;
    public final String snapshotViewName;

    public BigQuerySyncTool(Properties props) {
        super(props);
        this.config = new BigQuerySyncConfig(props);
        this.tableName = this.config.getString(BigQuerySyncConfig.BIGQUERY_SYNC_TABLE_NAME);
        this.manifestTableName = this.tableName + "_manifest";
        this.versionsTableName = this.tableName + "_versions";
        this.snapshotViewName = this.tableName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void syncHoodieTable() {
        try (HoodieBigQuerySyncClient bqSyncClient = new HoodieBigQuerySyncClient(this.config);){
            switch (bqSyncClient.getTableType()) {
                case COPY_ON_WRITE: {
                    this.syncCoWTable(bqSyncClient);
                    return;
                }
                default: {
                    throw new UnsupportedOperationException(bqSyncClient.getTableType() + " table type is not supported yet.");
                }
            }
        }
        catch (Exception e) {
            throw new HoodieBigQuerySyncException("Failed to sync BigQuery for table:" + this.tableName, e);
        }
    }

    private void syncCoWTable(HoodieBigQuerySyncClient bqSyncClient) {
        ValidationUtils.checkState((bqSyncClient.getTableType() == HoodieTableType.COPY_ON_WRITE ? 1 : 0) != 0);
        LOG.info((Object)("Sync hoodie table " + this.snapshotViewName + " at base path " + bqSyncClient.getBasePath()));
        if (!bqSyncClient.datasetExists()) {
            throw new HoodieBigQuerySyncException("Dataset not found: " + this.config.getString(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_NAME));
        }
        ManifestFileWriter manifestFileWriter = ManifestFileWriter.builder().setConf(this.config.getHadoopConf()).setBasePath(this.config.getString(BigQuerySyncConfig.BIGQUERY_SYNC_SYNC_BASE_PATH)).setUseFileListingFromMetadata(this.config.getBoolean(BigQuerySyncConfig.BIGQUERY_SYNC_USE_FILE_LISTING_FROM_METADATA).booleanValue()).setAssumeDatePartitioning(this.config.getBoolean(BigQuerySyncConfig.BIGQUERY_SYNC_ASSUME_DATE_PARTITIONING).booleanValue()).build();
        manifestFileWriter.writeManifestFile();
        if (!bqSyncClient.tableExists(this.manifestTableName)) {
            bqSyncClient.createManifestTable(this.manifestTableName, manifestFileWriter.getManifestSourceUri());
            LOG.info((Object)("Manifest table creation complete for " + this.manifestTableName));
        }
        if (!bqSyncClient.tableExists(this.versionsTableName)) {
            bqSyncClient.createVersionsTable(this.versionsTableName, this.config.getString(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI), this.config.getString(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI_PREFIX), this.config.getSplitStrings(BigQuerySyncConfig.BIGQUERY_SYNC_PARTITION_FIELDS));
            LOG.info((Object)("Versions table creation complete for " + this.versionsTableName));
        }
        if (!bqSyncClient.tableExists(this.snapshotViewName)) {
            bqSyncClient.createSnapshotView(this.snapshotViewName, this.versionsTableName, this.manifestTableName);
            LOG.info((Object)("Snapshot view creation complete for " + this.snapshotViewName));
        }
        LOG.info((Object)("Sync table complete for " + this.snapshotViewName));
    }

    public static void main(String[] args) {
        BigQuerySyncConfig.BigQuerySyncConfigParams params = new BigQuerySyncConfig.BigQuerySyncConfigParams();
        JCommander cmd = JCommander.newBuilder().addObject((Object)params).build();
        cmd.parse(args);
        if (params.isHelp()) {
            cmd.usage();
            System.exit(0);
        }
        new BigQuerySyncTool(params.toProps()).syncHoodieTable();
    }
}

