/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.gcp.bigquery;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.sync.common.HoodieSyncConfig;

public class BigQuerySyncConfig
extends HoodieSyncConfig
implements Serializable {
    public static final ConfigProperty<String> BIGQUERY_SYNC_PROJECT_ID = ConfigProperty.key((String)"hoodie.gcp.bigquery.sync.project_id").noDefaultValue().withDocumentation("Name of the target project in BigQuery");
    public static final ConfigProperty<String> BIGQUERY_SYNC_DATASET_NAME = ConfigProperty.key((String)"hoodie.gcp.bigquery.sync.dataset_name").noDefaultValue().withDocumentation("Name of the target dataset in BigQuery");
    public static final ConfigProperty<String> BIGQUERY_SYNC_DATASET_LOCATION = ConfigProperty.key((String)"hoodie.gcp.bigquery.sync.dataset_location").noDefaultValue().withDocumentation("Location of the target dataset in BigQuery");
    public static final ConfigProperty<String> BIGQUERY_SYNC_TABLE_NAME = ConfigProperty.key((String)"hoodie.gcp.bigquery.sync.table_name").noDefaultValue().withDocumentation("Name of the target table in BigQuery");
    public static final ConfigProperty<String> BIGQUERY_SYNC_SOURCE_URI = ConfigProperty.key((String)"hoodie.gcp.bigquery.sync.source_uri").noDefaultValue().withDocumentation("Name of the source uri gcs path of the table");
    public static final ConfigProperty<String> BIGQUERY_SYNC_SOURCE_URI_PREFIX = ConfigProperty.key((String)"hoodie.gcp.bigquery.sync.source_uri_prefix").noDefaultValue().withDocumentation("Name of the source uri gcs path prefix of the table");
    public static final ConfigProperty<String> BIGQUERY_SYNC_SYNC_BASE_PATH = ConfigProperty.key((String)"hoodie.gcp.bigquery.sync.base_path").noDefaultValue().withDocumentation("Base path of the hoodie table to sync");
    public static final ConfigProperty<String> BIGQUERY_SYNC_PARTITION_FIELDS = ConfigProperty.key((String)"hoodie.gcp.bigquery.sync.partition_fields").noDefaultValue().withDocumentation("Comma-delimited partition fields. Default to non-partitioned.");
    public static final ConfigProperty<Boolean> BIGQUERY_SYNC_USE_FILE_LISTING_FROM_METADATA = ConfigProperty.key((String)"hoodie.gcp.bigquery.sync.use_file_listing_from_metadata").defaultValue((Object)false).withDocumentation("Fetch file listing from Hudi's metadata");
    public static final ConfigProperty<Boolean> BIGQUERY_SYNC_ASSUME_DATE_PARTITIONING = ConfigProperty.key((String)"hoodie.gcp.bigquery.sync.assume_date_partitioning").defaultValue((Object)false).withDocumentation("Assume standard yyyy/mm/dd partitioning, this exists to support backward compatibility. If you use hoodie 0.3.x, do not set this parameter");

    public BigQuerySyncConfig(Properties props) {
        super(props);
    }

    public static class BigQuerySyncConfigParams {
        @ParametersDelegate
        public final HoodieSyncConfig.HoodieSyncConfigParams hoodieSyncConfigParams = new HoodieSyncConfig.HoodieSyncConfigParams();
        @Parameter(names={"--project-id"}, description="Name of the target project in BigQuery", required=true)
        public String projectId;
        @Parameter(names={"--dataset-name"}, description="Name of the target dataset in BigQuery", required=true)
        public String datasetName;
        @Parameter(names={"--dataset-location"}, description="Location of the target dataset in BigQuery", required=true)
        public String datasetLocation;
        @Parameter(names={"--table-name"}, description="Name of the target table in BigQuery", required=true)
        public String tableName;
        @Parameter(names={"--source-uri"}, description="Name of the source uri gcs path of the table", required=true)
        public String sourceUri;
        @Parameter(names={"--source-uri-prefix"}, description="Name of the source uri gcs path prefix of the table", required=true)
        public String sourceUriPrefix;
        @Parameter(names={"--base-path"}, description="Base path of the hoodie table to sync", required=true)
        public String basePath;
        @Parameter(names={"--partitioned-by"}, description="Comma-delimited partition fields. Default to non-partitioned.")
        public List<String> partitionFields = new ArrayList<String>();
        @Parameter(names={"--use-file-listing-from-metadata"}, description="Fetch file listing from Hudi's metadata")
        public boolean useFileListingFromMetadata = false;
        @Parameter(names={"--assume-date-partitioning"}, description="Assume standard yyyy/mm/dd partitioning, this exists to support backward compatibility. If you use hoodie 0.3.x, do not set this parameter")
        public boolean assumeDatePartitioning = false;

        public boolean isHelp() {
            return this.hoodieSyncConfigParams.isHelp();
        }

        public Properties toProps() {
            TypedProperties props = this.hoodieSyncConfigParams.toProps();
            props.setProperty(BIGQUERY_SYNC_PROJECT_ID.key(), this.projectId);
            props.setProperty(BIGQUERY_SYNC_DATASET_NAME.key(), this.datasetName);
            props.setProperty(BIGQUERY_SYNC_DATASET_LOCATION.key(), this.datasetLocation);
            props.setProperty(BIGQUERY_SYNC_TABLE_NAME.key(), this.tableName);
            props.setProperty(BIGQUERY_SYNC_SOURCE_URI.key(), this.sourceUri);
            props.setProperty(BIGQUERY_SYNC_SOURCE_URI_PREFIX.key(), this.sourceUriPrefix);
            props.setProperty(BIGQUERY_SYNC_SYNC_BASE_PATH.key(), this.basePath);
            props.setProperty(BIGQUERY_SYNC_PARTITION_FIELDS.key(), String.join((CharSequence)",", this.partitionFields));
            props.setProperty(BIGQUERY_SYNC_USE_FILE_LISTING_FROM_METADATA.key(), String.valueOf(this.useFileListingFromMetadata));
            props.setProperty(BIGQUERY_SYNC_ASSUME_DATE_PARTITIONING.key(), String.valueOf(this.assumeDatePartitioning));
            return props;
        }
    }
}

