/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.gcp.bigquery;

import java.util.Arrays;
import java.util.Properties;
import org.apache.hudi.gcp.bigquery.BigQuerySyncConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestBigQuerySyncConfig {
    BigQuerySyncConfig syncConfig;

    @BeforeEach
    void setUp() {
        Properties props = new Properties();
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_PROJECT_ID.key(), "fooproject");
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_NAME.key(), "foodataset");
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_LOCATION.key(), "US");
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_TABLE_NAME.key(), "footable");
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI.key(), "gs://test-bucket/dwh/table_name/dt=*");
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI_PREFIX.key(), "gs://test-bucket/dwh/table_name/");
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_SYNC_BASE_PATH.key(), "gs://test-bucket/dwh/table_name");
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_PARTITION_FIELDS.key(), "a,b");
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_USE_FILE_LISTING_FROM_METADATA.key(), "true");
        props.setProperty(BigQuerySyncConfig.BIGQUERY_SYNC_ASSUME_DATE_PARTITIONING.key(), "true");
        this.syncConfig = new BigQuerySyncConfig(props);
    }

    @Test
    public void testGetConfigs() {
        Assertions.assertEquals((Object)"fooproject", (Object)this.syncConfig.getString(BigQuerySyncConfig.BIGQUERY_SYNC_PROJECT_ID));
        Assertions.assertEquals((Object)"foodataset", (Object)this.syncConfig.getString(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_NAME));
        Assertions.assertEquals((Object)"US", (Object)this.syncConfig.getString(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_LOCATION));
        Assertions.assertEquals((Object)"footable", (Object)this.syncConfig.getString(BigQuerySyncConfig.BIGQUERY_SYNC_TABLE_NAME));
        Assertions.assertEquals((Object)"gs://test-bucket/dwh/table_name/dt=*", (Object)this.syncConfig.getString(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI));
        Assertions.assertEquals((Object)"gs://test-bucket/dwh/table_name/", (Object)this.syncConfig.getString(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI_PREFIX));
        Assertions.assertEquals((Object)"gs://test-bucket/dwh/table_name", (Object)this.syncConfig.getString(BigQuerySyncConfig.BIGQUERY_SYNC_SYNC_BASE_PATH));
        Assertions.assertEquals(Arrays.asList("a", "b"), (Object)this.syncConfig.getSplitStrings(BigQuerySyncConfig.BIGQUERY_SYNC_PARTITION_FIELDS));
        Assertions.assertEquals((Object)true, (Object)this.syncConfig.getBoolean(BigQuerySyncConfig.BIGQUERY_SYNC_USE_FILE_LISTING_FROM_METADATA));
        Assertions.assertEquals((Object)true, (Object)this.syncConfig.getBoolean(BigQuerySyncConfig.BIGQUERY_SYNC_ASSUME_DATE_PARTITIONING));
    }
}

