/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.gcp.bigquery;

import java.util.Arrays;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.gcp.bigquery.BigQuerySyncConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestBigQuerySyncConfig {
    BigQuerySyncConfig syncConfig;

    @BeforeEach
    void setUp() {
        this.syncConfig = new BigQuerySyncConfig();
        this.syncConfig.projectId = "fooproject";
        this.syncConfig.datasetName = "foodataset";
        this.syncConfig.datasetLocation = "US";
        this.syncConfig.tableName = "footable";
        this.syncConfig.sourceUri = "gs://test-bucket/dwh/table_name/dt=*";
        this.syncConfig.sourceUriPrefix = "gs://test-bucket/dwh/table_name/";
        this.syncConfig.basePath = "gs://test-bucket/dwh/table_name";
        this.syncConfig.partitionFields = Arrays.asList("a", "b");
        this.syncConfig.useFileListingFromMetadata = true;
        this.syncConfig.assumeDatePartitioning = true;
        this.syncConfig.help = true;
    }

    @Test
    public void testCopy() {
        BigQuerySyncConfig copied = BigQuerySyncConfig.copy((BigQuerySyncConfig)this.syncConfig);
        Assertions.assertEquals((Object)copied.partitionFields, (Object)this.syncConfig.partitionFields);
        Assertions.assertEquals((Object)copied.basePath, (Object)this.syncConfig.basePath);
        Assertions.assertEquals((Object)copied.projectId, (Object)this.syncConfig.projectId);
        Assertions.assertEquals((Object)copied.datasetName, (Object)this.syncConfig.datasetName);
        Assertions.assertEquals((Object)copied.datasetLocation, (Object)this.syncConfig.datasetLocation);
        Assertions.assertEquals((Object)copied.tableName, (Object)this.syncConfig.tableName);
        Assertions.assertEquals((Object)copied.sourceUri, (Object)this.syncConfig.sourceUri);
        Assertions.assertEquals((Object)copied.sourceUriPrefix, (Object)this.syncConfig.sourceUriPrefix);
        Assertions.assertEquals((Object)copied.useFileListingFromMetadata, (Object)this.syncConfig.useFileListingFromMetadata);
        Assertions.assertEquals((Object)copied.assumeDatePartitioning, (Object)this.syncConfig.assumeDatePartitioning);
        Assertions.assertEquals((Object)copied.help, (Object)this.syncConfig.help);
    }

    @Test
    public void testToProps() {
        TypedProperties props = this.syncConfig.toProps();
        Assertions.assertEquals((Object)"fooproject", (Object)props.getString(BigQuerySyncConfig.BIGQUERY_SYNC_PROJECT_ID));
        Assertions.assertEquals((Object)"foodataset", (Object)props.getString(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_NAME));
        Assertions.assertEquals((Object)"US", (Object)props.getString(BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_LOCATION));
        Assertions.assertEquals((Object)"footable", (Object)props.getString(BigQuerySyncConfig.BIGQUERY_SYNC_TABLE_NAME));
        Assertions.assertEquals((Object)"gs://test-bucket/dwh/table_name/dt=*", (Object)props.getString(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI));
        Assertions.assertEquals((Object)"gs://test-bucket/dwh/table_name/", (Object)props.getString(BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI_PREFIX));
        Assertions.assertEquals((Object)"gs://test-bucket/dwh/table_name", (Object)props.getString(BigQuerySyncConfig.BIGQUERY_SYNC_SYNC_BASE_PATH));
        Assertions.assertEquals((Object)"a,b", (Object)props.getString(BigQuerySyncConfig.BIGQUERY_SYNC_PARTITION_FIELDS));
        Assertions.assertEquals((Object)"true", (Object)props.getString(BigQuerySyncConfig.BIGQUERY_SYNC_USE_FILE_LISTING_FROM_METADATA));
        Assertions.assertEquals((Object)"true", (Object)props.getString(BigQuerySyncConfig.BIGQUERY_SYNC_ASSUME_DATE_PARTITIONING));
    }

    @Test
    public void fromProps() {
        TypedProperties props = new TypedProperties();
        props.put((Object)BigQuerySyncConfig.BIGQUERY_SYNC_PROJECT_ID, (Object)"fooproject");
        props.put((Object)BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_NAME, (Object)"foodataset");
        props.put((Object)BigQuerySyncConfig.BIGQUERY_SYNC_DATASET_LOCATION, (Object)"US");
        props.put((Object)BigQuerySyncConfig.BIGQUERY_SYNC_TABLE_NAME, (Object)"footable");
        props.put((Object)BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI, (Object)"gs://test-bucket/dwh/table_name/dt=*");
        props.put((Object)BigQuerySyncConfig.BIGQUERY_SYNC_SOURCE_URI_PREFIX, (Object)"gs://test-bucket/dwh/table_name/");
        props.put((Object)BigQuerySyncConfig.BIGQUERY_SYNC_SYNC_BASE_PATH, (Object)"gs://test-bucket/dwh/table_name");
        props.put((Object)BigQuerySyncConfig.BIGQUERY_SYNC_PARTITION_FIELDS, (Object)"a,b");
        props.put((Object)BigQuerySyncConfig.BIGQUERY_SYNC_USE_FILE_LISTING_FROM_METADATA, (Object)true);
        props.put((Object)BigQuerySyncConfig.BIGQUERY_SYNC_ASSUME_DATE_PARTITIONING, (Object)true);
        BigQuerySyncConfig cfg = BigQuerySyncConfig.fromProps((TypedProperties)props);
        Assertions.assertEquals((Object)this.syncConfig.projectId, (Object)cfg.projectId);
        Assertions.assertEquals((Object)this.syncConfig.datasetName, (Object)cfg.datasetName);
        Assertions.assertEquals((Object)this.syncConfig.datasetLocation, (Object)cfg.datasetLocation);
        Assertions.assertEquals((Object)this.syncConfig.tableName, (Object)cfg.tableName);
        Assertions.assertEquals((Object)this.syncConfig.sourceUri, (Object)cfg.sourceUri);
        Assertions.assertEquals((Object)this.syncConfig.sourceUriPrefix, (Object)cfg.sourceUriPrefix);
        Assertions.assertEquals((Object)this.syncConfig.basePath, (Object)cfg.basePath);
        Assertions.assertEquals((Object)this.syncConfig.partitionFields, (Object)cfg.partitionFields);
        Assertions.assertEquals((Object)this.syncConfig.useFileListingFromMetadata, (Object)cfg.useFileListingFromMetadata);
        Assertions.assertEquals((Object)this.syncConfig.assumeDatePartitioning, (Object)cfg.assumeDatePartitioning);
    }
}

