/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.gcp.bigquery;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.HivePartitioningOptions;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.ViewDefinition;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.gcp.bigquery.BigQuerySyncConfig;
import org.apache.hudi.gcp.bigquery.HoodieBigQuerySyncException;
import org.apache.hudi.sync.common.AbstractSyncHoodieClient;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.parquet.schema.MessageType;

public class HoodieBigQuerySyncClient
extends AbstractSyncHoodieClient {
    private static final Logger LOG = LogManager.getLogger(HoodieBigQuerySyncClient.class);
    private final BigQuerySyncConfig syncConfig;
    private transient BigQuery bigquery;

    public HoodieBigQuerySyncClient(BigQuerySyncConfig syncConfig, FileSystem fs) {
        super(syncConfig.basePath, syncConfig.assumeDatePartitioning.booleanValue(), syncConfig.useFileListingFromMetadata.booleanValue(), false, fs);
        this.syncConfig = syncConfig;
        this.createBigQueryConnection();
    }

    private void createBigQueryConnection() {
        if (this.bigquery == null) {
            try {
                this.bigquery = (BigQuery)BigQueryOptions.newBuilder().setLocation(this.syncConfig.datasetLocation).build().getService();
                LOG.info((Object)"Successfully established BigQuery connection.");
            }
            catch (BigQueryException e) {
                throw new HoodieBigQuerySyncException("Cannot create bigQuery connection ", e);
            }
        }
    }

    public void createTable(String tableName, MessageType storageSchema, String inputFormatClass, String outputFormatClass, String serdeClass, Map<String, String> serdeProperties, Map<String, String> tableProperties) {
    }

    public void createManifestTable(String tableName, String sourceUri) {
        try {
            TableId tableId = TableId.of((String)this.syncConfig.projectId, (String)this.syncConfig.datasetName, (String)tableName);
            CsvOptions csvOptions = CsvOptions.newBuilder().setFieldDelimiter(",").setAllowJaggedRows(false).setAllowQuotedNewLines(false).setSkipLeadingRows(0L).build();
            Schema schema = Schema.of((Field[])new Field[]{Field.of((String)"filename", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0])});
            ExternalTableDefinition customTable = ExternalTableDefinition.newBuilder((String)sourceUri, (Schema)schema, (FormatOptions)csvOptions).setAutodetect(Boolean.valueOf(false)).setIgnoreUnknownValues(Boolean.valueOf(false)).setMaxBadRecords(Integer.valueOf(0)).build();
            this.bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)customTable), new BigQuery.TableOption[0]);
            LOG.info((Object)"Manifest External table created.");
        }
        catch (BigQueryException e) {
            throw new HoodieBigQuerySyncException("Manifest External table was not created ", e);
        }
    }

    public void createVersionsTable(String tableName, String sourceUri, String sourceUriPrefix, List<String> partitionFields) {
        try {
            ExternalTableDefinition customTable;
            TableId tableId = TableId.of((String)this.syncConfig.projectId, (String)this.syncConfig.datasetName, (String)tableName);
            if (partitionFields.isEmpty()) {
                customTable = ExternalTableDefinition.newBuilder((String)sourceUri, (FormatOptions)FormatOptions.parquet()).setAutodetect(Boolean.valueOf(true)).setIgnoreUnknownValues(Boolean.valueOf(true)).setMaxBadRecords(Integer.valueOf(0)).build();
            } else {
                HivePartitioningOptions hivePartitioningOptions = HivePartitioningOptions.newBuilder().setMode("AUTO").setRequirePartitionFilter(Boolean.valueOf(false)).setSourceUriPrefix(sourceUriPrefix).build();
                customTable = ExternalTableDefinition.newBuilder((String)sourceUri, (FormatOptions)FormatOptions.parquet()).setAutodetect(Boolean.valueOf(true)).setHivePartitioningOptions(hivePartitioningOptions).setIgnoreUnknownValues(Boolean.valueOf(true)).setMaxBadRecords(Integer.valueOf(0)).build();
            }
            this.bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)customTable), new BigQuery.TableOption[0]);
            LOG.info((Object)"External table created using hivepartitioningoptions");
        }
        catch (BigQueryException e) {
            throw new HoodieBigQuerySyncException("External table was not created ", e);
        }
    }

    public void createSnapshotView(String viewName, String versionsTableName, String manifestTableName) {
        try {
            TableId tableId = TableId.of((String)this.syncConfig.projectId, (String)this.syncConfig.datasetName, (String)viewName);
            String query = String.format("SELECT * FROM `%s.%s.%s` WHERE _hoodie_file_name IN (SELECT filename FROM `%s.%s.%s`)", this.syncConfig.projectId, this.syncConfig.datasetName, versionsTableName, this.syncConfig.projectId, this.syncConfig.datasetName, manifestTableName);
            ViewDefinition viewDefinition = ViewDefinition.newBuilder((String)query).setUseLegacySql(Boolean.valueOf(false)).build();
            this.bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)viewDefinition), new BigQuery.TableOption[0]);
            LOG.info((Object)"View created successfully");
        }
        catch (BigQueryException e) {
            throw new HoodieBigQuerySyncException("View was not created ", e);
        }
    }

    public Map<String, String> getTableSchema(String tableName) {
        return Collections.emptyMap();
    }

    public void addPartitionsToTable(String tableName, List<String> partitionsToAdd) {
        throw new UnsupportedOperationException("No support for addPartitionsToTable yet.");
    }

    public boolean datasetExists() {
        Dataset dataset = this.bigquery.getDataset(DatasetId.of((String)this.syncConfig.projectId, (String)this.syncConfig.datasetName), new BigQuery.DatasetOption[0]);
        return dataset != null;
    }

    public boolean doesTableExist(String tableName) {
        return this.tableExists(tableName);
    }

    public boolean tableExists(String tableName) {
        TableId tableId = TableId.of((String)this.syncConfig.projectId, (String)this.syncConfig.datasetName, (String)tableName);
        Table table = this.bigquery.getTable(tableId, new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])});
        return table != null && table.exists();
    }

    public Option<String> getLastCommitTimeSynced(String tableName) {
        throw new UnsupportedOperationException("Not support getLastCommitTimeSynced yet.");
    }

    public void updateLastCommitTimeSynced(String tableName) {
        throw new UnsupportedOperationException("No support for updateLastCommitTimeSynced yet.");
    }

    public Option<String> getLastReplicatedTime(String tableName) {
        throw new UnsupportedOperationException("Not support getLastReplicatedTime yet.");
    }

    public void updateLastReplicatedTimeStamp(String tableName, String timeStamp) {
        throw new UnsupportedOperationException("No support for updateLastReplicatedTimeStamp yet.");
    }

    public void deleteLastReplicatedTimeStamp(String tableName) {
        throw new UnsupportedOperationException("No support for deleteLastReplicatedTimeStamp yet.");
    }

    public void updatePartitionsToTable(String tableName, List<String> changedPartitions) {
        throw new UnsupportedOperationException("No support for updatePartitionsToTable yet.");
    }

    public void dropPartitions(String tableName, List<String> partitionsToDrop) {
        throw new UnsupportedOperationException("No support for dropPartitions yet.");
    }

    public void close() {
    }
}

