/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.gcp.bigquery;

import com.beust.jcommander.JCommander;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.gcp.bigquery.BigQuerySyncConfig;
import org.apache.hudi.gcp.bigquery.HoodieBigQuerySyncClient;
import org.apache.hudi.gcp.bigquery.HoodieBigQuerySyncException;
import org.apache.hudi.sync.common.AbstractSyncTool;
import org.apache.hudi.sync.common.util.ManifestFileWriter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class BigQuerySyncTool
extends AbstractSyncTool {
    private static final Logger LOG = LogManager.getLogger(BigQuerySyncTool.class);
    public final BigQuerySyncConfig cfg;
    public final String manifestTableName;
    public final String versionsTableName;
    public final String snapshotViewName;

    public BigQuerySyncTool(TypedProperties properties, Configuration conf, FileSystem fs) {
        super(properties, conf, fs);
        this.cfg = BigQuerySyncConfig.fromProps(properties);
        this.manifestTableName = this.cfg.tableName + "_manifest";
        this.versionsTableName = this.cfg.tableName + "_versions";
        this.snapshotViewName = this.cfg.tableName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void syncHoodieTable() {
        try (HoodieBigQuerySyncClient bqSyncClient = new HoodieBigQuerySyncClient(BigQuerySyncConfig.fromProps(this.props), this.fs);){
            switch (bqSyncClient.getTableType()) {
                case COPY_ON_WRITE: {
                    this.syncCoWTable(bqSyncClient);
                    return;
                }
                default: {
                    throw new UnsupportedOperationException(bqSyncClient.getTableType() + " table type is not supported yet.");
                }
            }
        }
        catch (Exception e) {
            throw new HoodieBigQuerySyncException("Got runtime exception when big query syncing " + this.cfg.tableName, e);
        }
    }

    private void syncCoWTable(HoodieBigQuerySyncClient bqSyncClient) {
        ValidationUtils.checkState((bqSyncClient.getTableType() == HoodieTableType.COPY_ON_WRITE ? 1 : 0) != 0);
        LOG.info((Object)("Sync hoodie table " + this.snapshotViewName + " at base path " + bqSyncClient.getBasePath()));
        if (!bqSyncClient.datasetExists()) {
            throw new HoodieBigQuerySyncException("Dataset not found: " + this.cfg);
        }
        ManifestFileWriter manifestFileWriter = ManifestFileWriter.builder().setConf(this.conf).setBasePath(this.cfg.basePath).setUseFileListingFromMetadata(this.cfg.useFileListingFromMetadata.booleanValue()).setAssumeDatePartitioning(this.cfg.assumeDatePartitioning.booleanValue()).build();
        manifestFileWriter.writeManifestFile();
        if (!bqSyncClient.tableExists(this.manifestTableName)) {
            bqSyncClient.createManifestTable(this.manifestTableName, manifestFileWriter.getManifestSourceUri());
            LOG.info((Object)("Manifest table creation complete for " + this.manifestTableName));
        }
        if (!bqSyncClient.tableExists(this.versionsTableName)) {
            bqSyncClient.createVersionsTable(this.versionsTableName, this.cfg.sourceUri, this.cfg.sourceUriPrefix, this.cfg.partitionFields);
            LOG.info((Object)("Versions table creation complete for " + this.versionsTableName));
        }
        if (!bqSyncClient.tableExists(this.snapshotViewName)) {
            bqSyncClient.createSnapshotView(this.snapshotViewName, this.versionsTableName, this.manifestTableName);
            LOG.info((Object)("Snapshot view creation complete for " + this.snapshotViewName));
        }
        LOG.info((Object)("Sync table complete for " + this.snapshotViewName));
    }

    public static void main(String[] args) {
        BigQuerySyncConfig cfg = new BigQuerySyncConfig();
        JCommander cmd = new JCommander((Object)cfg, null, args);
        if (cfg.help.booleanValue() || args.length == 0) {
            cmd.usage();
            System.exit(1);
        }
        FileSystem fs = FSUtils.getFs((String)cfg.basePath, (Configuration)new Configuration());
        new BigQuerySyncTool(cfg.toProps(), fs.getConf(), fs).syncHoodieTable();
    }
}

