/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */
package org.apache.hudi.avro.model;

import org.apache.avro.generic.GenericArray;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.util.Utf8;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.SchemaStore;

@org.apache.avro.specific.AvroGenerated
public class HoodieRecordIndexInfo extends org.apache.avro.specific.SpecificRecordBase implements org.apache.avro.specific.SpecificRecord {
  private static final long serialVersionUID = -459739777345513176L;
  public static final org.apache.avro.Schema SCHEMA$ = new org.apache.avro.Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieRecordIndexInfo\",\"namespace\":\"org.apache.hudi.avro.model\",\"fields\":[{\"name\":\"partitionName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Refers to the partition name the record belongs to\",\"default\":null},{\"name\":\"fileIdHighBits\",\"type\":[\"null\",\"long\"],\"doc\":\"Refers to high 64 bits if the fileId is based on UUID format. \\nA UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). \\nFileID format is {UUID}-{fileIndex}.\",\"default\":null},{\"name\":\"fileIdLowBits\",\"type\":[\"null\",\"long\"],\"doc\":\"Refers to low 64 bits if the fileId is based on UUID format. \\nA UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). \\nFileID format is {UUID}-{fileIndex}.\",\"default\":null},{\"name\":\"fileIndex\",\"type\":[\"null\",\"int\"],\"doc\":\"Index representing file index which is used to re-construct UUID based fileID. Applicable when the fileId is based on UUID format. \\nA UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). \\nFileID format is {UUID}-{fileIndex}.\",\"default\":null},{\"name\":\"fileId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Represents fileId of the location where record belongs to. When the encoding is 1, fileID is stored in raw string format.\",\"default\":null},{\"name\":\"instantTime\",\"type\":[\"null\",\"long\"],\"doc\":\"Epoch time in millisecond representing the commit time at which record was added\",\"default\":null},{\"name\":\"fileIdEncoding\",\"type\":\"int\",\"doc\":\"Represents fileId encoding. Possible values are 0 and 1. O represents UUID based fileID, and 1 represents raw string format of the fileId. \\nWhen the encoding is 0, reader can deduce fileID from fileIdLowBits, fileIdLowBits and fileIndex.\",\"default\":0}]}");
  public static org.apache.avro.Schema getClassSchema() { return SCHEMA$; }

  private static SpecificData MODEL$ = new SpecificData();

  private static final BinaryMessageEncoder<HoodieRecordIndexInfo> ENCODER =
      new BinaryMessageEncoder<HoodieRecordIndexInfo>(MODEL$, SCHEMA$);

  private static final BinaryMessageDecoder<HoodieRecordIndexInfo> DECODER =
      new BinaryMessageDecoder<HoodieRecordIndexInfo>(MODEL$, SCHEMA$);

  /**
   * Return the BinaryMessageEncoder instance used by this class.
   * @return the message encoder used by this class
   */
  public static BinaryMessageEncoder<HoodieRecordIndexInfo> getEncoder() {
    return ENCODER;
  }

  /**
   * Return the BinaryMessageDecoder instance used by this class.
   * @return the message decoder used by this class
   */
  public static BinaryMessageDecoder<HoodieRecordIndexInfo> getDecoder() {
    return DECODER;
  }

  /**
   * Create a new BinaryMessageDecoder instance for this class that uses the specified {@link SchemaStore}.
   * @param resolver a {@link SchemaStore} used to find schemas by fingerprint
   * @return a BinaryMessageDecoder instance for this class backed by the given SchemaStore
   */
  public static BinaryMessageDecoder<HoodieRecordIndexInfo> createDecoder(SchemaStore resolver) {
    return new BinaryMessageDecoder<HoodieRecordIndexInfo>(MODEL$, SCHEMA$, resolver);
  }

  /**
   * Serializes this HoodieRecordIndexInfo to a ByteBuffer.
   * @return a buffer holding the serialized data for this instance
   * @throws java.io.IOException if this instance could not be serialized
   */
  public java.nio.ByteBuffer toByteBuffer() throws java.io.IOException {
    return ENCODER.encode(this);
  }

  /**
   * Deserializes a HoodieRecordIndexInfo from a ByteBuffer.
   * @param b a byte buffer holding serialized data for an instance of this class
   * @return a HoodieRecordIndexInfo instance decoded from the given buffer
   * @throws java.io.IOException if the given bytes could not be deserialized into an instance of this class
   */
  public static HoodieRecordIndexInfo fromByteBuffer(
      java.nio.ByteBuffer b) throws java.io.IOException {
    return DECODER.decode(b);
  }

  /** Refers to the partition name the record belongs to */
   private java.lang.String partitionName;
  /** Refers to high 64 bits if the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}. */
   private java.lang.Long fileIdHighBits;
  /** Refers to low 64 bits if the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}. */
   private java.lang.Long fileIdLowBits;
  /** Index representing file index which is used to re-construct UUID based fileID. Applicable when the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}. */
   private java.lang.Integer fileIndex;
  /** Represents fileId of the location where record belongs to. When the encoding is 1, fileID is stored in raw string format. */
   private java.lang.String fileId;
  /** Epoch time in millisecond representing the commit time at which record was added */
   private java.lang.Long instantTime;
  /** Represents fileId encoding. Possible values are 0 and 1. O represents UUID based fileID, and 1 represents raw string format of the fileId. 
When the encoding is 0, reader can deduce fileID from fileIdLowBits, fileIdLowBits and fileIndex. */
   private int fileIdEncoding;

  /**
   * Default constructor.  Note that this does not initialize fields
   * to their default values from the schema.  If that is desired then
   * one should use <code>newBuilder()</code>.
   */
  public HoodieRecordIndexInfo() {}

  /**
   * All-args constructor.
   * @param partitionName Refers to the partition name the record belongs to
   * @param fileIdHighBits Refers to high 64 bits if the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
   * @param fileIdLowBits Refers to low 64 bits if the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
   * @param fileIndex Index representing file index which is used to re-construct UUID based fileID. Applicable when the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
   * @param fileId Represents fileId of the location where record belongs to. When the encoding is 1, fileID is stored in raw string format.
   * @param instantTime Epoch time in millisecond representing the commit time at which record was added
   * @param fileIdEncoding Represents fileId encoding. Possible values are 0 and 1. O represents UUID based fileID, and 1 represents raw string format of the fileId. 
When the encoding is 0, reader can deduce fileID from fileIdLowBits, fileIdLowBits and fileIndex.
   */
  public HoodieRecordIndexInfo(java.lang.String partitionName, java.lang.Long fileIdHighBits, java.lang.Long fileIdLowBits, java.lang.Integer fileIndex, java.lang.String fileId, java.lang.Long instantTime, java.lang.Integer fileIdEncoding) {
    this.partitionName = partitionName;
    this.fileIdHighBits = fileIdHighBits;
    this.fileIdLowBits = fileIdLowBits;
    this.fileIndex = fileIndex;
    this.fileId = fileId;
    this.instantTime = instantTime;
    this.fileIdEncoding = fileIdEncoding;
  }

  public org.apache.avro.specific.SpecificData getSpecificData() { return MODEL$; }
  public org.apache.avro.Schema getSchema() { return SCHEMA$; }
  // Used by DatumWriter.  Applications should not call.
  public java.lang.Object get(int field$) {
    switch (field$) {
    case 0: return partitionName;
    case 1: return fileIdHighBits;
    case 2: return fileIdLowBits;
    case 3: return fileIndex;
    case 4: return fileId;
    case 5: return instantTime;
    case 6: return fileIdEncoding;
    default: throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }
  }

  // Used by DatumReader.  Applications should not call.
  @SuppressWarnings(value="unchecked")
  public void put(int field$, java.lang.Object value$) {
    switch (field$) {
    case 0: partitionName = value$ != null ? value$.toString() : null; break;
    case 1: fileIdHighBits = (java.lang.Long)value$; break;
    case 2: fileIdLowBits = (java.lang.Long)value$; break;
    case 3: fileIndex = (java.lang.Integer)value$; break;
    case 4: fileId = value$ != null ? value$.toString() : null; break;
    case 5: instantTime = (java.lang.Long)value$; break;
    case 6: fileIdEncoding = (java.lang.Integer)value$; break;
    default: throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }
  }

  /**
   * Gets the value of the 'partitionName' field.
   * @return Refers to the partition name the record belongs to
   */
  public java.lang.String getPartitionName() {
    return partitionName;
  }


  /**
   * Sets the value of the 'partitionName' field.
   * Refers to the partition name the record belongs to
   * @param value the value to set.
   */
  public void setPartitionName(java.lang.String value) {
    this.partitionName = value;
  }

  /**
   * Gets the value of the 'fileIdHighBits' field.
   * @return Refers to high 64 bits if the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
   */
  public java.lang.Long getFileIdHighBits() {
    return fileIdHighBits;
  }


  /**
   * Sets the value of the 'fileIdHighBits' field.
   * Refers to high 64 bits if the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
   * @param value the value to set.
   */
  public void setFileIdHighBits(java.lang.Long value) {
    this.fileIdHighBits = value;
  }

  /**
   * Gets the value of the 'fileIdLowBits' field.
   * @return Refers to low 64 bits if the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
   */
  public java.lang.Long getFileIdLowBits() {
    return fileIdLowBits;
  }


  /**
   * Sets the value of the 'fileIdLowBits' field.
   * Refers to low 64 bits if the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
   * @param value the value to set.
   */
  public void setFileIdLowBits(java.lang.Long value) {
    this.fileIdLowBits = value;
  }

  /**
   * Gets the value of the 'fileIndex' field.
   * @return Index representing file index which is used to re-construct UUID based fileID. Applicable when the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
   */
  public java.lang.Integer getFileIndex() {
    return fileIndex;
  }


  /**
   * Sets the value of the 'fileIndex' field.
   * Index representing file index which is used to re-construct UUID based fileID. Applicable when the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
   * @param value the value to set.
   */
  public void setFileIndex(java.lang.Integer value) {
    this.fileIndex = value;
  }

  /**
   * Gets the value of the 'fileId' field.
   * @return Represents fileId of the location where record belongs to. When the encoding is 1, fileID is stored in raw string format.
   */
  public java.lang.String getFileId() {
    return fileId;
  }


  /**
   * Sets the value of the 'fileId' field.
   * Represents fileId of the location where record belongs to. When the encoding is 1, fileID is stored in raw string format.
   * @param value the value to set.
   */
  public void setFileId(java.lang.String value) {
    this.fileId = value;
  }

  /**
   * Gets the value of the 'instantTime' field.
   * @return Epoch time in millisecond representing the commit time at which record was added
   */
  public java.lang.Long getInstantTime() {
    return instantTime;
  }


  /**
   * Sets the value of the 'instantTime' field.
   * Epoch time in millisecond representing the commit time at which record was added
   * @param value the value to set.
   */
  public void setInstantTime(java.lang.Long value) {
    this.instantTime = value;
  }

  /**
   * Gets the value of the 'fileIdEncoding' field.
   * @return Represents fileId encoding. Possible values are 0 and 1. O represents UUID based fileID, and 1 represents raw string format of the fileId. 
When the encoding is 0, reader can deduce fileID from fileIdLowBits, fileIdLowBits and fileIndex.
   */
  public int getFileIdEncoding() {
    return fileIdEncoding;
  }


  /**
   * Sets the value of the 'fileIdEncoding' field.
   * Represents fileId encoding. Possible values are 0 and 1. O represents UUID based fileID, and 1 represents raw string format of the fileId. 
When the encoding is 0, reader can deduce fileID from fileIdLowBits, fileIdLowBits and fileIndex.
   * @param value the value to set.
   */
  public void setFileIdEncoding(int value) {
    this.fileIdEncoding = value;
  }

  /**
   * Creates a new HoodieRecordIndexInfo RecordBuilder.
   * @return A new HoodieRecordIndexInfo RecordBuilder
   */
  public static org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder newBuilder() {
    return new org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder();
  }

  /**
   * Creates a new HoodieRecordIndexInfo RecordBuilder by copying an existing Builder.
   * @param other The existing builder to copy.
   * @return A new HoodieRecordIndexInfo RecordBuilder
   */
  public static org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder newBuilder(org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder other) {
    if (other == null) {
      return new org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder();
    } else {
      return new org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder(other);
    }
  }

  /**
   * Creates a new HoodieRecordIndexInfo RecordBuilder by copying an existing HoodieRecordIndexInfo instance.
   * @param other The existing instance to copy.
   * @return A new HoodieRecordIndexInfo RecordBuilder
   */
  public static org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder newBuilder(org.apache.hudi.avro.model.HoodieRecordIndexInfo other) {
    if (other == null) {
      return new org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder();
    } else {
      return new org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder(other);
    }
  }

  /**
   * RecordBuilder for HoodieRecordIndexInfo instances.
   */
  @org.apache.avro.specific.AvroGenerated
  public static class Builder extends org.apache.avro.specific.SpecificRecordBuilderBase<HoodieRecordIndexInfo>
    implements org.apache.avro.data.RecordBuilder<HoodieRecordIndexInfo> {

    /** Refers to the partition name the record belongs to */
    private java.lang.String partitionName;
    /** Refers to high 64 bits if the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}. */
    private java.lang.Long fileIdHighBits;
    /** Refers to low 64 bits if the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}. */
    private java.lang.Long fileIdLowBits;
    /** Index representing file index which is used to re-construct UUID based fileID. Applicable when the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}. */
    private java.lang.Integer fileIndex;
    /** Represents fileId of the location where record belongs to. When the encoding is 1, fileID is stored in raw string format. */
    private java.lang.String fileId;
    /** Epoch time in millisecond representing the commit time at which record was added */
    private java.lang.Long instantTime;
    /** Represents fileId encoding. Possible values are 0 and 1. O represents UUID based fileID, and 1 represents raw string format of the fileId. 
When the encoding is 0, reader can deduce fileID from fileIdLowBits, fileIdLowBits and fileIndex. */
    private int fileIdEncoding;

    /** Creates a new Builder */
    private Builder() {
      super(SCHEMA$);
    }

    /**
     * Creates a Builder by copying an existing Builder.
     * @param other The existing Builder to copy.
     */
    private Builder(org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder other) {
      super(other);
      if (isValidValue(fields()[0], other.partitionName)) {
        this.partitionName = data().deepCopy(fields()[0].schema(), other.partitionName);
        fieldSetFlags()[0] = other.fieldSetFlags()[0];
      }
      if (isValidValue(fields()[1], other.fileIdHighBits)) {
        this.fileIdHighBits = data().deepCopy(fields()[1].schema(), other.fileIdHighBits);
        fieldSetFlags()[1] = other.fieldSetFlags()[1];
      }
      if (isValidValue(fields()[2], other.fileIdLowBits)) {
        this.fileIdLowBits = data().deepCopy(fields()[2].schema(), other.fileIdLowBits);
        fieldSetFlags()[2] = other.fieldSetFlags()[2];
      }
      if (isValidValue(fields()[3], other.fileIndex)) {
        this.fileIndex = data().deepCopy(fields()[3].schema(), other.fileIndex);
        fieldSetFlags()[3] = other.fieldSetFlags()[3];
      }
      if (isValidValue(fields()[4], other.fileId)) {
        this.fileId = data().deepCopy(fields()[4].schema(), other.fileId);
        fieldSetFlags()[4] = other.fieldSetFlags()[4];
      }
      if (isValidValue(fields()[5], other.instantTime)) {
        this.instantTime = data().deepCopy(fields()[5].schema(), other.instantTime);
        fieldSetFlags()[5] = other.fieldSetFlags()[5];
      }
      if (isValidValue(fields()[6], other.fileIdEncoding)) {
        this.fileIdEncoding = data().deepCopy(fields()[6].schema(), other.fileIdEncoding);
        fieldSetFlags()[6] = other.fieldSetFlags()[6];
      }
    }

    /**
     * Creates a Builder by copying an existing HoodieRecordIndexInfo instance
     * @param other The existing instance to copy.
     */
    private Builder(org.apache.hudi.avro.model.HoodieRecordIndexInfo other) {
      super(SCHEMA$);
      if (isValidValue(fields()[0], other.partitionName)) {
        this.partitionName = data().deepCopy(fields()[0].schema(), other.partitionName);
        fieldSetFlags()[0] = true;
      }
      if (isValidValue(fields()[1], other.fileIdHighBits)) {
        this.fileIdHighBits = data().deepCopy(fields()[1].schema(), other.fileIdHighBits);
        fieldSetFlags()[1] = true;
      }
      if (isValidValue(fields()[2], other.fileIdLowBits)) {
        this.fileIdLowBits = data().deepCopy(fields()[2].schema(), other.fileIdLowBits);
        fieldSetFlags()[2] = true;
      }
      if (isValidValue(fields()[3], other.fileIndex)) {
        this.fileIndex = data().deepCopy(fields()[3].schema(), other.fileIndex);
        fieldSetFlags()[3] = true;
      }
      if (isValidValue(fields()[4], other.fileId)) {
        this.fileId = data().deepCopy(fields()[4].schema(), other.fileId);
        fieldSetFlags()[4] = true;
      }
      if (isValidValue(fields()[5], other.instantTime)) {
        this.instantTime = data().deepCopy(fields()[5].schema(), other.instantTime);
        fieldSetFlags()[5] = true;
      }
      if (isValidValue(fields()[6], other.fileIdEncoding)) {
        this.fileIdEncoding = data().deepCopy(fields()[6].schema(), other.fileIdEncoding);
        fieldSetFlags()[6] = true;
      }
    }

    /**
      * Gets the value of the 'partitionName' field.
      * Refers to the partition name the record belongs to
      * @return The value.
      */
    public java.lang.String getPartitionName() {
      return partitionName;
    }


    /**
      * Sets the value of the 'partitionName' field.
      * Refers to the partition name the record belongs to
      * @param value The value of 'partitionName'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder setPartitionName(java.lang.String value) {
      validate(fields()[0], value);
      this.partitionName = value;
      fieldSetFlags()[0] = true;
      return this;
    }

    /**
      * Checks whether the 'partitionName' field has been set.
      * Refers to the partition name the record belongs to
      * @return True if the 'partitionName' field has been set, false otherwise.
      */
    public boolean hasPartitionName() {
      return fieldSetFlags()[0];
    }


    /**
      * Clears the value of the 'partitionName' field.
      * Refers to the partition name the record belongs to
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder clearPartitionName() {
      partitionName = null;
      fieldSetFlags()[0] = false;
      return this;
    }

    /**
      * Gets the value of the 'fileIdHighBits' field.
      * Refers to high 64 bits if the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
      * @return The value.
      */
    public java.lang.Long getFileIdHighBits() {
      return fileIdHighBits;
    }


    /**
      * Sets the value of the 'fileIdHighBits' field.
      * Refers to high 64 bits if the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
      * @param value The value of 'fileIdHighBits'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder setFileIdHighBits(java.lang.Long value) {
      validate(fields()[1], value);
      this.fileIdHighBits = value;
      fieldSetFlags()[1] = true;
      return this;
    }

    /**
      * Checks whether the 'fileIdHighBits' field has been set.
      * Refers to high 64 bits if the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
      * @return True if the 'fileIdHighBits' field has been set, false otherwise.
      */
    public boolean hasFileIdHighBits() {
      return fieldSetFlags()[1];
    }


    /**
      * Clears the value of the 'fileIdHighBits' field.
      * Refers to high 64 bits if the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder clearFileIdHighBits() {
      fileIdHighBits = null;
      fieldSetFlags()[1] = false;
      return this;
    }

    /**
      * Gets the value of the 'fileIdLowBits' field.
      * Refers to low 64 bits if the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
      * @return The value.
      */
    public java.lang.Long getFileIdLowBits() {
      return fileIdLowBits;
    }


    /**
      * Sets the value of the 'fileIdLowBits' field.
      * Refers to low 64 bits if the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
      * @param value The value of 'fileIdLowBits'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder setFileIdLowBits(java.lang.Long value) {
      validate(fields()[2], value);
      this.fileIdLowBits = value;
      fieldSetFlags()[2] = true;
      return this;
    }

    /**
      * Checks whether the 'fileIdLowBits' field has been set.
      * Refers to low 64 bits if the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
      * @return True if the 'fileIdLowBits' field has been set, false otherwise.
      */
    public boolean hasFileIdLowBits() {
      return fieldSetFlags()[2];
    }


    /**
      * Clears the value of the 'fileIdLowBits' field.
      * Refers to low 64 bits if the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder clearFileIdLowBits() {
      fileIdLowBits = null;
      fieldSetFlags()[2] = false;
      return this;
    }

    /**
      * Gets the value of the 'fileIndex' field.
      * Index representing file index which is used to re-construct UUID based fileID. Applicable when the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
      * @return The value.
      */
    public java.lang.Integer getFileIndex() {
      return fileIndex;
    }


    /**
      * Sets the value of the 'fileIndex' field.
      * Index representing file index which is used to re-construct UUID based fileID. Applicable when the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
      * @param value The value of 'fileIndex'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder setFileIndex(java.lang.Integer value) {
      validate(fields()[3], value);
      this.fileIndex = value;
      fieldSetFlags()[3] = true;
      return this;
    }

    /**
      * Checks whether the 'fileIndex' field has been set.
      * Index representing file index which is used to re-construct UUID based fileID. Applicable when the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
      * @return True if the 'fileIndex' field has been set, false otherwise.
      */
    public boolean hasFileIndex() {
      return fieldSetFlags()[3];
    }


    /**
      * Clears the value of the 'fileIndex' field.
      * Index representing file index which is used to re-construct UUID based fileID. Applicable when the fileId is based on UUID format. 
A UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). 
FileID format is {UUID}-{fileIndex}.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder clearFileIndex() {
      fileIndex = null;
      fieldSetFlags()[3] = false;
      return this;
    }

    /**
      * Gets the value of the 'fileId' field.
      * Represents fileId of the location where record belongs to. When the encoding is 1, fileID is stored in raw string format.
      * @return The value.
      */
    public java.lang.String getFileId() {
      return fileId;
    }


    /**
      * Sets the value of the 'fileId' field.
      * Represents fileId of the location where record belongs to. When the encoding is 1, fileID is stored in raw string format.
      * @param value The value of 'fileId'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder setFileId(java.lang.String value) {
      validate(fields()[4], value);
      this.fileId = value;
      fieldSetFlags()[4] = true;
      return this;
    }

    /**
      * Checks whether the 'fileId' field has been set.
      * Represents fileId of the location where record belongs to. When the encoding is 1, fileID is stored in raw string format.
      * @return True if the 'fileId' field has been set, false otherwise.
      */
    public boolean hasFileId() {
      return fieldSetFlags()[4];
    }


    /**
      * Clears the value of the 'fileId' field.
      * Represents fileId of the location where record belongs to. When the encoding is 1, fileID is stored in raw string format.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder clearFileId() {
      fileId = null;
      fieldSetFlags()[4] = false;
      return this;
    }

    /**
      * Gets the value of the 'instantTime' field.
      * Epoch time in millisecond representing the commit time at which record was added
      * @return The value.
      */
    public java.lang.Long getInstantTime() {
      return instantTime;
    }


    /**
      * Sets the value of the 'instantTime' field.
      * Epoch time in millisecond representing the commit time at which record was added
      * @param value The value of 'instantTime'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder setInstantTime(java.lang.Long value) {
      validate(fields()[5], value);
      this.instantTime = value;
      fieldSetFlags()[5] = true;
      return this;
    }

    /**
      * Checks whether the 'instantTime' field has been set.
      * Epoch time in millisecond representing the commit time at which record was added
      * @return True if the 'instantTime' field has been set, false otherwise.
      */
    public boolean hasInstantTime() {
      return fieldSetFlags()[5];
    }


    /**
      * Clears the value of the 'instantTime' field.
      * Epoch time in millisecond representing the commit time at which record was added
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder clearInstantTime() {
      instantTime = null;
      fieldSetFlags()[5] = false;
      return this;
    }

    /**
      * Gets the value of the 'fileIdEncoding' field.
      * Represents fileId encoding. Possible values are 0 and 1. O represents UUID based fileID, and 1 represents raw string format of the fileId. 
When the encoding is 0, reader can deduce fileID from fileIdLowBits, fileIdLowBits and fileIndex.
      * @return The value.
      */
    public int getFileIdEncoding() {
      return fileIdEncoding;
    }


    /**
      * Sets the value of the 'fileIdEncoding' field.
      * Represents fileId encoding. Possible values are 0 and 1. O represents UUID based fileID, and 1 represents raw string format of the fileId. 
When the encoding is 0, reader can deduce fileID from fileIdLowBits, fileIdLowBits and fileIndex.
      * @param value The value of 'fileIdEncoding'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder setFileIdEncoding(int value) {
      validate(fields()[6], value);
      this.fileIdEncoding = value;
      fieldSetFlags()[6] = true;
      return this;
    }

    /**
      * Checks whether the 'fileIdEncoding' field has been set.
      * Represents fileId encoding. Possible values are 0 and 1. O represents UUID based fileID, and 1 represents raw string format of the fileId. 
When the encoding is 0, reader can deduce fileID from fileIdLowBits, fileIdLowBits and fileIndex.
      * @return True if the 'fileIdEncoding' field has been set, false otherwise.
      */
    public boolean hasFileIdEncoding() {
      return fieldSetFlags()[6];
    }


    /**
      * Clears the value of the 'fileIdEncoding' field.
      * Represents fileId encoding. Possible values are 0 and 1. O represents UUID based fileID, and 1 represents raw string format of the fileId. 
When the encoding is 0, reader can deduce fileID from fileIdLowBits, fileIdLowBits and fileIndex.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieRecordIndexInfo.Builder clearFileIdEncoding() {
      fieldSetFlags()[6] = false;
      return this;
    }

    @Override
    @SuppressWarnings("unchecked")
    public HoodieRecordIndexInfo build() {
      try {
        HoodieRecordIndexInfo record = new HoodieRecordIndexInfo();
        record.partitionName = fieldSetFlags()[0] ? this.partitionName : (java.lang.String) defaultValue(fields()[0]);
        record.fileIdHighBits = fieldSetFlags()[1] ? this.fileIdHighBits : (java.lang.Long) defaultValue(fields()[1]);
        record.fileIdLowBits = fieldSetFlags()[2] ? this.fileIdLowBits : (java.lang.Long) defaultValue(fields()[2]);
        record.fileIndex = fieldSetFlags()[3] ? this.fileIndex : (java.lang.Integer) defaultValue(fields()[3]);
        record.fileId = fieldSetFlags()[4] ? this.fileId : (java.lang.String) defaultValue(fields()[4]);
        record.instantTime = fieldSetFlags()[5] ? this.instantTime : (java.lang.Long) defaultValue(fields()[5]);
        record.fileIdEncoding = fieldSetFlags()[6] ? this.fileIdEncoding : (java.lang.Integer) defaultValue(fields()[6]);
        return record;
      } catch (org.apache.avro.AvroMissingFieldException e) {
        throw e;
      } catch (java.lang.Exception e) {
        throw new org.apache.avro.AvroRuntimeException(e);
      }
    }
  }

  @SuppressWarnings("unchecked")
  private static final org.apache.avro.io.DatumWriter<HoodieRecordIndexInfo>
    WRITER$ = (org.apache.avro.io.DatumWriter<HoodieRecordIndexInfo>)MODEL$.createDatumWriter(SCHEMA$);

  @Override public void writeExternal(java.io.ObjectOutput out)
    throws java.io.IOException {
    WRITER$.write(this, SpecificData.getEncoder(out));
  }

  @SuppressWarnings("unchecked")
  private static final org.apache.avro.io.DatumReader<HoodieRecordIndexInfo>
    READER$ = (org.apache.avro.io.DatumReader<HoodieRecordIndexInfo>)MODEL$.createDatumReader(SCHEMA$);

  @Override public void readExternal(java.io.ObjectInput in)
    throws java.io.IOException {
    READER$.read(this, SpecificData.getDecoder(in));
  }

  @Override protected boolean hasCustomCoders() { return true; }

  @Override public void customEncode(org.apache.avro.io.Encoder out)
    throws java.io.IOException
  {
    if (this.partitionName == null) {
      out.writeIndex(0);
      out.writeNull();
    } else {
      out.writeIndex(1);
      out.writeString(this.partitionName);
    }

    if (this.fileIdHighBits == null) {
      out.writeIndex(0);
      out.writeNull();
    } else {
      out.writeIndex(1);
      out.writeLong(this.fileIdHighBits);
    }

    if (this.fileIdLowBits == null) {
      out.writeIndex(0);
      out.writeNull();
    } else {
      out.writeIndex(1);
      out.writeLong(this.fileIdLowBits);
    }

    if (this.fileIndex == null) {
      out.writeIndex(0);
      out.writeNull();
    } else {
      out.writeIndex(1);
      out.writeInt(this.fileIndex);
    }

    if (this.fileId == null) {
      out.writeIndex(0);
      out.writeNull();
    } else {
      out.writeIndex(1);
      out.writeString(this.fileId);
    }

    if (this.instantTime == null) {
      out.writeIndex(0);
      out.writeNull();
    } else {
      out.writeIndex(1);
      out.writeLong(this.instantTime);
    }

    out.writeInt(this.fileIdEncoding);

  }

  @Override public void customDecode(org.apache.avro.io.ResolvingDecoder in)
    throws java.io.IOException
  {
    org.apache.avro.Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
    if (fieldOrder == null) {
      if (in.readIndex() != 1) {
        in.readNull();
        this.partitionName = null;
      } else {
        this.partitionName = in.readString();
      }

      if (in.readIndex() != 1) {
        in.readNull();
        this.fileIdHighBits = null;
      } else {
        this.fileIdHighBits = in.readLong();
      }

      if (in.readIndex() != 1) {
        in.readNull();
        this.fileIdLowBits = null;
      } else {
        this.fileIdLowBits = in.readLong();
      }

      if (in.readIndex() != 1) {
        in.readNull();
        this.fileIndex = null;
      } else {
        this.fileIndex = in.readInt();
      }

      if (in.readIndex() != 1) {
        in.readNull();
        this.fileId = null;
      } else {
        this.fileId = in.readString();
      }

      if (in.readIndex() != 1) {
        in.readNull();
        this.instantTime = null;
      } else {
        this.instantTime = in.readLong();
      }

      this.fileIdEncoding = in.readInt();

    } else {
      for (int i = 0; i < 7; i++) {
        switch (fieldOrder[i].pos()) {
        case 0:
          if (in.readIndex() != 1) {
            in.readNull();
            this.partitionName = null;
          } else {
            this.partitionName = in.readString();
          }
          break;

        case 1:
          if (in.readIndex() != 1) {
            in.readNull();
            this.fileIdHighBits = null;
          } else {
            this.fileIdHighBits = in.readLong();
          }
          break;

        case 2:
          if (in.readIndex() != 1) {
            in.readNull();
            this.fileIdLowBits = null;
          } else {
            this.fileIdLowBits = in.readLong();
          }
          break;

        case 3:
          if (in.readIndex() != 1) {
            in.readNull();
            this.fileIndex = null;
          } else {
            this.fileIndex = in.readInt();
          }
          break;

        case 4:
          if (in.readIndex() != 1) {
            in.readNull();
            this.fileId = null;
          } else {
            this.fileId = in.readString();
          }
          break;

        case 5:
          if (in.readIndex() != 1) {
            in.readNull();
            this.instantTime = null;
          } else {
            this.instantTime = in.readLong();
          }
          break;

        case 6:
          this.fileIdEncoding = in.readInt();
          break;

        default:
          throw new java.io.IOException("Corrupt ResolvingDecoder.");
        }
      }
    }
  }
}










